
    <style>
        /* Estilo para hacer el toggle más grande y en rojo */
        .form-check-input {
            width: 3rem;
            height: 1.5rem;
            background-color: red;
            border-radius: 1rem;
        }
        .form-check-input:checked {
            background-color: red;
        }
    </style>

    <div class="container mt-5">
        <h2 class="mb-4">Lista de Productos</h2>
        <table class="table table-striped">
            <thead>
                <tr>
                    <th scope="col">Descripción</th>
                    <th scope="col">Costo</th>
                    <th scope="col">Existencia</th>
                    <th scope="col">Existencia Mínima</th>
                    <th scope="col">Alerta</th>
                </tr>
            </thead>
            <tbody>
                <?php
                // Arreglo de productos
                $productos = [
                    ['id' => 1, 'Codigo' => '', 'Descripcion_Corta' => 'Capuchino Avellana 16oz', 'Costo' => 0, 'Existencia' => -2],
                    ['id' => 2, 'Codigo' => '', 'Descripcion_Corta' => 'Capuchino Avellana 12oz', 'Costo' => 0, 'Existencia' => -1],
                    ['id' => 3, 'Codigo' => '', 'Descripcion_Corta' => 'Capuchino Clasico 16oz', 'Costo' => 0, 'Existencia' => -18],
                    ['id' => 4, 'Codigo' => '', 'Descripcion_Corta' => 'Capuchino Clasico 12oz', 'Costo' => 0, 'Existencia' => -10],
                    ['id' => 5, 'Codigo' => '', 'Descripcion_Corta' => 'Capuchino Irlandesa 12oz', 'Costo' => 0, 'Existencia' => -1],
                    ['id' => 6, 'Codigo' => '', 'Descripcion_Corta' => 'Capuchino Irlandesa 16oz', 'Costo' => 0, 'Existencia' => -1],
                    ['id' => 7, 'Codigo' => '', 'Descripcion_Corta' => 'Capuchino Caramelo 12oz', 'Costo' => 0, 'Existencia' => 0],
                    ['id' => 8, 'Codigo' => '', 'Descripcion_Corta' => 'Capuchino Caramelo 16oz', 'Costo' => 0, 'Existencia' => 0],
                    ['id' => 9, 'Codigo' => '', 'Descripcion_Corta' => 'Capuchino Vainilla 12oz', 'Costo' => 0, 'Existencia' => 0],
                    ['id' => 10, 'Codigo' => '', 'Descripcion_Corta' => 'Capuchino Vainilla 16oz', 'Costo' => 0, 'Existencia' => -2],
                ];

                // Definir la existencia mínima
                $existencia_minima = 0;

                // Generar la tabla
                foreach ($productos as $producto) {
                    echo '<tr>';
                    echo '<td>' . $producto['Descripcion_Corta'] . '</td>';
                    echo '<td>' . $producto['Costo'] . '</td>';
                    echo '<td>' . $producto['Existencia'] . '</td>';
                    echo '<td>' . $existencia_minima . '</td>';
                    echo '<td>';
                    echo '<div class="form-check form-switch">';
                    echo '<input class="form-check-input" type="checkbox" id="toggle' . $producto['id'] . '"';
                    echo $producto['Existencia'] < $existencia_minima ? ' checked' : '';
                    echo '>';
                    echo '</div>';
                    echo '</td>';
                    echo '</tr>';
                }
                ?>
            </tbody>
        </table>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
