
<style>
.pills-rounded .nav-item .nav-link {
    border-radius: 10em;
}
.pills-outline-red .nav-item .nav-link {
    border: 2px solid #fff;
    color: #666;
    background-color: transparent;
}
.pills-outline-red .nav-item .nav-link:hover {
    border: 2px solid #eee;
}
.pills-outline-red .nav-item .nav-link.active {
    border: 2px solid #f44336;
    color: #f44336;
}
.pills-outline-red .nav-item .nav-link.active:hover {
    border: 2px solid #f44336;
    color: #f44336;
}
.tabbable .nav-tabs {
    overflow-x: auto;
    overflow-y: hidden;
    flex-wrap: nowrap;
}
.tabbable .nav-tabs .nav-link {
    white-space: nowrap;
}
/* Estilos personalizados */
body {
    background-color: #f0f0f0;
}
.container {
    background-color: #fff;
    border-radius: 10px;
    padding: 20px;
    box-shadow: 0px 0px 10px rgba(0, 0, 0, 0.2);
}
.product-icon {
    width: 150px;
    height: 150px;
    text-align: center;
    cursor: pointer;
}
.product-icon i {
    font-size: 48px;
}
.product-icon.active {
    background-color: #007bff;
    color: #fff;
}
#product-list {
    background-color: #ffffff;
    border: 1px solid #e0e0e0;
    border-radius: 5px;
    padding: 10px;
}
#total-price {
    color: #007bff;
}
.btn-checkout {
    background-color: #28a745;
    color: #fff;
    border: none;
}
.remove-product {
    cursor: pointer;
    float: right;
    font-weight: bold;
    color: red;
}
.quantity-input {
    width: 60px;
    text-align: center;
}
.btn-quantity {
    font-size: 20px;
}
</style>
<div class="container">
  <div class="row page-titles mx-0">
    <div class="container-fluid">
		
   <nav class="tabbable">
    <div class="d-flex align-items-center"> <!-- Contenedor flex para alinear elementos -->
        <div class="dropdown">
           <button class="btn btn-secondary dropdown-toggle" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                <!-- Icono de FontAwesome -->
                <i class="fa fa-dollar"></i> 
            </button>
            <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                 <a class="dropdown-item" href="#" onClick="asignarNumeroSeleccionado(3)">Publico</a>
                <a class="dropdown-item" href="#" onClick="asignarNumeroSeleccionado(2)">Mayoreo</a>
                <a class="dropdown-item" href="#" onClick="asignarNumeroSeleccionado(1)">Distribuidor</a>
          
            </div>
        </div>

        <div class="nav nav-tabs ml-3" id="nav-tab" role="tablist"> <!-- Agregado ml-3 para márgenes a la izquierda -->
            <a class="nav-item nav-link active" id="nav-home-tab" onClick="cliente('Todo*', '0')" data-toggle="tab" href="#nav-home" role="tab" aria-controls="nav-home" aria-selected="true">
                <i class="icon-arrow-right"></i>
            </a>
            <?php
            // Genera 20 botones en un arreglo
            foreach ($categorias as $fila) {
                foreach ($fila as $valor) {
                    $botones[] = $valor;
                }
            }

            foreach ($botones as $index => $nombre) {
                echo "<a onClick=\"cliente($index, '$nombre')\" class=\"nav-item nav-link\" id=\"nav-$index-tab\" data-toggle=\"tab\" href=\"#nav-$index\" role=\"tab\" aria-controls=\"nav-$index\" aria-selected=\"false\">$nombre</a>";
            }
            ?>
        </div>
    </div>
</nav>

      <div class="tab-content pt-2" id="nav-tabContent">
        <div class="tab-pane fade show active" id="nav-home" role="tabpanel" aria-labelledby="nav-home-tab">Selecciona una Categoría</div>
        <?php
        // Recorre el arreglo de botones para generar los contenedores de botones
        foreach ( $categorias as $index => $nombre ) {
            echo "<div class=\"tab-pane fade\" id=\"nav-$index\" role=\"tabpanel\" aria-labelledby=\"nav-$index-tab\">";
            echo "<div id=\"containers$index\" class=\"slidable-container\">";
            echo "</div>";
            echo "</div>";
        }
        ?>
      </div>
    </div>
  </div>
  <div class="row"> 
    <!-- Lado izquierdo: Matriz de iconos de productos -->
    <div class="col-md-7">
      <h3>Productos Disponibles</h3>
		<div class="form-group">
        <input type="text" id="product-filter" class="form-control" onkeyup="filterProducts()" placeholder="Nombre del Producto">
</div>

      <div id="product-grid" class="row" style="max-height: 350px; overflow-y: auto;"></div>
    </div>
    <!-- Lado derecho: Lista de productos seleccionados -->
    <div class="col-md-5">
      <h3>Carrito</h3>
		<label id="tipoClienteLabel" class="text-muted"></label>

      <ul id="product-list" class="list-group">
      </ul>
      <h4>Total: <span id="total-price">$0.00</span></h4>
      
	<input type="text" name="MetodoP" id="selectedPaymentMethodText" class="form-control" value="Efectivo" readonly style="display: none;">
	<div class="form-group">
    <label for="Observaciones">Observaciones:</label>
    <textarea name="Observaciones" id="Observaciones" class="form-control" rows="3"></textarea>
</div>

	
	
	<div class="btn-group btn-block" role="group" aria-label="Basic example">
    <button type="button" id="selectPaymentMethod" class="btn btn-primary btn-sm col-2">
        <span id="paymentMethodName">Efectivo</span>
    </button>
    <button type="button" id="checkout-btn" name="<?php echo $areaN; ?>" id="<?php echo $areaN; ?>" class="btn btn-success">
        Pagar
    </button>
</div>
	
		
		
    </div>
  </div>
</div>

    <div class="modal" id="paymentMethodModal" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Selecciona un Método de Pago</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <select id="paymentMethodSelect" class="form-control">
                        <option value="Efectivo">Efectivo</option>
                        <option value="Tarjeta">Tarjeta</option>
                        <option value="Credito">Credito</option>
                    </select>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
                    <button type="button" id="confirmPaymentMethod" class="btn btn-primary">Confirmar</button>
                </div>
            </div>
        </div>
    </div>

<script>
	
	
	
	
    // Define una lista de productos con ID, nombre, precio, icono y descripción
    
const productGrid = document.getElementById("product-grid");
	// Define la variable selectedProductsArray antes de la función addToCart
const selectedProductsArray = [];
const products = [];
	
var totalt;
	  $(document).ready(function() {
        // Abre el modal al hacer clic en el botón "Seleccionar Método de Pago"
        $("#selectPaymentMethod").click(function() {
            $('#paymentMethodModal').modal('show');
        });

        // Captura el método de pago seleccionado al hacer clic en "Confirmar"
        $("#confirmPaymentMethod").click(function() {
            var selectedMethod = $("#paymentMethodSelect").val();
		    var selectedMethodName = $("#paymentMethodSelect option:selected").text();



            if (selectedMethod) {
			  $("#selectPaymentMethod").val(selectedMethod).text("Metodo: " + selectedMethodName);
             $('#selectedPaymentMethodText').val(selectedMethodName);
				 $('#paymentMethodModal').modal('hide');
            } else {
                alert("Por favor, selecciona un método de pago.");
            }
        });
    });
	
	
	// JavaScript para crear dinámicamente la matriz de iconos de productos
products.forEach((product) => {
    const productItem = document.createElement("div");
    productItem.className = "col-md-4 product-icon";
    productItem.innerHTML = `
        <i class="fas ${product.icon}"></i><br>${product.name}<br>$${product.price.toFixed(2)}<br>${product.description}
    `;

    productItem.addEventListener("click", () => {
        addToCart(product);
        productItem.classList.add("active");
    });

    productGrid.appendChild(productItem);
});


	


// Función para agregar productos al carrito
function addToCart(product) {
    const existingProduct = selectedProductsArray.find(p => p.id === product.id);
    if (existingProduct) {
        existingProduct.quantity++;
    } else {
        const newProduct = {
            id: product.id,
            name: product.name,
            price: product.price,
            description: product.description,
            quantity: 1
        };
        selectedProductsArray.push(newProduct);
    }

    // Actualiza la lista de productos seleccionados
    renderSelectedProducts();

    // Actualiza el total después de agregar un producto
    updateTotal();
}

// ... Resto de tu código ...


	
	
	
// Función para eliminar productos de la lista
function removeProduct(id) {
    const productId = id.toString();  // Convierte el id a cadena
    const index = selectedProductsArray.findIndex(product => product.id === productId);
    if (index !== -1) {
        selectedProductsArray.splice(index, 1);
        // Actualiza la lista y el total
        renderSelectedProducts();
        updateTotal();
    }
}

   // Función para renderizar la lista de productos seleccionados
function renderSelectedProducts() {
	//alert("m");
    const selectedList = document.getElementById("product-list");
    selectedList.innerHTML = '';
    selectedProductsArray.forEach(product => {
        const listItem = document.createElement("li");
        listItem.className = "list-group-item d-flex justify-content-between align-items-center";
        listItem.innerHTML = `
            <span class="col-md-6">${product.id} - ${product.description}</span>
            <div class="input-group"> 
                <button class="btn btn-quantity" onclick="decreaseQuantity(${product.id})"><i class="fa fa-minus-circle"></i></button>
                <button class="btn btn-quantity" onclick="increaseQuantity(${product.id})"><i class="fa fa-plus-circle"></i></button>
                <input type="text" class="form-control col-md-4 quantity-input" value="${product.quantity}" data-product-id="${product.id}" maxlength="3" size="4" onblur="updateQuantity(this)">
                <button class="btn btn-quantity" onclick="removeProduct(${product.id})"><i class="fa fa-times-circle btn-danger"></i></button>

            </div>
        `;

        selectedList.appendChild(listItem);
    });

    const removeButtons = selectedList.querySelectorAll('.remove-product');
    removeButtons.forEach(button => {
        button.addEventListener('click', () => removeProduct(button.dataset.id));
    });
}

	function updateQuantity(input) {
    const productId = input.getAttribute("data-product-id");
    const product = selectedProductsArray.find(p => p.id === productId);
    
    if (product) {
        const newQuantity = parseInt(input.value, 10);
        
        if (!isNaN(newQuantity) && newQuantity > 0) {
            product.quantity = newQuantity;
        } else {
            // Si la nueva cantidad no es válida, vuelve a establecer la cantidad original
            input.value = product.quantity;
        }

        // Actualiza la lista y el total
        renderSelectedProducts();
        updateTotal();
    }
}





    // Array para almacenar los productos seleccionados
    
    const totalElement = document.getElementById("total-price");



    // Función para actualizar el total
    function updateTotal() {
        const total = selectedProductsArray.reduce((acc, product) => acc + product.price * product.quantity, 0);
		totalt=total;
        totalElement.textContent = `$${total.toFixed(2)}`;
    }

    // Manejar la lógica de pago aquí
    // JavaScript para manejar la lógica de pago
    const checkoutButton = document.getElementById("checkout-btn");
    checkoutButton.addEventListener("click", () => {

var selectedPaymentMethodText = document.getElementById("selectedPaymentMethodText");
var valorSlect = selectedPaymentMethodText.value;
		
var ObservacionesText = document.getElementById("Observaciones");
var valorObs = ObservacionesText.value;
		
		
const boton = document.getElementById("checkout-btn");
	  boton.disabled = true;

var ur = "http://167.172.224.160/MiSi/librerias/ajax/ajaxInsertJSON.php?MetP="+valorSlect+"&Obs="+valorObs+"&CSel=1&tota="+totalt;	
 const agregar200 = confirm("¿Le gustaría agregar ahora al Libro en "+valorSlect+" "+totalt+" pesos?");
    if (agregar200) {
      
   	ur = "http://167.172.224.160/MiSi/librerias/ajax/ajaxInsertJSON.php?MetP="+valorSlect+"&Obs="+valorObs+"&CSel=1&tota="+totalt+"&libro=Si";	
    }
		
		
		
	
		// Serializa la lista de productos seleccionados con variables
        const serializedProducts = selectedProductsArray.map(product => {
            return {
              
                IDN: "@l_account_id",
				Cantidad: product.quantity,
                Precio: product.price,
                Descrpicion: product.description,
				Estado: "Cobrada",
				Conjunto_A: product.id,
				Conjunto_B: valorSlect
            };
        });

        // Muestra la lista serializada en una alerta
       // alert("¡Pago procesado!\n\nProductos:\n" + JSON.stringify(serializedProducts, null, 2));
		 var dataS = JSON.stringify(serializedProducts, null, 2);
		
		
		 $.ajax({
         data: dataS,
         type: "post",
         url: ur,
         success: function(data){
	//		  alert(data);
			 console.log(data);
			  if(data == "QUERY FAILED."){
				  
					$("#Mensaje").html(' <div class="alert alert-danger alert-dismissible alert-alt fade show"><button type="button" class="close h-100" data-dismiss="alert" aria-label="Close"><span><i class="mdi mdi-close"></i></span></button><strong>Error </strong> No se guardo la informacion.</div>');

				  	 
					 setTimeout(function() {$('#MensajeM').hide();}, 2500);     
			  
			  }
				else{ 
					$("#Mensaje").html(' <div class="alert alert-success alert-dismissible alert-alt fade show"><button type="button" class="close h-100" data-dismiss="alert" aria-label="Close"><span><i class="mdi mdi-close"></i></span></button><strong>Listo </strong> Se agrego una aplicacion con exito.</div>');

					
            // URL del archivo PDF que deseas abrir
            var urlPDF = "../librerias/Impresora/tk_nota.php";
            
            // Opciones de la ventana emergente
            var opcionesVentana = "width=400,height=600";
            
            // Abrir la ventana emergente
            window.open(urlPDF, "VentanaPDF", opcionesVentana);
        
					setTimeout(function() {$('#Mensaje').hide();}, 2000);
					setTimeout(function() {$('#id-modal-1').modal('hide'); }, 1);
					setTimeout(function() {location.reload();}, 3500);					
			 
			  }
		 }
                    
	});
		
		
		
    });


// Función para aumentar la cantidad de un producto en la lista
function increaseQuantity(id) {
    const product = selectedProductsArray.find(p => p.id === id.toString());
    if (product) {
        product.quantity++;
        renderSelectedProducts();
        updateTotal();
    }
}

// Función para disminuir la cantidad de un producto en la lista
function decreaseQuantity(id) {
    const product = selectedProductsArray.find(p => p.id === id.toString());
    if (product && product.quantity > 1) {
        product.quantity--;
        renderSelectedProducts();
        updateTotal();
    }
}

// 
	
	
var productos;
var precio=3;

	function asignarNumeroSeleccionado(numero) {
        precio = numero;
        console.log("Cliente: " + precio);
        // Puedes realizar otras acciones o lógica aquí según tus necesidades
		var tipoClienteLabel = document.getElementById("tipoClienteLabel");
    switch (precio) {
        case 3:
            tipoClienteLabel.textContent = " Público";
            break;
        case 2:
            tipoClienteLabel.textContent = " Mayoreo";
            break;
        case 1:
            tipoClienteLabel.textContent = " Distribuidor";
            break;
        default:
            tipoClienteLabel.textContent = " Publico";
    }
    }
	
	
function cliente(id, nombre) {
	
    // Vacía el contenido de productGrid antes de agregar nuevos productos
    productGrid.innerHTML = "";
	//alert(id);
    // Realiza una solicitud AJAX al hacer clic en el botón
    $.ajax({
        url: 'http://167.172.224.160/MiSi/librerias/Tablas/TablaMatizMatrix.php',
        type: 'POST',
        data: {
            id: id,
            nombre: nombre,
			precio: precio
        },
        success: function(response) {
            const products = JSON.parse(response);
			productos=products;

            products.forEach((product) => {
                const productItem = document.createElement("div");
                productItem.className = "col-md-4 product-icon";
                productItem.innerHTML = `
                    <i class="fas ${product.icon}"></i><br>${product.id} - ${product.description}<br>$${parseFloat(product.price).toFixed(2)}<br>${product.name}
                `;

                // Al hacer clic en el icono, asigna las variables a las funciones correspondientes
                productItem.addEventListener("click", () => {
                    // Asegúrate de que addToCart reciba las variables correctas
                    addToCart({
                        id: product.id,
                        name: product.name,
                        price: parseFloat(product.price),
                        description: product.description
                    });
                    productItem.classList.add("active");
                });

                productGrid.appendChild(productItem);
            });
        },
        error: function(xhr, status, error) {
            alert("Error: " + error);
            console.error(error);
        }
    });
}

	
	function filterProducts() {
    const input = document.getElementById("product-filter");
    const filter = input.value.toLowerCase();  // Convierte el texto a minúsculas para hacer una búsqueda sin distinción entre mayúsculas y minúsculas

    // Filtra los productos que coinciden con el texto de búsqueda en la descripción
    const filteredProducts = productos.filter(product => product.description.toLowerCase().includes(filter));

    // Limpia el contenido del productGrid
    productGrid.innerHTML = "";

    // Vuelve a mostrar los productos filtrados en el productGrid
    filteredProducts.forEach(product => {
        const productItem = document.createElement("div");
        productItem.className = "col-md-4 product-icon";
        productItem.innerHTML = `
            <i class="fas ${product.icon}"></i><br>${product.id} - ${product.description}<br>$${parseFloat(product.price).toFixed(2)}<br>${product.name}
        `;

        productItem.addEventListener("click", () => {
            addToCart({
                id: product.id,
                name: product.name,
                price: parseFloat(product.price),
                description: product.description
            });
            productItem.classList.add("active");
        });

        productGrid.appendChild(productItem);
    });
}


</script> 
