<style>
    .menu-options {
        display: none;
        position: absolute;
        background-color: #fff;
        box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        padding: 5px 0;
    }
    .menu-options a {
        display: block;
        padding: 5px 10px;
        cursor: pointer;
    }
    .menu-options a:hover {
        background-color: #f2f2f2;
    }
    .btn-group {
        vertical-align: middle;
    }
    .btn-x2 i {
        font-size: 2em;
    }
    /* Agregar sombreado a la fila con el cursor encima */
    #miTabla tbody tr:hover {
        background-color: #f2f2f2;
    }
    /* Cambiar el color del texto de la tabla a negro */
    #miTabla td {
        color: black;
    }
</style>

<div class="row page-titles mx-0">
    <div class="col-sm-12 p-md-0">  
        <h3>Base de Datos <?php echo $_SESSION["Contenido"];?></h3>
        <div class="table-responsive">
            <table id="miTabla" class="table">
                <thead>
                    <tr>
                        <?php
                        // Verificar que $datos no esté vacío
                        if (!empty($datos) && is_array($datos) && !empty($datos[0]) && is_array($datos[0])) {
                            // Obtener nombres de las columnas
                            $columnas = array_keys($datos[0]);
                            foreach ($columnas as $columna) {
                                if ($columna !== 'Visible') {
                                    echo "<th>$columna" . (in_array($columna, $columnas_editables) ? "*" : "") . "</th>";
                                }
                            }
                            echo "<th>Acciones</th>";
                        } else {
                            echo "<th>No hay datos disponibles</th>";
                        }
                        ?>
                    </tr>
                </thead>
                <tbody>
                    <?php 
                    if (!empty($datos) && is_array($datos)) {
                     foreach ($datos as $row) {
						echo "<tr>";
						foreach ($row as $key => $value) {
							if ($key !== 'Visible') {
								$editable = in_array($key, $columnas_editables);
								$estadoAttribute = $key === 'Estado' ? "data-Estado='$value'" : "";
								echo "<td contenteditable='" . ($editable ? 'true' : 'false') . "' data-id='{$row["id"]}' data-column='{$key}' data-original-value='$value' $estadoAttribute>$value</td>";
							}
						}

						echo "<td class='btn-group'>";
						foreach ($iconos as $icono) {
							if ($icono["visible"]) {
								if ($icono["funcion"] === "menu") {
									echo "<div class='dropdown'>";
									echo "<button class='btn-icono btn btn-sm {$icono["tipo"]} btn-x2' data-toggle='dropdown'>";
									echo "<i class='{$icono["icono"]}'></i>";
									echo "</button>";
									echo "<div class='dropdown-menu menu-options'>";
									foreach ($opcionesMenu as $opcion) {
										echo "<a class='dropdown-item opcion-menu' data-opcion='" . $opcion[0] . "'>" . $opcion[1] . "</a>";
									}
									echo "</div>";
									echo "</div>";
								} else {
									$iconClass = $icono["funcion"] === "x2" ? "btn-x2" : "";

									// Aquí revisamos el estado y establecemos el icono y la clase apropiada
									if ($icono["funcion"] === "tongle") {
										$estado = $row['Estado'];
										$toggleClass = $estado === 'Disponible' ? 'fa-toggle-on text-success' : 'fa-toggle-off text-danger';
										echo "<button class='btn-icono btn btn-sm {$icono["tipo"]} {$iconClass}' data-funcion='{$icono["funcion"]}'>";
										echo "<i class='fa {$toggleClass}'></i>";
										echo "</button>";
									} else {
										echo "<button class='btn-icono btn btn-sm {$icono["tipo"]} {$iconClass}' data-funcion='{$icono["funcion"]}'>";
										echo "<i class='{$icono["icono"]}'></i>";
										echo "</button>";
									}
								}
							}
						}
						echo "</td>";
						echo "</tr>";
					}

                    } else {
                        echo "<tr><td colspan='100%'>No hay datos disponibles para mostrar.</td></tr>";
                    }
                    ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<script>
$(document).ready(function() {
    var table = $('#miTabla').DataTable({
        "lengthMenu": [ [10, 25, 50, 100, 1000], [10, 25, 50, 100, 1000] ], // Opciones de cantidad de resultados
        "pageLength": 1000, // Mostrar 1000 resultados por página por defecto
        "order": [[0, "desc"]], // Ordenar por la primera columna de manera descendente
        "language": {
            "url": "//cdn.datatables.net/plug-ins/1.10.24/i18n/Spanish.json"
        }
    });

    // Habilitar la edición de celdas
    $('#miTabla').on('blur', 'td[contenteditable="true"]', function() {
        var cell = table.cell(this);
        var id = $(this).data('id');
        var column = $(this).data('column');
        var newValue = $(this).text();
        var originalValue = $(this).data('original-value');
        
        if (newValue != originalValue) { 
            //alert("ID: " + id + ", Columna: " + column + ", Nuevo valor: " + newValue);
            $(this).data('original-value', newValue);
            editarTabla(id, column, newValue);
        }
        
        cell.data(newValue).draw();
    });

    // Mostrar opciones del menú al hacer clic en el icono de menú
    $('#miTabla').on('click', '.btn-icono[data-funcion="menu"]', function(event) {
        $(this).parent().find('.menu-options').toggle();
        event.stopPropagation(); // Evita que se cierre el menú al hacer clic en el botón
    });

    // Ocultar opciones del menú al hacer clic fuera del menú
    $(document).on('click', function(event) {
        if (!$(event.target).closest('.menu-options').length && !$(event.target).is('.btn-icono[data-funcion="menu"]')) {
            $('.menu-options').slideUp();
        }
    });

    // Ejecutar función correspondiente al hacer clic en las opciones del menú
    $('.menu-options').on('click', '.opcion-menu', function(event) {
        event.stopPropagation(); // Evita que se cierre el menú al hacer clic en la opción
        var opcion = $(this).data('opcion');
        var id = $(this).closest('tr').find('td[data-id]').data('id');
        TablaMenu(id, opcion);  
        // Agregar aquí las acciones correspondientes a las opciones del menú
    });

    // Ejecutar función correspondiente al hacer clic en el botón de icono
    $('#miTabla').on('click', '.btn-icono', function(event) {
        var id = $(this).closest('tr').find('td[data-id]').data('id');
        var estado = $(this).closest('tr').find('td[data-Estado]').data('estado');
		
        var funcion = $(this).data('funcion');
        switch(funcion) {
    		case 'tongle':
				var minimoIndex = 5;
				var $icon = $(this).find('i');
				var $row = $(this).closest('tr');
				var estado = $row.find('td[data-Estado]').data('estado');
				 var cant = $(this).closest('tr').find('td').eq(minimoIndex).text();
        			//alert(cant);

				if (estado === 'Disponible') {
					$icon.removeClass('fa-toggle-off text-danger').addClass('fa-toggle-on text-success');
					$(this).closest('tr').find('.menu-options').show();  // Ejemplo para mostrar un menú
				} else {
					$icon.removeClass('fa-toggle-on text-success').addClass('fa-toggle-off text-danger');
					$(this).closest('tr').find('.menu-options').hide();  // Ejemplo para ocultar un menú
				}

				// Cambiar el estado si es necesario (esto es solo un ejemplo, adapta según tu lógica)
				if ($icon.hasClass('fa-toggle-off')) {
					// Acción al encender
					$icon.removeClass('fa-toggle-off text-danger').addClass('fa-toggle-on text-success');
					$(this).closest('tr').find('.menu-options').show(); 
					TablaToggle(id,cant,'Disponible');
				} else {
					// Acción al apagar
					$icon.removeClass('fa-toggle-on text-success').addClass('fa-toggle-off text-danger');
					$(this).closest('tr').find('.menu-options').hide();
					TablaToggle(id,'0','NoDisponible');
				}
				break;
			case 'imagen':
                // Aquí iría la función para imagen
                TablaImagen(id);
                break;
            case 'impresion':
                TablaImpresion(id);
                break;
            case 'eliminar':
                // Aquí iría la función para eliminar
                TablaBorrar(id);
                break;
            case 'cancelar':
                // Aquí iría la función para eliminar
                //alert("Cancelar"+id+estado);
                if (estado != 'Cancelada')
                    TablaCancelar(id);
                else
                    alert("Esta Nota ya había sido cancelada, No puedes volver a cancelar.");
                break;  
            case 'editar':
                // Aquí iría la función para editar
                alert("Función editar");
                break;
			case 'editarBloque':
                // Aquí iría la función para editar
                 TablaEditarBloque(id);
                break;
			case 'editarColor':
                // Aquí iría la función para editar
                 textoColor(id);
             break;
				
			case 'paginaMensaje':
                // Aquí iría la función para editar
                 TablaPaginaMensaje(id);
             break;
			case 'editarDataForm':
                // Aquí iría la función para editar
                 textoDataForm(id);
             break;
				
		      case 'imgWEB':
                // Aquí iría la función para editar
                 ModalIMGWEB(id);
                break;	
			case 'editarMonilito':
                // Aquí iría la función para editar
                 openModal(id);
                break;	
				
			case 'editarTexto':
                // Aquí iría la función para editar
                 textoEditar(id);
                break;
				case 'editarForm':
                // Aquí iría la función para editar
                 formEditar(id);
                break;
				
			case 'editarTongle':
                // Aquí iría la función para editar
                 tongleEditar(id);
                break;	
            case 'menu':
                // No es necesario agregar nada aquí, el menú se maneja en los eventos anteriores
                break;
            case 'informacion':
                // Aquí iría la función para información
                TablaInformacion(id);
                break;
            case 'informacionR':
                // Aquí iría la función para información
                TablaInformacionR(id);
                break;
            case 'informacionV':
                // Aquí iría la función para información
                TablaInformacionV(id);
                break;    
            case 'informacionD':
                // Aquí iría la función para información
                TablaInformacionD(id);
                break;
            case 'informacionC':
                // Aquí iría la función para información
               TablaInformacionC(id);
                //TablaInformacionC(id);
                break;
            case 'cp':
                // Aquí iría la función para cp
                alert("Función cp");
                break;
            case 'p':
                // Aquí iría la función para p
                alert("Función p");
                break;
            case 'ca':
                // Aquí iría la función para ca
                alert("Función ca");
                break;
            default:
                break;
        }
    });
});
</script>
