<style>
.banner-izquierdo {
    overflow: hidden;
    white-space: nowrap;
}
	
  #listaProductosModal {
    max-height: 300px; /* Ajusta la altura máxima según sea necesario */
    overflow-y: auto;
  }

</style>

<div class="row page-titles mx-0"> 
  <!-- Banner en el lado izquierdo (md-2) -->
  <div class="col-md-2 border border-primary banner-izquierdo d-flex flex-wrap justify-content-center align-items-center"> 
    <!-- Contenido del banner izquierdo -->
    <?php
    // Número de iconos a generar
    $numeroIconos = 35;

    // Lista de clases de iconos de Font Awesome
    $clasesIconos = [
    "fa-bomb",
    "fa-birthday-cake",
    "fa-money",
    "fa-tv",
    "fa-coffee",
    "fa-gift",
    "fa-smile",
    "fa-sun",
    "fa-moon",
    "fa-heart",
    "fa-thumbs-up",
    "fa-thumbs-down",
    "fa-star",
    "fa-cloud",
    "fa-rainbow",
    "fa-umbrella",
    "fa-rocket",
    "fa-gamepad",
    "fa-music",
    "fa-camera",
    "fa-tree",
    "fa-car",
    "fa-plane",
    "fa-globe",
    "fa-clock",
    "fa-book",
    "fa-puzzle-piece",
    "fa-graduation-cap",
    "fa-certificate",
    "fa-bicycle",
    "fa-bus",
    "fa-train",
    "fa-ship",
    "fa-cube",
    "fa-paw",
    "fa-leaf",
    "fa-snowflake",
    "fa-crown",
    "fa-anchor",
    "fa-fire"
];


    // Generar los iconos con clases aleatorias
    for ( $i = 0; $i < $numeroIconos; $i++ ) {
        $claseIcono = $clasesIconos[ array_rand( $clasesIconos ) ];
        echo '<i class="fa ' . $claseIcono . ' fa-2x mx-2"></i>' . PHP_EOL;
    }
    ?>
  </div>
  
  <!-- Lista en el lado derecho (md-10) -->
  <div class="col-md-10 p-4 border border-secundary" >
    <h3>Lista Derecha</h3>
    
    <!-- Tabla para mostrar los datos con sombreado en los renglones -->
    <div style="max-height: 250px; overflow-y: auto;">
      <table class="table table-striped" id="tablaProductos">
        <thead>
          <tr>
			  <th scope="col" class="col-1">ID</th>
            <th scope="col" class="col-1">Código</th>
            <th scope="col" class="col-4">Descripción</th>
            <th scope="col" class="col-1">Cantidad</th>
            <th scope="col" class="col-1">Precio</th>
            <th scope="col" class="col-1">Acciones</th>
          </tr>
        </thead>
        <tbody>
          <!-- Aquí se generará la tabla dinámicamente con JavaScript -->
        </tbody>
      </table>
    </div>
    
    <!-- Espacio para mostrar el total y precio -->
    <div class="mt-3 border p-3 d-flex justify-content-between align-items-center w-100"> 
      <!-- Lado izquierdo -->
      <div>
        <h4>Total: <span class="text-success" id="total"></span></h4>
        <!-- Precio: Agregar el precio total de todos los productos aquí --> 
      </div>
      
      <!-- Lado derecho (botón) -->
     <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#modalCobro" id="btnCobrar">
  Cobrar
</button>
		     <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#modalCobroC" id="btnCobrarC">
  Cobrar
</button>
    </div>
  </div>
  
  <!-- Renglón inferior con formulario (md-12) -->
  <div class="col-md-12 border border-secundary">
    <h3>Scanner</h3>
    <div class="input-group mb-3">
      <input type="text" class="form-control" id="codigoIngresado" placeholder="Ingresa tu código aquí" aria-label="Ingresa tu código aquí" aria-describedby="btnGroupAddon">
      <div class="input-group-append">
        <button type="button" class="btn btn-primary"><i class="fa fa fa-arrow-right"></i></button>
        <button type="button" class="btn btn-success" data-toggle="modal" data-target="#agregarProductoModal"><i class="fa fa-plus-circle"></i></button>
        <button type="button" class="btn btn-info" data-toggle="modal" data-target="#productosModal" id="btnBuscar"><i class="fa fa-search"></i></button>
      </div>
    </div>
    
    <!-- Botones "Agregar" y "Buscar" con iconos --> 
  </div>
</div>
<div class="modal fade" id="productosModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">Seleccionar Producto</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"> <span aria-hidden="true">&times;</span> </button>
      </div>
      <div class="modal-body"> 
        <!-- Filtro de productos -->
        <input type="text" class="form-control mb-2" id="filtroProductos" placeholder="Filtrar productos">
        
        <!-- Lista de productos dinámica -->
        <ul id="listaProductosModal" class="list-group">
          <!-- Los productos se agregarán aquí dinámicamente -->
        </ul>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
      </div>
    </div>
  </div>
</div>
<div class="modal fade" id="agregarProductoModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">Agregar Producto</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"> <span aria-hidden="true">&times;</span> </button>
      </div>
      <div class="modal-body"> 
        <!-- Formulario para agregar producto -->
        <form id="formularioProducto">
          <div class="form-group">
            <label for="codigo">Código:</label>
            <input type="text" class="form-control" id="codigo" name="codigo" placeholder="Ingrese el código">
          </div>
          <div class="form-group">
            <label for="descripcion">Descripción:</label>
            <input type="text" class="form-control" id="descripcion" name="descripcion" placeholder="Ingrese la descripción">
          </div>
          <div class="form-group">
            <label for="cantidad">Cantidad:</label>
            <input type="number" class="form-control" id="cantidad" name="cantidad" placeholder="Ingrese la cantidad" min="1">
          </div>
          <div class="form-group">
            <label for="costo">Costo:</label>
            <input type="number" class="form-control" id="costo" name="costo" placeholder="Ingrese el costo" min="0.01">
          </div>
          <div class="form-group">
            <label for="precio">Precio:</label>
            <input type="number" class="form-control" id="precio" name="precio" placeholder="Ingrese el precio" min="0.01">
          </div>
          <button type="button" class="btn btn-primary" id="btnAgregarDBProducto" data-dismiss="modal">Agregar</button>
        </form>
      </div>
    </div>
  </div>
</div>
<?php
$productos = [
    ["id" => "1",  "codigo" => "101", "descripcion" => "Producto X", "precio" => "$25.00" ],
    ["id" => "2",  "codigo" => "102", "descripcion" => "Producto Y", "precio" => "$30.00" ],
    // Puedes agregar más productos aquí
];
?>

<!-- ... Tu código HTML anterior ... --> 

<script>
var catalogoProductos = <?php echo json_encode($productos); ?>;
var TotalT=0;
var ItemsT=0;	
var listaProductos = [];
	
document.addEventListener("DOMContentLoaded", function () {
  // Realizar la solicitud AJAX para obtener los productos
 
actualizarCatalogoProductos();
  // Resto de tu código...
});	

function convertirFormatoProductos(data) {
    var productosConvertidos = [];

    // Iterar sobre los productos recibidos
    data.forEach(function (producto) {
      // Ajusta las claves y tipos según la estructura real de tus datos
      productosConvertidos.push({
		id: String(producto[0]),  
        codigo: String(producto[1]),
        descripcion: String(producto[2]),
        precio: "$" + parseFloat(producto[3]).toFixed(2)
        // Puedes agregar más elementos según sea necesario
      });
    });

    return productosConvertidos;
  }
	
	



	// Declarar la variable inputCodigo fuera del ámbito actual
var inputCodigo;

document.addEventListener("DOMContentLoaded", function () {
  // Resto de tu código...

  // Obtener referencia al botón de búsqueda
  var btnBuscar = document.getElementById("btnBuscar");

  // Obtener referencia al botón de flecha
  var btnArrowRight = document.querySelector(".input-group-append .btn-primary");

  // Agregar evento de clic al botón de búsqueda
  btnBuscar.addEventListener("click", buscarYAgregarclickProducto);

  // Agregar evento de clic al botón de flecha
  btnArrowRight.addEventListener("click", buscarYAgregarProducto);

  // Obtener referencia al campo de entrada del código
  inputCodigo = document.getElementById("codigoIngresado");

  // Agregar evento de presionar tecla al campo de entrada del código
  inputCodigo.addEventListener("keydown", function (event) {
    if (event.key === "Enter") {
      // Si la tecla presionada es "Enter", buscar y agregar el producto
      buscarYAgregarProducto();
      
      // Limpiar el campo de entrada después de agregar el producto
      inputCodigo.value = "";

      // Evitar el comportamiento por defecto de la tecla "Enter" en un formulario
      event.preventDefault();
    }
  });

  // Resto de tu código...
});
	
	
function buscarYAgregarclickProducto() {
  // Obtener el código ingresado
  var codigoIngresado = inputCodigo.value;

  // Buscar el producto en el catálogo por el código
  var productoEncontrado = catalogoProductos.find(function (producto) {
    return producto.codigo === codigoIngresado;
  });

  // Si se encuentra el producto, agregarlo a la lista derecha
  if (productoEncontrado) {
    agregarProducto(productoEncontrado.codigo, productoEncontrado.descripcion, productoEncontrado.precio);
  } else {
    // Si el producto no se encuentra, abrir automáticamente el modal de agregar producto
    $('#agregarProductoModal').modal('hide');

    // Asignar el código ingresado al formulario del modal
    document.getElementById("codigo").value = codigoIngresado;

    // Cerrar el modal de búsqueda de productos
    $('#productosModal').modal('show');
  }
}
	
	
	
// Función para buscar y agregar el producto al hacer clic o presionar Enter
function buscarYAgregarProducto() {
  // Obtener el código ingresado
  var codigoIngresado = inputCodigo.value;

  // Buscar el producto en el catálogo por el código
  var productoEncontrado = catalogoProductos.find(function (producto) {
    return producto.codigo === codigoIngresado;
  });

  // Si se encuentra el producto, agregarlo a la lista derecha
  if (productoEncontrado) {
    agregarProducto(productoEncontrado.id,productoEncontrado.codigo, productoEncontrado.descripcion, productoEncontrado.precio);
  } else {
    // Si el producto no se encuentra, abrir automáticamente el modal de agregar producto
    $('#agregarProductoModal').modal('show');

    // Asignar el código ingresado al formulario del modal
    document.getElementById("codigo").value = codigoIngresado;

    // Cerrar el modal de búsqueda de productos
    $('#productosModal').modal('hide');
  }
}


  // Función para borrar un producto del arreglo
  function borrarProducto(index) {
    listaProductos.splice(index, 1);
    construirTabla();
  }

  // Función para cargar y mostrar la lista de productos en el modal con filtro
  function cargarProductosModal() {
    var listaProductosModal = document.getElementById("listaProductosModal");
    var filtroProductos = document.getElementById("filtroProductos").value.toLowerCase();

    // Limpiar la lista de productos en el modal
    listaProductosModal.innerHTML = "";

    // Filtrar productos según el texto ingresado
    var productosFiltrados = catalogoProductos.filter(function (producto) {
      return producto.descripcion.toLowerCase().includes(filtroProductos);
    });

    // Mostrar cada producto filtrado en la lista del modal
    productosFiltrados.forEach(function (producto) {
      var listItem = document.createElement("li");
      listItem.className = "list-group-item d-flex justify-content-between align-items-center";
      listItem.innerHTML = `${producto.descripcion} - ${producto.precio} <button class="btn btn-primary btn-sm" onclick="agregarProducto('${producto.id}', '${producto.codigo}', '${producto.descripcion}', '${producto.precio}')"><i class="fa fa fa-arrow-right"></i></button>`;
      listaProductosModal.appendChild(listItem);
    });
  }

  // Llamar a la función para cargar productos al abrir el modal y al cambiar el filtro
  $('#productosModal').on('show.bs.modal', cargarProductosModal);
  $('#filtroProductos').on('input', cargarProductosModal);

  // Función para agregar un producto a la lista principal

	function agregarProducto(id, codigo, descripcion, precio) {
  // Buscar si el producto ya está en la lista
  var productoExistente = listaProductos.find(function (producto) {
    return producto.codigo === codigo;
  });

  if (productoExistente) {
    // Si el producto ya existe, incrementar la cantidad
    productoExistente.cantidad += 1;
  } else {
    // Si el producto no existe, agregarlo a la lista
    var nuevoProducto = {id:id, codigo: codigo, descripcion: descripcion, cantidad: 1, precio: parseFloat(precio.replace("$", "")) };
    listaProductos.push(nuevoProducto);
  }

  $("#productosModal").modal("hide");
  construirTabla(); // Actualizar la tabla principal
}

function construirTabla() {
  var tablaBody = document.getElementById("tablaProductos").getElementsByTagName("tbody")[0];
  var total = 0;
  var cantidadTotal = 0;

  // Limpiar el cuerpo de la tabla
  tablaBody.innerHTML = "";

  // Iterar sobre los productos y construir filas de la tabla
  listaProductos.forEach(function (producto, index) {
    var fila = tablaBody.insertRow();
    fila.insertCell(0).innerText = producto.id;  // Agregar la columna "id"
    fila.insertCell(1).innerText = producto.codigo;
    fila.insertCell(2).innerText = producto.descripcion;
    fila.insertCell(3).innerText = producto.cantidad;
    fila.insertCell(4).innerText = "$" + producto.precio.toFixed(2);

 

// Resto del código...


    // Icono de borrar
    var iconoBorrar = document.createElement("i");
    iconoBorrar.className = "fa fa-minus-circle fa-lg text-danger";
    iconoBorrar.style.cursor = "pointer";
    iconoBorrar.title = "Borrar";
    iconoBorrar.addEventListener("click", function () {
      // Llamar a la función de borrado al hacer clic en el icono
      borrarProducto(index);
    });

    // Añadir el icono a la nueva columna de acciones
    var columnaAcciones = fila.insertCell(5);
    columnaAcciones.style.textAlign = "center";
    columnaAcciones.appendChild(iconoBorrar);

    // Calcular el total multiplicando la cantidad por el precio
	cantidadTotal += producto.cantidad;
    total += producto.cantidad * producto.precio;
  });

  // Actualizar el total en el HTML
  ItemsT=cantidadTotal;	
  TotalT=total.toFixed(2);	
  document.getElementById("total").innerText = "$" + total.toFixed(2);

  // Habilitar o deshabilitar el botón de cobro según la cantidad total

 var btnCobrar = document.getElementById("btnCobrar");
  btnCobrar.disabled = cantidadTotal === 0;
}

	
	
function actualizarCatalogoProductos() {	
$.ajax({
    url: ' <?php echo $urlajaxproductos; ?>', // Ruta al script PHP
    method: 'POST',
    dataType: 'json',
success: function (data) {
  //console.log('test:',data);

  // Convertir el objeto a un array de valores
  var arrayDatos = Object.values(data);

  // Verificar que arrayDatos se haya inicializado correctamente
  //console.log('Array de datos:', arrayDatos);

  // Llamar a la función para procesar los datos en el formato esperado
   catalogoProductos = convertirFormatoProductos(arrayDatos);
   console.log('Catalogo de productos:', catalogoProductos);

  // Resto de tu código...
},
    error: function (error) {
      console.error('Error al obtener los productos:', error);
    }
  });
	}
	
	
	
 $(document).ready(function () {
      // Agregar evento de clic al botón "Agregar"
      $("#btnAgregarDBProducto").click(function () {
         // Obtener los datos del formulario de manera serializada
       var formDatap = $("#formularioProducto").serialize();
		 // alert(formDatap);

         // Realizar la solicitud AJAX
         $.ajax({
            url: '<?php echo $urlajaxagregarproductos; ?>', // Reemplaza con la ruta correcta a tu script PHP
           data: formDatap,
           type: "post",
            success: function (respuesta) {
               // Manejar la respuesta del servidor, si es necesario
                    console.log(respuesta);
				  	$("#productosModal").modal("hide");
					$("#Mensaje").html(' <div class="alert alert-success alert-dismissible alert-alt fade show"><button type="button" class="close h-100" data-dismiss="alert" aria-label="Close"><span><i class="mdi mdi-close"></i></span></button><strong>Listo </strong> Se agrego una aplicacion con exito.</div>');
				   setTimeout(function() {$('#Mensaje').hide();}, 2000);
	// Cerrar el modal de productos
  					$("#formularioProducto")[0].reset(); // Limpiar el formulario
					actualizarCatalogoProductos(); 
				
            },
            error: function (error) {
               console.error('Error al agregar producto:', error);
            }
         });
      });
   });
	
	document.addEventListener("DOMContentLoaded", function () {
  // Resto de tu código...

  // Obtener referencia al campo de entrada del código
  var inputCodigo = document.getElementById("codigoIngresado");

  // Establecer el foco en el campo de entrada del código al cargar la página
  inputCodigo.focus();
  
  // Resto de tu código...
});
	
  // Llamar a la función para construir la tabla al cargar la página
  construirTabla();
</script>