
    <style>
        .list-group-item { cursor: pointer; }
        .category-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        .bordered-column {
            border: 1px solid #F7F7F7;
            border-radius: 10px;
            height: 500px;
            overflow-y: hidden;
        }
        .bordered-column:hover {
            overflow-y: auto;
        }
        .card-header {
            border-radius: 8px 8px 0 0;
        }
        .card {
            border: none;
            margin-bottom: 10px;
            border-radius: 8px;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
        }
        .column-separation {
            margin: 1px;
        }
        .negro {
            color: black;
			
        }
        .highlight {
            background-color: lightgray;
        }
        .highlight-odd {
            background-color: #f9f9f9;
        }
		.table {
    font-size: 0.85rem; /* Reduce el tamaño de fuente */
    width: 100%; /* Asegúrate de que la tabla ocupe el ancho completo */
}

.table td, .table th {
    padding: 5px; /* Reduce el padding en las celdas */
    text-align: center; /* Centra el texto para un aspecto más ordenado */
}

.table thead th {
    font-weight: bold; /* Mantén el texto en negrita en el encabezado */
}

.negro {
    background-color: #f9f9f9; /* Cambia el color de fondo para las filas impares */
}

		.container {
    background-color: #fff;
    border-radius: 10px;
    padding: 20px;
    box-shadow: 0px 0px 10px rgba(0, 0, 0, 0.2);
	max-width: 100%; 
}
    </style>

<div class="container">
    <div class="row page-titles mx-0">
        <div class="col-md-4 bordered-column column-separation">
            <h4>Catalogo</h4>
            <input type="text" id="search" class="form-control mb-3" placeholder="Buscar productos...">
            <div id="productAccordion"></div>
        </div>
        <div class="col-md-4 bordered-column column-separation"> 
            <h4>Nota</h4>
            <div class="input-group mb-4">
                <input type="text" id="cartTotal" class="form-control font-weight-bold" readonly value="Total: $0.00">
                <div class="input-group-append">
                    <button id="btnCobrar" class="btn btn-outline-success">Cobrar</button>
                </div>
            </div>
            <ul id="cart" class="list-group"></ul>
            <button id="clearCart" class="btn btn-outline-danger col-md-12 mt-3">Vaciar Carrito</button>
        </div>
        <div class="col-md-3 bordered-column column-separation">
            <h4>Ventas</h4>
            <table class="table">
                <thead>
                    <tr>
                        <th>IDN</th>
                        <th>Descripción</th>
                        <th>Cantidad</th>
						<th>Precio</th>
						<th>Total</th>
                    </tr>
                </thead>
                <tbody id="totalPurchases"></tbody>
                <tfoot>
                    <tr class="btn-outline-danger">
                        <td> </td>
                        <td id="totalItems">0</td>
                        <td id="totalAmount">$0.00</td>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>
</div>



<script>
    var catalogoProductos = <?php echo json_encode($productos); ?>;
    var totalPurchases = <?php echo json_encode($VentasT); ?>;
    var listaProductos = [];
    var TotalT = 0;
    var ItemsT = 0;

    $(document).ready(async function() {
        await actualizarCatalogoProductos();
        let products = catalogoProductos;

        let cart = [];
        let selectedProductsArray = [];

        function groupByCategory(products) {
            return products.reduce((acc, product) => {
                if (!acc[product.categoria]) {
                    acc[product.categoria] = [];
                }
                acc[product.categoria].push(product);
                return acc;
            }, {});
        }

        function displayProducts(productsToDisplay) {
            const productGroups = groupByCategory(productsToDisplay);
            const accordion = $('#productAccordion');
            accordion.empty();
            let index = 0;

            for (const category in productGroups) {
                const products = productGroups[category];
                const card = $(`
                    <div class="card">
                        <div class="card-header" id="heading${index}">
                            <h5 class="mb-0">
                                <button class="btn negro" data-toggle="collapse" data-target="#collapse${index}" aria-expanded="true" aria-controls="collapse${index}">
                                    <div class="category-header">
                                        <i class="fa fa-chevron-down"></i>
                                        <span><b> ${category}</b></span> 
                                    </div>
                                </button>
                            </h5>
                        </div>
                        <div id="collapse${index}" class="collapse" aria-labelledby="heading${index}" data-parent="#productAccordion">
                            <div class="card-body">
                                <ul class="list-group"></ul>
                            </div>
                        </div>
                    </div>
                `);

                products.forEach(product => {
                    card.find('.list-group').append(`
                        <li class="list-group-item" data-id="${product.id}">
                            ${product.icono ? `<i class="${product.icono}"></i>` : ''} ${product.descripcion} - $${product.precio}
                        </li>
                    `);
                });

                accordion.append(card);
                index++;
            }
        }

        function updateCart() {
            const cartList = $('#cart');
            cartList.empty();
            let total = 0;

            cart.forEach(item => {
                cartList.append(`
                    <li class="list-group-item">
                        ${item.descripcion} - $${item.precio}
                        <button class="btn btn-outline-danger btn-sm float-right remove-item" data-id="${item.id}">X</button>
                    </li>
                `);
                total += item.precio;
            });

            cartList.append(`
                <li class="list-group-item active">
                    Total: $${total.toFixed(2)}
                </li>
            `);

            $('#cartTotal').val(`Total: $${total.toFixed(2)}`);

            TotalT = total;
            ItemsT = cart.length;
        }

        function addToCart(product) {
            cart.push(product);
            selectedProductsArray.push(product);
            updateCart();

            listaProductos = selectedProductsArray;
            console.log(listaProductos);
        }

        function removeFromCart(productId) {
            cart = cart.filter(item => item.id != productId);
            selectedProductsArray = selectedProductsArray.filter(item => item.id != productId);
            updateCart();
        }

        function clearCart() {
            cart = [];
            selectedProductsArray = [];
            updateCart();
        }

        function checkout() {
            if (cart.length > 0) {
                console.log("Total: $" + TotalT);
                console.log("Items Totales: " + ItemsT);
                $('#modalCobro').modal('show');
            } else {
                alert('El carrito está vacío');
            }
        }

        function displaySearchResults(results) {
            const accordion = $('#productAccordion');
            accordion.find('#searchResults').remove();

            if (results.length > 0) {
                const searchCard = $(`
                    <div class="card" id="searchResults">
                        <div class="card-header" id="headingSearch">
                            <h5 class="mb-0">
                                <button class="btn btn-link" data-toggle="collapse" data-target="#collapseSearch" aria-expanded="true" aria-controls="collapseSearch">
                                    <div class="category-header">
                                        <span>Busqueda</span>
                                        <i class="fa fa-chevron-right"></i>
                                    </div>
                                </button>
                            </h5>
                        </div>
                        <div id="collapseSearch" class="collapse show" aria-labelledby="headingSearch" data-parent="#productAccordion">
                            <div class="card-body">
                                <ul class="list-group"></ul>
                            </div>
                        </div>
                    </div>
                `);

                results.forEach(product => {
                    searchCard.find('.list-group').append(`
                        <li class="list-group-item" data-id="${product.id}">
                            ${product.icono ? `<i class="${product.icono}"></i>` : ''} ${product.descripcion} - $${product.precio}
                        </li>
                    `);
                });

                accordion.prepend(searchCard);
            }
        }

        function displayTotalPurchases(purchases) {
            const totalPurchasesList = $('#totalPurchases');
            totalPurchasesList.empty();

            let totalAmount = 0;
            let totalItems = 0;

            purchases.forEach((purchase, index) => {
                const rowClass = parseInt(purchase.IDN) % 2 === 0 ? '' : 'negro';
                totalPurchasesList.append(`
                    <tr class="${rowClass}" data-toggle="tooltip" title="Fecha: ${purchase.TimeStamp}">
                        <td>${parseInt(purchase.IDN)}</td>
                        <td>${purchase.Descrpicion}</td>
                        <td>$${parseFloat(purchase.Precio).toFixed(2)}</td>
                    </tr>
                `);

                totalAmount += parseFloat(purchase.Precio);
                totalItems++;
            });

            $('#totalItems').text(totalItems);
            $('#totalAmount').text(`$${totalAmount.toFixed(2)}`);

            $('[data-toggle="tooltip"]').tooltip();
        }

        $('#productAccordion').on('click', '.list-group-item', function() {
            const productId = $(this).data('id');
            const product = products.find(p => p.id == productId);
            if (product) {
                addToCart({
                    id: product.id,
                    name: product.descripcion,
                    precio: parseFloat(product.precio),
                    descripcion: product.descripcion,
                    cantidad: 1
                });
            }
        });

        $('#cart').on('click', '.remove-item', function() {
            const productId = $(this).data('id');
            removeFromCart(productId);
        });

        $('#clearCart').click(function() {
            clearCart();
        });

        $('#btnCobrar').click(function() {
            checkout();
        });

        $('#search').on('input', function() {
            const searchTerm = $(this).val().toLowerCase();
            const filteredProducts = products.filter(product =>
                product.descripcion.toLowerCase().includes(searchTerm)
            );
            displaySearchResults(filteredProducts);
        });

        displayProducts(products);
        displayTotalPurchases(totalPurchases);
    });

    async function actualizarCatalogoProductos() {
        return new Promise((resolve, reject) => {
            $.ajax({
                url: '<?php echo $urlajaxproductos; ?>',
                method: 'POST',
                dataType: 'json',
                success: function (data) {
                    var arrayDatos = Object.values(data);
                    catalogoProductos = convertirFormatoProductos(arrayDatos);
                    resolve();
                },
                error: function (error) {
                    console.error('Error al obtener los productos:', error);
                    reject(error);
                }
            });
        });
    }

    function convertirFormatoProductos(data) {
        var productosConvertidos = [];

        data.forEach(function (producto) {
            var icono = "";
            try {
                var iconoJSON = JSON.parse(producto[5]);
                if (iconoJSON && iconoJSON.icono) {
                    icono = iconoJSON.icono;
                }
            } catch (error) {
                console.error('Error al parsear el JSON del icono:', error);
            }

            productosConvertidos.push({
                id: String(producto[0]),
                codigo: String(producto[1]),
                descripcion: String(producto[2]),
                precio: parseFloat(producto[3]).toFixed(2),
                categoria: String(producto[4]),
                icono: icono
            });
        });

        return productosConvertidos;
    }
</script>
