
    <style>
        .list-group-item { cursor: pointer; }
        .category-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        .bordered-column {
            border: 1px solid #F7F7F7;
            border-radius: 10px;
            height: 500px;
            overflow-y: hidden;
        }
        .bordered-column:hover {
            overflow-y: auto;
        }
        .card-header {
            border-radius: 8px 8px 0 0;
        }
        .card {
            border: none;
            margin-bottom: 10px;
            border-radius: 8px;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
        }
        .column-separation {
            margin: 1px;
        }
        .negro {
            color: black;
			
        }
        .highlight {
            background-color: lightgray;
        }
        .highlight-odd {
            background-color: #f9f9f9;
        }
		.table {
    font-size: 0.85rem; /* Reduce el tamaño de fuente */
    width: 100%; /* Asegúrate de que la tabla ocupe el ancho completo */
}

.table td, .table th {
    padding: 5px; /* Reduce el padding en las celdas */
    text-align: center; /* Centra el texto para un aspecto más ordenado */
}

.table thead th {
    font-weight: bold; /* Mantén el texto en negrita en el encabezado */
}

.negro {
    background-color: #f9f9f9; /* Cambia el color de fondo para las filas impares */
}

		.container {
    background-color: #fff;
    border-radius: 10px;
    padding: 20px;
    box-shadow: 0px 0px 10px rgba(0, 0, 0, 0.2);
	max-width: 100%; 
}
    </style>

<div class="container">
    <div class="row page-titles mx-0">
        <div class="col-md-4 bordered-column column-separation">
			 <div style="height: 50%; overflow-x: auto;">
			<table class="table table-bordered">
        <thead>
            <tr>
                <th>Fecha</th>
                <th>ID Usuario</th>
                <th>Acciones</th>
            </tr>
        </thead>
        <tbody id="tablaDatos">
            <!-- Aquí se llenarán las filas dinámicamente -->
        </tbody>
    </table>
		</div>	
            <h4>Catalogo</h4>
            <input type="text" id="search" class="form-control mb-3" placeholder="Buscar productos...">
            <div id="productAccordion"></div>
        </div>
		
		
		
        <div class="col-md-4 bordered-column column-separation"> 
            <h4>Nota</h4>
            <div class="input-group mb-4">
                <input type="text" id="cartTotal" class="form-control font-weight-bold" readonly value="Total: $0.00">
                <div class="input-group-append">
                    <button id="btnCobrar" class="btn btn-outline-success">Cobrar</button>
                </div>
            </div>
            <ul id="cart" class="list-group"></ul>
            <button id="clearCart" class="btn btn-outline-danger col-md-12 mt-3">Vaciar Carrito</button>
        </div>
        <div class="col-md-3 bordered-column column-separation">
            <h4>Ventas</h4>
            <table class="table">
                <thead>
                    <tr>
                        <th>IDN</th>
                        <th>Descripción</th>
                        <th>Precio</th>
					
                    </tr>
                </thead>
                <tbody id="totalPurchases"></tbody>
                <tfoot>
                    <tr class="btn-outline-danger">
                        <td> </td>
                        <td id="totalItems">0</td>
                        <td id="totalAmount">$0.00</td>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>
</div>

<!-- Modal de información -->
<div id="modalInformacion" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="modalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="modalLabel">Información del Pedido</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body" id="modalBody">
                <!-- La información será cargada aquí -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
            </div>
        </div>
    </div>
</div>


<script> 
    var catalogoProductos = <?php echo json_encode($productos); ?>;
    var totalPurchases = <?php echo json_encode($VentasT); ?>;
    var listaProductos = [];
    var TotalT = 0;
    var ItemsT = 0;
	 // El arreglo de datos proporcionado
    const deliveries =  <?php echo json_encode($Pedidos); ?>;
	console.log(deliveries);
 
	
function cargarTabla() {
    const tablaDatos = document.getElementById('tablaDatos');
    tablaDatos.innerHTML = ''; // Limpia la tabla antes de llenarla

    if (!Array.isArray(deliveries) || deliveries.length === 0) {
        console.error("No hay datos para mostrar en la tabla.");
        return;
    }

    deliveries.forEach(entry => {
        const tr = document.createElement('tr');
        tr.innerHTML = `
            <td>${entry.TimeStamp}</td>
            <td>${entry.IDU}</td>
            <td>
                <button class="btn btn-info btn-sm" data-mensaje='${entry.Mensaje.replace(/'/g, "&apos;")}' onclick="mostrarInformacion(this)">
                    <i class="fa fa-info-circle" aria-hidden="true"></i>
                </button>
                <button class="btn btn-success btn-sm ml-2" data-mensaje='${entry.Mensaje.replace(/'/g, "&apos;")}' onclick="mostrarProductos(this)">➡</button>
            </td>
        `;
        tablaDatos.appendChild(tr);
    });
}

function mostrarInformacion(button) {
    try {
        let mensaje = button.getAttribute('data-mensaje');
        console.log("Mensaje original:", mensaje);

        // Verificar si tiene comillas extra
        if (mensaje.startsWith('"') && mensaje.endsWith('"')) {
            mensaje = mensaje.slice(1, -1);
        }

        // Corregir comillas escapadas
        mensaje = mensaje.replace(/\\"/g, '"');
        console.log("Mensaje después de limpiar comillas:", mensaje);

        // Intentar parsear JSON
        const mensajeParseado = JSON.parse(mensaje);
        console.log("JSON parseado correctamente:", mensajeParseado);

        // Extraer datos correctamente
        const clienteTexto = decodeUnicode(mensajeParseado.client || 'Sin información');
        console.log("Cliente (sin procesar):", clienteTexto);

        // Extraer nombre, teléfono y dirección del texto de `client`
        const nombreMatch = clienteTexto.match(/^(.*)\n/i);
        const telefonoMatch = clienteTexto.match(/Telu00e9fono:\s*(\d+)/i);
        const direccionMatch = clienteTexto.match(/Direcciu00f3n:\s*(.*)/i);

        const cliente = nombreMatch ? nombreMatch[1].trim() : 'No especificado';
        const telefono = telefonoMatch ? telefonoMatch[1] : 'No disponible';
        const direccion = direccionMatch ? direccionMatch[1].trim() : 'No especificada';

        console.log("Cliente:", cliente);
        console.log("Teléfono:", telefono);
        console.log("Dirección:", direccion);

        const observaciones = decodeUnicode(mensajeParseado.observations || 'Ninguna');
        const productos = Array.isArray(mensajeParseado.products) ? mensajeParseado.products : [];

        // Llenamos el modal
        const modalBody = document.getElementById('modalBody');
        modalBody.innerHTML = `
            <div class="card border-primary mb-3">
                <div class="card-header bg-primary text-white">
                    <i class="fas fa-id-card"></i> Cliente
                </div>
                <div class="card-body">
                    <h5 class="card-title text-dark">${cliente}</h5>
                    <p class="card-text">
                        <i class="fas fa-phone"></i> <strong>Teléfono:</strong> ${telefono}
                    </p>
                    <p class="card-text">
                        <i class="fas fa-map-marker-alt"></i> <strong>Dirección:</strong> ${direccion}
                    </p>
                    <p class="card-text">
                        <i class="fas fa-sticky-note"></i> <strong>Observaciones:</strong> ${observaciones}
                    </p>
                </div>
            </div>

            <h5 class="text-success"><i class="fas fa-shopping-cart"></i> Productos</h5>
            <table class="table table-striped">
                <thead class="table-dark">
                    <tr>
                        <th>Producto</th>
                        <th>Precio</th>
                    </tr>
                </thead>
                <tbody>
                    ${productos.length > 0 
                        ? productos.map(product => `
                            <tr>
                                <td>${decodeUnicode(product.name || 'Sin nombre')}</td>
                                <td>$${product.price || '0.00'}</td>
                            </tr>
                        `).join('')
                        : `<tr><td colspan="2" class="text-center">No hay productos</td></tr>`
                    }
                </tbody>
            </table>
        `;

        // Abrimos el modal
        $('#modalInformacion').modal('show');
    } catch (error) {
        console.error("Error al procesar la información:", error);
        alert("Hubo un error al cargar los datos. Revisa la consola.");
    }
}

function mostrarProductos(button) {
    try {
        let mensaje = button ? button.getAttribute('data-mensaje') : null;

        if (!mensaje) {
            console.warn("No se encontró un mensaje en el botón. Se usará un producto de prueba.");
            mensaje = JSON.stringify({
                client: "123 ClienteEjemplo",
                deliveryType: "pickup",
                observations: "ss",
                products: [
                    {
                        id: "1",
                        name: "Capuchino Avellana 16oz",
                        price: "45"
                    }
                ]
            });
        }

        console.log("Mensaje recibido antes de limpieza:", mensaje);

        // **Limpieza profunda del JSON**
        mensaje = mensaje
            .replace(/(\r\n|\n|\r|\t)/gm, " ")  // Eliminar saltos de línea y tabulaciones
            .replace(/\s{2,}/g, " ")            // Reemplazar múltiples espacios con uno solo
            .replace(/\\"/g, '"')               // Arreglar comillas escapadas
            .replace(/\\u\d{4}/g, "")           // Eliminar caracteres Unicode mal formateados
            .trim();                            // Eliminar espacios al inicio y al final

        console.log("Mensaje después de limpieza:", mensaje);

        // **Eliminar comillas dobles innecesarias**
        if (mensaje.startsWith('"') && mensaje.endsWith('"')) {
            mensaje = mensaje.slice(1, -1);
        }

        // **Parsear el JSON**
        const mensajeParseado = JSON.parse(mensaje);
        console.log("Mensaje parseado con éxito:", mensajeParseado);

        // **Verificar si tiene client y products**
        if (!mensajeParseado.client || !mensajeParseado.products) {
            throw new Error("Formato incorrecto: falta 'client' o 'products'.");
        }

        // **Limpiar el campo client y extraer ID**
        const clienteTexto = mensajeParseado.client.trim().replace(/\s+/g, " "); // Eliminar espacios extras
        const idCliente = clienteTexto.split(" ")[0]; // Tomar la primera palabra como ID
        console.log("ID del Cliente:", idCliente);

        console.log("Productos en el mensaje:", mensajeParseado.products);

        // **Verificar si hay productos**
        if (!Array.isArray(mensajeParseado.products) || mensajeParseado.products.length === 0) {
            console.warn("No hay productos en el mensaje.");
            alert("No se encontraron productos para agregar.");
            return;
        }

        // **Convertir productos al formato correcto**
        const productosCarrito = mensajeParseado.products.map(product => ({
            id: String(product.id),
            name: product.name,
            precio: parseFloat(product.price),
            descripcion: product.name,
            cantidad: 1
        }));

        console.log("Productos a agregar al carrito:", productosCarrito);

        // **Verificar que addToCart está definida**
        if (typeof addToCart !== "function") {
            console.error("Error: La función addToCart no está definida.");
            alert("No se pudo agregar el producto al carrito. Verifica el código.");
            return;
        }

        // **Agregar los productos al carrito**
        productosCarrito.forEach(product => {
            console.log("Agregando al carrito:", product);
            addToCart(product);
        });

        alert("Productos agregados al carrito con éxito.");

    } catch (error) {
        console.error("Error en mostrarProductos:", error);
        alert("Hubo un error al agregar los productos al carrito.");
    }
}

// Función para decodificar caracteres Unicode como \u00e9 -> é
function decodeUnicode(str) {
    return str.replace(/\\u([\dA-Fa-f]{4})/g, (match, group) => String.fromCharCode(parseInt(group, 16)));
}



    // Cargar la tabla al cargar la página
$(document).ready(() => {
    console.log("Datos recibidos:", deliveries);
    if (Array.isArray(deliveries) && deliveries.length > 0) {
        cargarTabla();
    } else {
        console.warn("No se encontraron datos para la tabla.");
    }
});

	
	
	
$(document).ready(async function() {
    await actualizarCatalogoProductos();
    let products = catalogoProductos;

    // Verificar que addToCart esté disponible en este momento
    console.log("addToCart is available:", typeof addToCart === 'function');

    let cart = [];
    let selectedProductsArray = [];

    function groupByCategory(products) {
        return products.reduce((acc, product) => {
            if (!acc[product.categoria]) {
                acc[product.categoria] = [];
            }
            acc[product.categoria].push(product);
            return acc;
        }, {});
    }

    function displayProducts(productsToDisplay) {
        const productGroups = groupByCategory(productsToDisplay);
        const accordion = $('#productAccordion');
        accordion.empty();
        let index = 0;

        for (const category in productGroups) {
            const products = productGroups[category];
            const card = $(` 
                <div class="card">
                    <div class="card-header" id="heading${index}">
                        <h5 class="mb-0">
                            <button class="btn negro" data-toggle="collapse" data-target="#collapse${index}" aria-expanded="true" aria-controls="collapse${index}">
                                <div class="category-header">
                                    <i class="fa fa-chevron-down"></i>
                                    <span><b> ${category}</b></span> 
                                </div>
                            </button>
                        </h5>
                    </div>
                    <div id="collapse${index}" class="collapse" aria-labelledby="heading${index}" data-parent="#productAccordion">
                        <div class="card-body">
                            <ul class="list-group"></ul>
                        </div>
                    </div>
                </div>
            `);

            products.forEach(product => {
                card.find('.list-group').append(`
                    <li class="list-group-item" data-id="${product.id}">
                        ${product.icono ? `<i class="${product.icono}"></i>` : ''} ${product.descripcion} - $${product.precio}
                    </li>
                `);
            });

            accordion.append(card);
            index++;
        }
    }

    function updateCart() {
        const cartList = $('#cart');
        cartList.empty();
        let total = 0;

        cart.forEach(item => {
            cartList.append(`
                <li class="list-group-item">
                    ${item.descripcion} - $${item.precio}
                    <button class="btn btn-outline-danger btn-sm float-right remove-item" data-id="${item.id}">X</button>
                </li>
            `);
            total += item.precio;
        });

        cartList.append(`
            <li class="list-group-item active">
                Total: $${total.toFixed(2)}
            </li>
        `);

        $('#cartTotal').val(`Total: $${total.toFixed(2)}`);
        TotalT = total;
        ItemsT = cart.length;
    }

    function addToCart(product) {
        cart.push(product);
        selectedProductsArray.push(product);
        updateCart();

        listaProductos = selectedProductsArray;
        console.log(listaProductos);
    }

    function removeFromCart(productId) {
        cart = cart.filter(item => item.id != productId);
        selectedProductsArray = selectedProductsArray.filter(item => item.id != productId);
        updateCart();
    }

    function clearCart() {
        cart = [];
        selectedProductsArray = [];
        updateCart();
    }

    function checkout() {
        if (cart.length > 0) {
            console.log("Total: $" + TotalT);
            console.log("Items Totales: " + ItemsT);
            $('#modalCobro').modal('show');
        } else {
            alert('El carrito está vacío');
        }
    }

    function displaySearchResults(results) {
        const accordion = $('#productAccordion');
        accordion.find('#searchResults').remove();

        if (results.length > 0) {
            const searchCard = $(`
                <div class="card" id="searchResults">
                    <div class="card-header" id="headingSearch">
                        <h5 class="mb-0">
                            <button class="btn btn-link" data-toggle="collapse" data-target="#collapseSearch" aria-expanded="true" aria-controls="collapseSearch">
                                <div class="category-header">
                                    <span>Busqueda</span>
                                    <i class="fa fa-chevron-right"></i>
                                </div>
                            </button>
                        </h5>
                    </div>
                    <div id="collapseSearch" class="collapse show" aria-labelledby="headingSearch" data-parent="#productAccordion">
                        <div class="card-body">
                            <ul class="list-group"></ul>
                        </div>
                    </div>
                </div>
            `);

            results.forEach(product => {
                searchCard.find('.list-group').append(`
                    <li class="list-group-item" data-id="${product.id}">
                        ${product.icono ? `<i class="${product.icono}"></i>` : ''} ${product.descripcion} - $${product.precio}
                    </li>
                `);
            });

            accordion.prepend(searchCard);
        }
    }

    function displayTotalPurchases(purchases) {
        const totalPurchasesList = $('#totalPurchases');
        totalPurchasesList.empty();

        let totalAmount = 0;
        let totalItems = 0;

        purchases.forEach((purchase, index) => {
            const rowClass = parseInt(purchase.IDN) % 2 === 0 ? '' : 'negro';
            totalPurchasesList.append(`
                <tr class="${rowClass}" data-toggle="tooltip" title="Fecha: ${purchase.TimeStamp}">
                    <td>${parseInt(purchase.IDN)}</td>
                    <td>${purchase.Descrpicion}</td>
                    <td>$${parseFloat(purchase.Precio).toFixed(2)}</td>
                </tr>
            `);

            totalAmount += parseFloat(purchase.Precio);
            totalItems++;
        });

        $('#totalItems').text(totalItems);
        $('#totalAmount').text(`$${totalAmount.toFixed(2)}`);

        $('[data-toggle="tooltip"]').tooltip();
    }

    // Verificar que la función addToCart esté disponible antes de invocar
    console.log("addToCart is available:", typeof addToCart === 'function');

    $('#productAccordion').on('click', '.list-group-item', function() {
        const productId = $(this).data('id');
        const product = products.find(p => p.id == productId);
        if (product) {
            console.log("Adding product to cart:", product);
            addToCart({
                id: product.id,
                name: product.descripcion,
                precio: parseFloat(product.precio),
                descripcion: product.descripcion,
                cantidad: 1
            });
        } else {
            console.error("Product not found:", productId);
        }
    });

    $('#cart').on('click', '.remove-item', function() {
        const productId = $(this).data('id');
        removeFromCart(productId);
    });

    $('#clearCart').click(function() {
        clearCart();
    });

    $('#btnCobrar').click(function() {
        checkout();
    });

    $('#search').on('input', function() {
        const searchTerm = $(this).val().toLowerCase();
        const filteredProducts = products.filter(product =>
            product.descripcion.toLowerCase().includes(searchTerm)
        );
        displaySearchResults(filteredProducts);
    });

    displayProducts(products);
    displayTotalPurchases(totalPurchases);
});

async function actualizarCatalogoProductos() {
    return new Promise((resolve, reject) => {
        $.ajax({
            url: '<?php echo $urlajaxproductos; ?>',
            method: 'POST',
            dataType: 'json',
            success: function (data) {
                var arrayDatos = Object.values(data);
                catalogoProductos = convertirFormatoProductos(arrayDatos);
                resolve();
            },
            error: function (error) {
                console.error('Error al obtener los productos:', error);
                reject(error);
            }
        });
    });
}

function convertirFormatoProductos(data) {
    var productosConvertidos = [];

    data.forEach(function (producto) {
        var icono = "";
        try {
            var iconoJSON = JSON.parse(producto[5]);
            if (iconoJSON && iconoJSON.icono) {
                icono = iconoJSON.icono;
            }
        } catch (error) {
            console.error('Error al parsear el JSON del icono:', error);
        }

        productosConvertidos.push({
            id: String(producto[0]),
            codigo: String(producto[1]),
            descripcion: String(producto[2]),
            precio: parseFloat(producto[3]).toFixed(2),
            categoria: String(producto[4]),
            icono: icono
        });
    });

    return productosConvertidos;
}

</script>
