<?php
session_start();
require('tcpdf/tcpdf.php');
include("../conexion.php");
$db = new MySQL();
$ruta_archivo = 'ticket.pdf';
$IDs = $_SESSION["IDU"];
$bannerImagePath = '../Archivos/IMG/' . $IDs . '-Banner_ImpresoraMedio.jpg';
$Config = $_SESSION["IDU-Configuracion"];

// Obtener dimensiones originales de la imagen
list($originalWidth, $originalHeight) = getimagesize($bannerImagePath);

// Calcular nuevas dimensiones con el 10% de escala
$newWidth = $originalWidth * 0.10;
$newHeight = $originalHeight * 0.10;

// Arreglo de datos del ticket
$ticketData = $_SESSION["notas"];
$ticketd = $_SESSION["notasD"];
$cliente = $_SESSION["nocliente"];

class TicketPDF extends TCPDF
{
    public function Header()
    {
        // Encabezado del ticket (puedes agregar un logotipo aquí)
        $this->SetFont('helvetica', 'B', 14);
		//$this->Cell(0, 10, 'No: ' . $ticketData[0][0], 0, 0, 'R');
		$this->Ln(20);
    }

    public function Footer()
    {
        // Número de página
        $this->SetY(-15);
        $this->SetFont('helvetica', 'I', 8);
        $this->Cell(0, 10, 'Página ' . $this->getAliasNumPage(), 0, 0, 'C');
    }
}

// Crear una instancia de TCPDF personalizada con orientación horizontal
$pdf = new TicketPDF('L', 'mm', 'A5'); // Cambiar 'P' por 'L' para orientación horizontal
$pdf->SetLeftMargin(10);

// Agregar una página
$pdf->AddPage();

// Calcular coordenadas para centrar la imagen
$x = (210 - $newWidth) / 2;  // (Ancho de la página - Ancho de la imagen) / 2
$y = (148 - $newHeight) / 2;  // (Altura de la página - Altura de la imagen) / 2

// Colocar la imagen en el PDF centrada
$pdf->Image($bannerImagePath, $x, 2, $newWidth, $newHeight); // Ajustar el tamaño de la imagen con escala del 10%

$pdf->SetFont('helvetica', '', 10);

$pdf->SetFont('helvetica', 'B', 15);
$pdf->Cell(0, 28, ' ', 0, 1);
$pdf->Cell(0, 0, 'Nota ', 0, 1, 'C');
$pdf->SetFont('helvetica', 'B', 16);
$pdf->Cell(0, 2, 'No: ' . $ticketData[0][0], 0, 1,'R');
$pdf->SetFont('helvetica', 'B', 8);
$pdf->Cell(0, 2, 'Fecha: ' . $ticketData[0][8], 0, 1);
$pdf->Cell(0, 2, 'Cliente: ' . $cliente[0][2], 0, 1);
$pdf->Cell(0, 2, 'Telefono: ' . $cliente[0][4], 0, 1);
$pdf->Cell(0, 5, ' ', 0, 1);

// Detalles de los productos
$pdf->SetFont('helvetica', 'B', 8);
$pdf->Cell(10, 5, 'Cant', 1);
$pdf->Cell(130, 5, 'Descripción', 1);
$pdf->Cell(25, 5, 'Precio Unitario', 1);
$pdf->Cell(25, 5, 'Subtotal', 1);
$pdf->Ln();
$r=7;
foreach ($ticketd as $product) {
    $pdf->SetFont('helvetica', '', 8);
    $pdf->Cell(10, 5, $product[0], 1);
    $pdf->Cell(130, 5, $product[1], 1);
    $pdf->Cell(25, 5, number_format($product[2], 2), 1);
    $pdf->Cell(25, 5, number_format($product[2] * $product[0], 2), 1);
    $pdf->Ln();
	$r--;
}

for ($i = 0; $i < $r; $i++) {
     $pdf->SetFont('helvetica', '', 8);
    $pdf->Cell(10, 5, '', 1);
    $pdf->Cell(130, 5, '', 1);
    $pdf->Cell(25, 5, '', 1);
    $pdf->Cell(25, 5, '', 1);
    $pdf->Ln();
}

$pdf->SetFont('helvetica', '', 16);
$pdf->Cell(0, 10, 'Total: $' . number_format($ticketData[0][4], 2), 0, 1, 'R');
$pdf->SetFont('helvetica', '', 8);
$pdf->Cell(0, 2, 'Observaciones: ' . $ticketData[0][5], 0, 1);
$pdf->Cell(0, 2, 'Método de Pago: ' . $ticketData[0][6], 0, 1);
$pdf->Cell(0, 2	, 'Token: ' . $cliente[0][7] . $ticketData[0][7], 0, 1);

// Generar el PDF
$pdf->Output('ticket.pdf', 'I');

//UPDATE `MicroSi_Datos`.`22-Impresoras` SET `Estado` = 'Impresa' WHERE (`ID_I` = '1');

$consulta = "UPDATE `MicroSi_Datos`.`$IDs-Impresoras` SET `Estado` = 'Impresa' WHERE (`Conjunto_A` = " . $ticketData[0][0] . ");";
$Rq = $db->actualizar($consulta);
?>
