<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Contrato de Membresía</title>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf-autotable/3.5.15/jspdf.plugin.autotable.min.js"></script>
    <style>
        #pdf-preview {
            width: 100%;
            height: 90vh; /* Ajusta la altura del iframe según tus necesidades */
            border: 1px solid #ccc;
            margin-top: 20px;
        }
    </style>
</head>
<body>
    <h1>Vista previa del Contrato de Membresía</h1>
    <iframe id="pdf-preview"></iframe>

    <?php
    // Verificar si membershipData fue enviado por POST
    if (isset($_POST['membershipData'])) {
        // Decodificar el JSON recibido
        $membershipData = json_decode($_POST['membershipData'], true);

        // Validar que el JSON sea válido
        if (json_last_error() === JSON_ERROR_NONE) {
            // Convertir el array PHP en un JSON para el script
            echo "<script>const membershipData = " . json_encode($membershipData, JSON_PRETTY_PRINT) . ";</script>";
        } else {
            echo "<script>console.error('Error al decodificar el JSON: " . json_last_error_msg() . "');</script>";
        }
    } else {
        echo "<script>const membershipData = null; console.error('No se recibió membershipData por POST.');</script>";
    }
    ?>

    <script>
        function generatePDF(membership) {
            if (!membership) {
                alert("No se han recibido datos válidos.");
                return;
            }

            const { jsPDF } = window.jspdf;
            const doc = new jsPDF({
                format: 'a4',
                orientation: 'portrait'
            });

                 const bannerURLA = "http://167.172.224.160/MiSi/librerias/Impresora/IMG/48-Banner_A.png";
	  const bannerURLP = "http://167.172.224.160/MiSi/librerias/Impresora/IMG/48-Banner_P.png";

      // Agregar banner superior solo en la primera página
      doc.addImage(bannerURLA, "PNG", 0, 0, 210, 24);

            const startY = 30;
            doc.setFont("helvetica", "bold");
            doc.setFontSize(14);
            doc.text("Contrato de Membresía", 10, startY);

            doc.setFont("helvetica", "normal");
            doc.setFontSize(12);

            const currentDate = new Date().toLocaleDateString();
            doc.text(`Fecha de Emisión: ${currentDate}`, 10, startY + 10);

            const legalText = `Por este contrato, el cliente acepta los términos y condiciones de la membresía adquirida. 
Los servicios proporcionados en esta membresía son personales e intransferibles, y se deben utilizar en las fechas establecidas.
El cliente se compromete a respetar las políticas de la clínica y los tiempos de validez.`;
            doc.text(legalText, 10, startY + 20, { maxWidth: 190 });

            const clientInfoY = startY + 50;
            doc.setFontSize(12);
            doc.text(`ID: ${membership.id}`, 10, clientInfoY);
            doc.text(`Nombre: ${membership.name}`, 10, clientInfoY + 5);
            doc.text(`Tipo de Membresía: ${membership.type}`, 10, clientInfoY + 10);
            doc.text(`Fecha de Expiración: ${membership.expiration}`, 10, clientInfoY + 15);

            const usersY = clientInfoY + 25;
            doc.text("Usuarios incluidos en la membresía:", 10, usersY);

            const usersList = membership.users.map((user, index) => `${index + 1}. Cliente: ${user}`);
            usersList.forEach((user, i) => {
                doc.text(user, 10, usersY + (i + 1) * 5);
            });

            const servicesY = usersY + usersList.length * 5 + 10;
            const services = membership.services.map(service => [
                service.id, service.descripcion, service.cantidad
            ]);

            doc.autoTable({
                head: [['ID', 'Descripción', 'Cantidad']],
                body: services,
                startY: servicesY,
                theme: 'grid'
            });

            const notesY = doc.previousAutoTable.finalY + 10;
            doc.text("Notas adicionales:", 10, notesY);
            doc.text("_________________________________________________________", 10, notesY + 5);
            doc.text("_________________________________________________________", 10, notesY + 15);

            const signatureY = notesY + 40;
            doc.text("Firma del Cliente:", 10, signatureY);
            doc.text("_________________________", 10, signatureY + 10);

            doc.text("Firma del Empleado:", 120, signatureY);
            doc.text("_________________________", 120, signatureY + 10);

            doc.addImage(bannerURLP, "PNG", 0, 270, 210, 24);

            return doc.output('datauristring'); // Devuelve el PDF en formato Base64 URI
        }

        document.addEventListener("DOMContentLoaded", function() {
            if (membershipData) {
                const pdfPreview = document.getElementById("pdf-preview");
                const pdfDataUri = generatePDF(membershipData);

                if (pdfPreview) {
                    pdfPreview.src = pdfDataUri; // Asigna el PDF al iframe
                }
            } else {
                console.error("No hay datos de membresía para generar el PDF.");
            }
        });
    </script>
</body>
</html>
