<?php
session_start();
// Ejemplo de los datos como los tienes configurados en PHP

?>

<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Justificante Médico PDF</title>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/qrious/4.0.2/qrious.min.js"></script>
  <style>
    body {
      font-family: Arial, sans-serif;
    }
    #pdf-preview {
      width: 100%;
      height: 600px;
      border: 1px solid #ddd;
    }
  </style>
</head>
<body>
  <h2>Vista Previa del Justificante Médico</h2>
  <iframe id="pdf-preview"></iframe>

  <script>
    const { jsPDF } = window.jspdf;

    // Pasar los datos desde PHP al código JavaScript
    const rawData = <?php echo json_encode($_SESSION["datosJustificante"]); ?>;

    // Validar que rawData contiene datos
    if (!Array.isArray(rawData) || rawData.length === 0 || !rawData[0].Datos) {
      console.error("No se pudieron cargar los datos del justificante.", rawData);
      alert("Error al cargar los datos del justificante.");
    } else {
      // Parsear la propiedad "Datos" del primer elemento
      const justificanteData = JSON.parse(rawData[0].Datos);

      function generatePDF() {
        const doc = new jsPDF({
          format: "a5",
          orientation: "landscape"
        });

        const bannerURLA = "http://167.172.224.160/MiSi/librerias/Impresora/IMG/48-Banner_A.png";
        const bannerURLP = "http://167.172.224.160/MiSi/librerias/Impresora/IMG/48-Banner_P.png";

        // Agregar banner superior
        doc.addImage(bannerURLA, "PNG", 0, 0, 210, 24);

        // Título del justificante
        doc.setFont("helvetica", "bold");
        doc.setFontSize(16);
        doc.text("Justificante Médico", 105, 40, { align: "center" });

        // Datos del paciente y doctor
        const startY = 50;

        doc.setFont("helvetica", "normal");
        doc.setFontSize(10);
        doc.text(`Paciente: ${justificanteData.paciente.nombre}`, 10, startY);
        doc.text(`Fecha: ${justificanteData.paciente.fecha}`, 10, startY + 5);
        doc.text(`Edad: ${justificanteData.paciente.edad}  |  Peso: ${justificanteData.paciente.peso}`, 10, startY + 10);
        doc.text(`Teléfono: ${justificanteData.paciente.telefono}`, 10, startY + 15);

        doc.text(`Doctor: ${justificanteData.doctor.nombre}`, 150, startY);
        doc.text(`Especialidad: ${justificanteData.doctor.especialidad}`, 150, startY + 5);
        doc.text(`Cédula: ${justificanteData.doctor.cedula}`, 150, startY + 10);

        // Diagnóstico
        let currentY = startY + 25;
        doc.setFont("helvetica", "bold");
        doc.setFontSize(12);
        doc.text("Diagnóstico:", 10, currentY);
        doc.setFont("helvetica", "normal");
        doc.text(justificanteData.diagnostico, 10, currentY + 5, { maxWidth: 190 });

        // Justificación
        currentY += 15;
        doc.setFont("helvetica", "bold");
        doc.text("Justificación:", 10, currentY);
        doc.setFont("helvetica", "normal");
        doc.text(justificanteData.justificacion, 10, currentY + 5, { maxWidth: 190 });

        // Instrucciones
        currentY += 15;
        doc.setFont("helvetica", "bold");
        doc.text("Instrucciones:", 10, currentY);
        doc.setFont("helvetica", "normal");
        doc.text(justificanteData.instrucciones.replace(/\n/g, "\n"), 10, currentY + 5, { maxWidth: 190 });

        // Generar QR
        const qrCanvas = document.createElement("canvas");
        const qr = new QRious({
          element: qrCanvas,
          value: "http://167.172.224.160/MiSi/",
          size: 80
        });

        doc.addImage(qrCanvas.toDataURL(), "PNG", 180, 95, 30, 30);

        // Agregar banner inferior
        doc.addImage(bannerURLP, "PNG", 0, 125, 210, 24);

        // Convertir PDF en Base64
        const pdfData = doc.output('datauristring');

        // Mostrar el PDF en el iframe
        document.getElementById('pdf-preview').src = pdfData;
      }

      // Generar vista previa al cargar la página
      generatePDF();
    }
  </script>
</body>
</html>
