<?php 
  $urlajaxUpdate = "http://167.172.224.160/MiSi/librerias/ajaxAPP/ajaxSimple.php";
?>

<!-- Modal para mostrar proveedores -->
<div class="modal fade" id="modalProveedores" tabindex="-1" aria-labelledby="modalProveedoresLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="modalProveedoresLabel">Lista de Proveedores</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div id="Mensaje"></div>
                
                <!-- Botón Gestionar Proveedores -->
                <button type="button" class="btn btn-primary mb-3" onclick="gestionarProveedores()">Gestionar Proveedores</button>
                
                <!-- Filtro de búsqueda -->
                <div class="form-group">
                    <label for="searchInput">Buscar:</label>
                    <input type="text" id="searchInput" class="form-control" placeholder="Buscar proveedor...">
                </div>
                
                <table class="table table-striped table-hover">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Nombre</th>
                            <th>Contacto</th>
                            <th>Teléfono</th>
                            <th>Email</th>
                            <th>WEB</th>
                        </tr>
                    </thead>
                    <tbody id="tablaProveedores">
                        <!-- Aquí se llenarán los proveedores dinámicamente -->
                    </tbody>
                </table>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
            </div>
        </div>
    </div>
</div>

<script>
function TablaProveedores() {
    var formData = {
        id: 0,
        nco: 3,
        funcion: "selectM"
    };

    // AJAX para enviar los datos al servidor 
    $.ajax({
        url: '<?php echo $urlajaxUpdate; ?>', // Reemplaza con la ruta correcta a tu script del servidor
        type: 'POST',
        data: formData,
        success: function(response) {
            try {
                console.log(response);
                var proveedores = JSON.parse(response);
                
                // Limpiar la tabla antes de llenarla
                $('#tablaProveedores').empty();
                
                // Llenar la tabla con los datos de los proveedores
                for (var key in proveedores) {
                    if (proveedores.hasOwnProperty(key)) {
                        var proveedor = proveedores[key];
                        var fila = '<tr>' +
                                       '<td>' + proveedor.ID_Proveedor + '</td>' +
                                       '<td>' + proveedor.Nombre + '</td>' +
                                       '<td>' + proveedor.Contacto + '</td>' +
                                       '<td>' + proveedor.Telefono + '</td>' +
                                       '<td>' + proveedor.EMail + '</td>' +
                                       '<td><a href="' + proveedor.WEB + '" class="btn btn-link" target="_blank"><i class="fas fa-globe"></i></a></td>' +
                                   '</tr>';
                        $('#tablaProveedores').append(fila);
                    }
                }
                
                // Mostrar el modal
                $('#modalProveedores').modal('show');
                
                // Añadir el filtro de búsqueda
                $('#searchInput').on('keyup', function() {
                    var value = $(this).val().toLowerCase();
                    $('#tablaProveedores tr').filter(function() {
                        $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1);
                    });
                });
            } catch (error) {
                console.error('Error al procesar la respuesta del servidor:', error);
            }
        },
        error: function(error) {
            console.error('Error al enviar datos al servidor:', error);
        }
    });
}

function gestionarProveedores() {
    window.location.href = 'http://167.172.224.160/MiSi/Index/index1.php?contenido=CatalogoProveedores';
}
</script>
