<!-- Modal -->
<div class="modal fade" id="reporteModal" tabindex="-1" role="dialog" aria-labelledby="reporteModalLabel"
    aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="reporteModalLabel">Reporte de Producto</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true" class="text-white">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <!-- Información del producto -->
                    <div class="col-xl-4 col-md-6 col-sm-12 mb-3">
                        <div class="card">
                            <div class="modal-header bg-primary">
                                <h4 class="card-title text-white">Información del Producto</h4>
                            </div>
                            <div class="card-content">
                                <div class="card-body">
                                    <div class="media d-flex">
                                        <div class="align-self-center mr-3">
                                            <i class="fa fa-tag fa-5x"></i>
                                        </div>
                                        <div class="media-body">
                                            <p class="card-text"><strong>Código:</strong> <span id="codigo"></span></p>
                                            <p class="card-text"><strong>Marca:</strong> <span id="marca"></span></p>
                                            <p class="card-text"><strong>Modelo:</strong> <span id="modelo"></span></p>
                                            <p class="card-text"><strong>Descripción Corta:</strong> <span id="descripcion"></span></p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Precios -->
                    <div class="col-xl-4 col-md-6 col-sm-12 mb-3">
                        <div class="card">
                            <div class="modal-header bg-warning">
                                <h4 class="card-title text-white">Precios</h4>
                            </div>
                            <div class="card-content">
                                <div class="card-body">
                                    <div class="media d-flex">
                                        <div class="align-self-center mr-3">
                                            <i class="fa fa-money warning fa-5x"></i>
                                        </div>
                                        <div class="media-body">
                                            <p class="card-text"><strong>Costo:</strong> <span id="costo"></span></p>
                                            <p class="card-text"><strong>Precio 1:</strong> <span id="precio1"></span></p>
                                            <p class="card-text"><strong>Precio 2:</strong> <span id="precio2"></span></p>
                                            <p class="card-text"><strong>Precio 3:</strong> <span id="precio3"></span></p>
                                            <p class="card-text"><strong>Precio 4:</strong> <span id="precio4"></span></p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Existencias -->
                    <div class="col-xl-4 col-md-6 col-sm-12 mb-3">
                        <div class="card">
                            <div class="modal-header bg-success">
                                <h4 class="card-title text-white">Existencias</h4>
                            </div>
                            <div class="card-content">
                                <div class="card-body">
                                    <div class="media d-flex">
                                        <div class="media-body text-left">
                                            <h3 class="success" id="existenciasCantidad">50</h3>
                                            <span>Existencias</span>
                                        </div>
                                        <div class="align-self-center">
                                            <i class="fa fa-chart"></i>
                                        </div>
                                    </div>
                                    <div class="progress mt-1 mb-0" style="height: 7px;">
                                        <div class="progress-bar bg-success" role="progressbar" style="width: 50%" aria-valuenow="5" aria-valuemin="0" aria-valuemax="10"></div>
                                    </div>
                                    <p class="mt-1 mb-0 text-muted"><strong>Existencia Mínima:</strong> <span id="existenciaMinima">10</span></p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
            </div>
        </div>
    </div>
</div>

<?php 
//UPDATE `MicroSi_Datos`.`1-Catalogo` SET `Codigo` = '11' WHERE (`IDCa` = '1');
  $urlajaxSelectInfoR= "http://167.172.224.160/MiSi/librerias/ajaxAPP/ajaxSimple.php";

?>

<script>
    // Llama a esta función para mostrar el modal con la información del producto
    function TablaInformacionR(id) {
        $('#reporteModal').modal('show');
        generarContenidoModal(id);
    }

    // Función para generar el contenido del modal con los datos del producto
    function generarContenidoModal(id) {
        var formData = {
            id: id,
            funcion: "select"
        };

        $.ajax({
            url: '<?php echo $urlajaxSelectInfoR; ?>',
            type: 'POST',
            data: formData,
            success: function(response) {
                // Parsea la respuesta JSON
                var data = JSON.parse(response);

                // Obtiene los datos del producto
                const producto = data[0];

                // Llena el modal con la información del producto
                document.getElementById("codigo").innerText = producto.Codigo;
                document.getElementById("marca").innerText = producto.Marca;
                document.getElementById("modelo").innerText = producto.Modelo;
                document.getElementById("descripcion").innerText = producto.Descripcion_Corta;
                document.getElementById("costo").innerText = producto.Costo;
                document.getElementById("precio1").innerText = producto.Precio_1;
                document.getElementById("precio2").innerText = producto.Precio_2;
                document.getElementById("precio3").innerText = producto.Precio_3;
                document.getElementById("precio4").innerText = producto.Precio_4;
                document.getElementById("existenciasCantidad").innerText = producto.Existencia;
                document.getElementById("existenciaMinima").innerText = producto.Existencia_Min;

                // Actualiza la barra de progreso de existencias
                const existenciasBarra = document.querySelector(".progress-bar");
                const maxExistencias = parseInt(producto.Existencia_Min);
                const existencias = parseInt(producto.Existencia);
                existenciasBarra.style.width = (existencias / maxExistencias) * 100 + "%";
                existenciasBarra.setAttribute("aria-valuenow", existencias);
                existenciasBarra.setAttribute("aria-valuemax", maxExistencias);
            },
            error: function(error) {
                console.error('Error al enviar datos al servidor:', error);
            }
        });
    }
</script>
