<?php 
  $urlajaxSelectInfoC= "http://167.172.224.160/MiSi/librerias/ajaxAPP/ajaxSimple.php";
?>
<div class="modal fade" id="modalNotaCompra" tabindex="-1" aria-labelledby="modalNotaCompraLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <!-- Modifica el título para reflejar que es un reporte de compra -->
                <h5 class="modal-title" id="modalNotaCompraLabel">Nota de Compra</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <!-- Card de Datos del Proveedor -->
                <div class="card border-primary"> 
                    <div class="card-header bg-light border-primary text-primary">
                        <!-- Modifica el título para reflejar los datos del proveedor -->
                        <i class="fa fa-user"></i> <strong>Datos del Proveedor</strong>
                    </div>
                    <div class="card-body" id="datosProveedor">
                        <div class="row">
                            <div class="col-md-6">
                                <!-- Modifica las etiquetas para mostrar los datos del proveedor -->
                                <p class="card-title fw-bold"><i class="fa fa-id-card"></i> Nombre:</p>
                                <p class="card-text"><i class="fa fa-phone"></i> Teléfono:</p>
                                <p class="card-text"><i class="fa fa-id-badge"></i> ID Proveedor:</p>
								<p class="card-text"><i class="fa fa-key"></i> Token:</p>		
                                <p class="card-text"><i class="fa fa-note"></i> Obeservaciones</p>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Card de Detalles de la Compra -->
                <div class="card border-success mt-3">
                    <div class="card-header bg-light border-success text-success">
                        <!-- Modifica el título para reflejar los detalles de la compra -->
                        <i class="fa fa-receipt"></i> <strong>Detalles de la Compra</strong>
                    </div>
                    <div class="card-body" id="datosCompra">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>Cantidad</th>
                                    <th>Descripción</th>
                                    <th>Precio</th>
                                </tr>
                            </thead>
                            <tbody id="tablaProductos">
                                <!-- Aquí se llenarán los detalles de la compra dinámicamente -->
                            </tbody>
                        </table>
                        <p class="text-end fs-4 fw-bold"><strong>Total:</strong> <span class="text-dark" id="totalCompra">$0.00</span></p>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal"><i class="fa fa-times"></i> Cerrar</button>
            </div>
        </div>
    </div>
</div>

<script>
function TablaInformacionC(id) {
    var myModal = new bootstrap.Modal(document.getElementById('modalNotaCompra'));
    myModal.show();
    generarContenidoModalC(id);
}

function generarContenidoModalC(id) {
    var formData1 = {
        id: id,
        nco: 1, 
        funcion: "selectM"
    };

    //Consulta
    $.ajax({
        url: '<?php echo $urlajaxSelectInfoC; ?>',
        type: 'POST',
        data: formData1,
        success: function(response) {
			console.log(response);
            try {
                var data1 = JSON.parse(response);
				
                // Verificar si la respuesta contiene datos
                if (data1 && Object.keys(data1).length > 0) {
                    // Obtener el primer elemento del objeto (asumiendo que solo hay uno)
                    var compra = data1["0"];

                    // Llenar datos del proveedor
                    $('#datosProveedor .card-title').html('<i class="fa fa-id-card"></i> Nombre: ' + compra.NombreProveedor);
                    $('#datosProveedor .card-text:eq(0)').html('<i class="fa fa-phone"></i> Teléfono: ' + compra.TelefonoProveedor);
                    $('#datosProveedor .card-text:eq(1)').html('<i class="fa fa-id-badge"></i> ID Proveedor: ' + compra.IDP);
                    $('#datosProveedor .card-text:eq(2)').html('<i class="fa fa-key"></i> Token: ' + compra.Token);
					$('#datosProveedor .card-text:eq(3)').html('<i class="fa fa-sticky-note"></i> Obeservaciones: ' + compra.Descripcion);

                    // Procesar los detalles de la compra
                    var detallesCompra = JSON.parse(compra.Datos);
                    $('#tablaProductos').empty(); // Limpiar tabla antes de llenarla
                    detallesCompra.forEach(function(detalle) {
                        var fila = '<tr>' +
                                       '<td>' + detalle.Cantidad + '</td>' +
                                       '<td>' + detalle.Descrpicion + '</td>' +
                                       '<td>' + detalle.Precio + '</td>' +
                                   '</tr>';
                        $('#tablaProductos').append(fila);
                    });

                    // Mostrar total de la compra
                    $('#totalCompra').html('$' + compra.Total.toFixed(2));
                } else {
                    console.error('La respuesta del servidor no contiene datos.');
                }
            } catch (error) {
                console.error('Error al procesar la respuesta del servidor:', error);
            }
        },
        error: function(error) {
            console.error('Error al enviar datos al servidor:', error);
        }
    });
}

</script>
