<!-- Modal -->
<div class="modal fade" id="textFormModal" tabindex="-1" role="dialog" aria-labelledby="textFormModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document" style="max-width: 1000px;">
        <div class="modal-content">
			<form id="dynamicForm" action="javascript:void(0);" method="post">
            <!-- Encabezado del Modal -->
            <div class="modal-header">
                <h5 class="modal-title" id="textFormModalLabel">Editor de Formulario</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <!-- Cuerpo del Modal -->
            <div class="modal-body" style="height: 600px; overflow-y: auto;">
                <div class="row">
                    <!-- Columna Izquierda: Preview del Formulario -->
                    <div class="col-md-6">
                        <h2>Preview del Formulario</h2>
                        
                            <div id="formFields">
                                <!-- Los campos del formulario se agregarán aquí -->
                            </div>
                            
                        
                    </div>
                    
                    <!-- Columna Derecha: CRUD para Editar Preguntas -->
                    <div class="col-md-6">
                        <h2>Editar Preguntas</h2>
                        
                        <div id="fieldsList">
                            <!-- Lista de campos para editar -->
                        </div>
                    </div>
                </div>
            </div>
            <!-- Pie del Modal -->
            <div class="modal-footer">
				<button type="button" class="btn btn-success" data-toggle="modal" data-target="#addFieldModal" onclick="clearModal()">Agregar Pregunta</button>
				<button type="submit" class="btn btn-primary" onClick="Guardar">Guardar Formulario</button>
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
            </div>
				</form>
        </div>
    </div>
</div>

<!-- Modal para agregar/editar campo -->
<div class="modal fade" id="addFieldModal" tabindex="-1" role="dialog" aria-labelledby="addFieldModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="addFieldModalLabel">Agregar Campo</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form id="addFieldForm">
                    <div class="form-group">
                        <label for="fieldType">Tipo de campo</label>
                        <select class="form-control" id="fieldType">
                            <option value="text">Text</option>
                            <option value="email">Email</option>
                            <option value="select">Select</option>
                            <option value="number">Number</option>
                            <option value="textarea">Textarea</option>
                            <option value="checkbox">Checkbox</option>
                            <option value="radio">Radio</option>
                            <option value="date">Date</option>
                            <option value="time">Time</option>
                            <option value="password">Password</option>
                            <option value="tel">Telephone</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="fieldName">Nombre del campo</label>
                        <input type="text" class="form-control" id="fieldName" required>
                    </div>
                    <div class="form-group">
                        <label for="fieldLabel">Etiqueta del campo</label>
                        <input type="text" class="form-control" id="fieldLabel" required>
                    </div>
                    <div class="form-group" id="fieldPlaceholderGroup">
                        <label for="fieldPlaceholder">Placeholder del campo</label>
                        <input type="text" class="form-control" id="fieldPlaceholder">
                    </div>
                    <div class="form-group" id="fieldOptionsGroup" style="display: none;">
                        <label for="fieldOptions">Opciones (separadas por comas, formato: valor: texto)</label>
                        <input type="text" class="form-control" id="fieldOptions" value="opcion1: Opción 1, opcion2: Opción 2, opcion3: Opción 3">
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
                <button type="button" class="btn btn-primary" id="saveField">Guardar Campo</button>
            </div>
        </div>
    </div>
</div>

<script>
    let editingFieldIndex = -1;
    var modalFormularioID = 0;

    // Asegúrate de que formData se está obteniendo correctamente desde el servidor
    var formData = <?php echo json_encode($datsosP[0]["Pagina_Datos"], JSON_PRETTY_PRINT); ?>;
  

    // Si formData es un JSON string, lo parseamos
    if (typeof formData === 'string') {
        try {
            formData = JSON.parse(formData);
        } catch (e) {
            console.error("Error parsing formData JSON:", e);
            formData = [];
        }
    }

    // Asegurarse de que formData es un array válido
    let formFields = Array.isArray(formData) ? formData : [];

    function formEditar(id) {
        $('#textFormModal').modal('show');
        modalFormularioID = id;
        formFields = Array.isArray(formData) ? formData : [];
        renderFormFields();
        renderFieldsList();
    }
	
	
	

    function renderFormFields() {
        $('#formFields').empty();
        formFields.forEach((field) => {
            let fieldHtml = '<div class="form-group">';
            fieldHtml += `<label for="${field.name}">${field.label}</label>`;
            switch (field.type) {
                case 'text':
                case 'email':
                case 'number':
                case 'date':
                case 'time':
                case 'password':
                case 'tel':
                    fieldHtml += `<input type="${field.type}" class="form-control" name="${field.name}" placeholder="${field.placeholder}">`;
                    break;
                case 'textarea':
                    fieldHtml += `<textarea class="form-control" name="${field.name}" placeholder="${field.placeholder}"></textarea>`;
                    break;
                case 'select':
                    fieldHtml += `<select class="form-control" name="${field.name}">`;
                    field.options.forEach(option => {
                        fieldHtml += `<option value="${option.value}">${option.text}</option>`;
                    });
                    fieldHtml += '</select>';
                    break;
                case 'checkbox':
                    fieldHtml += `<div>`;
                    field.options.forEach(option => {
                        fieldHtml += `<div class="form-check">
                                        <input class="form-check-input" type="checkbox" name="${field.name}[]" value="${option.value}">
                                        <label class="form-check-label">${option.text}</label>
                                      </div>`;
                    });
                    fieldHtml += `</div>`;
                    break;
                case 'radio':
                    fieldHtml += `<div>`;
                    field.options.forEach(option => {
                        fieldHtml += `<div class="form-check">
                                        <input class="form-check-input" type="radio" name="${field.name}" value="${option.value}">
                                        <label class="form-check-label">${option.text}</label>
                                      </div>`;
                    });
                    fieldHtml += `</div>`;
                    break;
            }
            fieldHtml += '</div>';
            $('#formFields').append(fieldHtml);
        });
    }

    function renderFieldsList() {
        $('#fieldsList').empty();
        formFields.forEach((field, index) => {
            let fieldHtml = '<div class="d-flex align-items-center mb-2">';
            fieldHtml += '<div class="flex-grow-1">';
            fieldHtml += `<strong>Etiqueta:</strong> ${field.label} `;
            fieldHtml += `<strong>Tipo:</strong> ${field.type} `;
            if (field.placeholder) {
                fieldHtml += `<strong>Placeholder:</strong> ${field.placeholder} `;
            }
            if (field.options) {
                fieldHtml += `<strong>Opciones:</strong> ${field.options.map(option => `${option.value}: ${option.text}`).join(', ')} `;
            }
            fieldHtml += '</div>';
            fieldHtml += '<div>';
            fieldHtml += '<div class="btn-group">';
            fieldHtml += `<button type="button" class="btn btn-primary btn-sm" onclick="editField(${index})">Editar</button>`;
            fieldHtml += `<button type="button" class="btn btn-danger btn-sm" onclick="deleteField(${index})">Eliminar</button>`;
            fieldHtml += '</div>';
            fieldHtml += '</div>';
            fieldHtml += '</div>';
            $('#fieldsList').append(fieldHtml);
        });
    }

    function deleteField(index) {
        formFields.splice(index, 1);
        renderFormFields();
        renderFieldsList();
    }

    function editField(index) {
        editingFieldIndex = index;
        let field = formFields[index];
        $('#addFieldModalLabel').text('Editar Campo');
        $('#fieldType').val(field.type);
        $('#fieldName').val(field.name);
        $('#fieldLabel').val(field.label);
        if (['text', 'email', 'number', 'textarea', 'date', 'time', 'password', 'tel'].includes(field.type)) {
            $('#fieldPlaceholderGroup').show();
            $('#fieldOptionsGroup').hide();
            $('#fieldPlaceholder').val(field.placeholder);
        } else {
            $('#fieldPlaceholderGroup').hide();
            $('#fieldOptionsGroup').show();
            $('#fieldOptions').val(field.options.map(option => `${option.value}: ${option.text}`).join(', '));
        }
        $('#addFieldModal').modal('show');
    }

    function clearModal() {
        editingFieldIndex = -1;
        $('#addFieldModalLabel').text('Agregar Campo');
        $('#fieldType').val('text');
        $('#fieldName').val('');
        $('#fieldLabel').val('');
        $('#fieldPlaceholder').val('');
        $('#fieldOptions').val('opcion1: Opción 1, opcion2: Opción 2, opcion3: Opción 3');
        $('#fieldPlaceholderGroup').show();
        $('#fieldOptionsGroup').hide();
    }

    $('#fieldType').on('change', function() {
        if (['select', 'checkbox', 'radio'].includes($(this).val())) {
            $('#fieldOptionsGroup').show();
            $('#fieldPlaceholderGroup').hide();
        } else {
            $('#fieldOptionsGroup').hide();
            $('#fieldPlaceholderGroup').show();
        }
    });

    $('#saveField').on('click', function() {
        let fieldType = $('#fieldType').val();
        let fieldName = $('#fieldName').val();
        let fieldLabel = $('#fieldLabel').val();
        let fieldPlaceholder = ['text', 'email', 'number', 'textarea', 'date', 'time', 'password', 'tel'].includes(fieldType) ? $('#fieldPlaceholder').val() : '';
        let newField = {
            type: fieldType,
            name: fieldName,
            label: fieldLabel,
            placeholder: fieldPlaceholder
        };

        if (['select', 'checkbox', 'radio'].includes(fieldType)) {
            let options = $('#fieldOptions').val().split(',').map(option => {
                let [value, text] = option.split(':');
                return { value: value.trim(), text: text.trim() };
            });
            newField.options = options;
        }

        if (editingFieldIndex >= 0) {
            formFields[editingFieldIndex] = newField;
        } else {
            formFields.push(newField);
        }
        renderFormFields();
        renderFieldsList();
        $('#addFieldModal').modal('hide');
    });

    $('#dynamicForm').on('submit', function() {
		editarFormularioJSON(modalFormularioID, JSON.stringify(formFields))
		console.log(JSON.stringify(formFields));
        alert('El formulario ha sido enviado. Ver la consola para el JSON generado.');
    });
	


    renderFormFields();
    renderFieldsList();
	

	
	 function editarFormularioJSON(id, valor) {
      var formData = JSON.parse(valor); // Convertir el valor JSON a objeto FormData
      var columnas = ["Bloque", "Pagina", "Pagina_Datos", "Pagina_Colores", "Pagina_Iconos"];
      var valores = ["Formulario", "Pag", valor, "valor_pagina_c", "valor_pagina_i"];

      var formDataToSend = {
        id: id,
        NoCol: 5,
        column: columnas,
        value: valores,
        funcion: "updateMVL"
      };

      console.log(formDataToSend);
      $.ajax({
        url: urlajaxUpdate,
        type: 'POST',
        data: formDataToSend,
        success: function(response) {
          $("#Mensaje").html('<div class="alert alert-success alert-dismissible alert-alt fade show"><button type="button" class="close h-100" data-dismiss="alert" aria-label="Close"><span><i class="mdi mdi-close"></i></span></button><strong>Listo </strong> Se actualizo correctamente.</div>');
          setTimeout(function() { $('#Mensaje').empty(); }, 2000);
          console.log(response);
        },
        error: function(error) {
          console.error('Error al enviar datos al servidor:', error);
        }
      });
    }
	
</script>
