modalFormularioID<div class="modal fade" id="monolito" tabindex="-1" role="dialog" aria-labelledby="monolitoModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
      <div class="modal-content">

        <!-- Encabezado del Modal -->
        <div class="modal-header">
          <h4 class="modal-title" id="monolitoModalLabel">Modal del Monolito</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>

        <!-- Cuerpo del Modal -->
        <div class="modal-body" style="max-height: 400px; overflow-y: auto;">
          <form id="jsonForm">
            <!-- El formulario se construirá dinámicamente aquí -->
          </form>
        </div>

        <!-- Pie del Modal -->
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" id="closeButton">Cerrar</button>
          <button type="button" class="btn btn-primary" id="saveButton">Guardar</button>
        </div>

      </div>
    </div>
  </div>

  <script>
	  
    var idMonolitica;
    var urlajaxUpdate = "http://167.172.224.160/MiSi/librerias/ajaxAPP/ajaxSimple.php";

    function openModal(id) {
      idMonolitica = id;
      $('#monolito').modal('show');
    }

    var data = {
      "sections": [
        {
          "type": "banner",
          "title": "Story",
          "subtitle": "A (modular, highly tweakable) responsive one-page template designed by HTML5 UP and released for free under the Creative Commons.",
          "buttonText": "Get Started",
          "image": "images/banner.jpg"
        },
        {
          "type": "spotlight",
          "title": "Magna etiam feugiat",
          "content": "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi id ante sed ex pharetra lacinia sit amet vel massa. Donec facilisis laoreet nulla eu bibendum. Donec ut ex risus. Fusce lorem lectus, pharetra pretium massa et, hendrerit vestibulum odio lorem ipsum dolor sit amet.",
          "buttonText": "Learn More",
          "image": "images/spotlight01.jpg",
          "orient": "right"
        },
        {
          "type": "spotlight",
          "title": "Tempus adipiscing",
          "content": "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi id ante sed ex pharetra lacinia sit amet vel massa. Donec facilisis laoreet nulla eu bibendum. Donec ut ex risus. Fusce lorem lectus, pharetra pretium massa et, hendrerit vestibulum odio lorem ipsum dolor sit amet.",
          "buttonText": "Learn More",
          "image": "images/spotlight02.jpg",
          "orient": "left"
        },
        {
          "type": "spotlight",
          "title": "Pharetra etiam nulla",
          "content": "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi id ante sed ex pharetra lacinia sit amet vel massa. Donec facilisis laoreet nulla eu bibendum. Donec ut ex risus. Fusce lorem lectus, pharetra pretium massa et, hendrerit vestibulum odio lorem ipsum dolor sit amet.",
          "buttonText": "Learn More",
          "image": "images/spotlight03.jpg",
          "orient": "right"
        },
        {
          "type": "gallery",
          "title": "Massa sed condimentum",
          "content": "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi id ante sed ex pharetra lacinia sit amet vel massa. Donec facilisis laoreet nulla eu bibendum. Donec ut ex risus. Fusce lorem lectus, pharetra pretium massa et, hendrerit vestibulum odio lorem ipsum.",
          "images": [
            { "full": "images/gallery/fulls/01.jpg", "thumb": "images/gallery/thumbs/01.jpg", "caption": "Ipsum Dolor" },
            { "full": "images/gallery/fulls/02.jpg", "thumb": "images/gallery/thumbs/02.jpg", "caption": "Feugiat Lorem" },
            { "full": "images/gallery/fulls/03.jpg", "thumb": "images/gallery/thumbs/03.jpg", "caption": "Magna Amet" }
          ]
        },
        {
          "type": "items",
          "title": "Ipsum sed consequat",
          "content": "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi id ante sed ex pharetra lacinia sit amet vel massa. Donec facilisis laoreet nulla eu bibendum. Donec ut ex risus. Fusce lorem lectus, pharetra pretium massa et, hendrerit vestibulum odio lorem ipsum.",
          "items": [
            { "icon": "fa fa-gem", "title": "Lorem", "content": "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi dui turpis, cursus eget orci amet aliquam congue semper. Etiam eget ultrices risus nec tempor elit." },
            { "icon": "fa fa-save", "title": "Ipsum", "content": "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi dui turpis, cursus eget orci amet aliquam congue semper. Etiam eget ultrices risus nec tempor elit." },
            { "icon": "fa fa-save", "title": "Ipsum", "content": "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi dui turpis, cursus eget orci amet aliquam congue semper. Etiam eget ultrices risus nec tempor elit." }
          ]
        },
        {
          "type": "contact",
          "title": "Get in touch"
        }
      ]
    };
    
	  
	   datase  = <?php echo json_encode($datsosP[0]["Pagina_Datos"], JSON_PRETTY_PRINT); ?>;
	    // Verificar la longitud de la cadena JSON
    if (datase.length < 10) {
        console.error("Se cargara el default.");
    } else {
        // Parsear los datos obtenidos de PHP, si es necesario
        var data = JSON.parse(datase);
       // console.log(data);
    }
	  
	  
    var form = document.getElementById("jsonForm");

    data.sections.forEach(function(section, index) {
      var fieldset = document.createElement("fieldset");
      var legend = document.createElement("legend");
      legend.textContent = section.type.charAt(0).toUpperCase() + section.type.slice(1); // Capitalize first letter
      fieldset.appendChild(legend);

      for (var key in section) {
        if (key !== "type") {
          if (typeof section[key] === "object") {
            var sublegend = document.createElement("legend");
            sublegend.textContent = key.charAt(0).toUpperCase() + key.slice(1); // Capitalize first letter
            fieldset.appendChild(sublegend);

            if (Array.isArray(section[key])) {
              section[key].forEach(function(item, itemIndex) {
                var itemLegend = document.createElement("legend");
                itemLegend.textContent = itemIndex + 1; // Use the index as legend text
                fieldset.appendChild(itemLegend);

                for (var subkey in item) {
                  var label = document.createElement("label");
                  label.textContent = subkey.charAt(0).toUpperCase() + subkey.slice(1); // Capitalize first letter
                  var input = document.createElement("input");
                  input.setAttribute("type", "text");
                  input.setAttribute("name", index + "_" + key + "_" + itemIndex + "_" + subkey); // Use index to identify each section
                  input.value = item[subkey];
                  input.className = "form-control";
                  label.className = "form-control-label";
                  fieldset.appendChild(label);
                  fieldset.appendChild(input);
                  fieldset.appendChild(document.createElement("br"));
                }
              });
            } else {
              for (var subkey in section[key]) {
                var label = document.createElement("label");
                label.textContent = subkey.charAt(0).toUpperCase() + subkey.slice(1); // Capitalize first letter
                var input = document.createElement("input");
                input.setAttribute("type", "text");
                input.setAttribute("name", index + "_" + key + "_" + subkey); // Use index to identify each section
                input.value = section[key][subkey];
                input.className = "form-control";
                label.className = "form-control-label";
                fieldset.appendChild(label);
                fieldset.appendChild(input);
                fieldset.appendChild(document.createElement("br"));
              }
            }
          } else {
            var label = document.createElement("label");
            label.textContent = key.charAt(0).toUpperCase() + key.slice(1); // Capitalize first letter
            var input = document.createElement("input");
            input.setAttribute("type", "text");
            input.setAttribute("name", index + "_" + key); // Use index to identify each section
            input.value = section[key];
            input.className = "form-control";
            label.className = "form-control-label";
            fieldset.appendChild(label);
            fieldset.appendChild(input);
            fieldset.appendChild(document.createElement("br"));
          }
        }
      }
      form.appendChild(fieldset);
    });

    var submitButton = document.createElement("button");
    submitButton.setAttribute("type", "submit");
    submitButton.textContent = "Guardar";
    submitButton.className = "btn btn-primary";
    form.appendChild(submitButton);

    document.getElementById("jsonForm").addEventListener("submit", function(event) {
      event.preventDefault();

      var formData = new FormData(this);
      var sections = [];

      for (const entry of formData.entries()) {
        var fieldName = entry[0];
        var fieldValue = entry[1];
        var fieldSplit = fieldName.split("_");

        var sectionIndex = parseInt(fieldSplit[0]);
        var fieldName = fieldSplit[1];

        if (!sections[sectionIndex]) {
          sections[sectionIndex] = { type: data.sections[sectionIndex].type };
        }

        if (fieldSplit.length === 2) {
          sections[sectionIndex][fieldName] = fieldValue;
        } else if (fieldSplit.length === 4) {
          var itemIndex = parseInt(fieldSplit[2]);
          var subkey = fieldSplit[3];
          if (!sections[sectionIndex][fieldName]) {
            sections[sectionIndex][fieldName] = [];
          }
          if (!sections[sectionIndex][fieldName][itemIndex]) {
            sections[sectionIndex][fieldName][itemIndex] = {};
          }
          sections[sectionIndex][fieldName][itemIndex][subkey] = fieldValue;
        } else if (fieldSplit.length === 3) {
          var subkey = fieldSplit[2];
          if (!sections[sectionIndex][fieldName]) {
            sections[sectionIndex][fieldName] = {};
          }
          sections[sectionIndex][fieldName][subkey] = fieldValue;
        }
      }

      data.sections = sections;
      var datajson = JSON.stringify(data, null, 2);
      console.log(datajson);
      editarTablaMono(idMonolitica, datajson);

      // Aquí puedes enviar los datos al servidor o hacer lo que necesites con el JSON actualizado
    });

    document.getElementById("closeButton").addEventListener("click", function() {
      document.getElementById("jsonForm").dispatchEvent(new Event("submit"));
      $('#monolito').modal('hide');
    });

    document.getElementById("saveButton").addEventListener("click", function() {
      document.getElementById("jsonForm").dispatchEvent(new Event("submit"));
    });

    function editarTablaMono(id, valor) {
      var formData = JSON.parse(valor); // Convertir el valor JSON a objeto FormData
      var columnas = ["Bloque", "Pagina", "Pagina_Datos", "Pagina_Colores", "Pagina_Iconos"];
      var valores = ["Mono", "Pag", valor, "valor_pagina_c", "valor_pagina_i"];

      var formDataToSend = {
        id: id,
        NoCol: 5,
        column: columnas,
        value: valores,
        funcion: "updateMVL"
      };

      console.log(formDataToSend);
      $.ajax({
        url: urlajaxUpdate,
        type: 'POST',
        data: formDataToSend,
        success: function(response) {
          $("#Mensaje").html('<div class="alert alert-success alert-dismissible alert-alt fade show"><button type="button" class="close h-100" data-dismiss="alert" aria-label="Close"><span><i class="mdi mdi-close"></i></span></button><strong>Listo </strong> Se actualizo correctamente.</div>');
          setTimeout(function() { $('#Mensaje').empty(); }, 2000);
          console.log(response);
        },
        error: function(error) {
          console.error('Error al enviar datos al servidor:', error);
        }
      });
    }
  </script>