<!-- Modal -->
<div class="modal fade" id="infoModal" tabindex="-1" role="dialog" aria-labelledby="textInfoModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document" style="max-width: 800px;">
        <div class="modal-content">
            <!-- Encabezado del Modal -->
            <div class="modal-header">
                <h5 class="modal-title" id="textInfoModalLabel">Editor de Información</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <!-- Cuerpo del Modal -->
            <div class="modal-body">
                <form id="dynamicForm">
                    <!-- Los campos del formulario serán agregados dinámicamente aquí -->
                </form>
            </div>
            <!-- Pie del Modal -->
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
                <button type="button" class="btn btn-primary" id="saveButtonJSONinfo">Guardar</button>
                <button type="button" class="btn btn-success" id="savePresetButton">Guardar Preestablecido</button>
            </div>
        </div>
    </div>
</div>

<script>
var urlajaxUpdate = "http://167.172.224.160/MiSi/librerias/ajaxAPP/ajaxSimple.php";

// Datos de ejemplo con los nuevos campos de GPS, delivery y aplicación
var data = {
    "name": "Juan Pérez",
    "title": "Desarrollador Web",
    "company": "Compañía XYZ",
    "phone": "+1 234 567 890",
    "email": "juan.perez@xyz.com",
    "whatsapp": "+1 234 567 890",
    "catalog": "https://example.com/catalog",
    "instagram": "https://instagram.com",
    "twitter": "https://twitter.com",
    "facebook": "https://facebook.com",
    "whatsappLink": "https://wa.me/1234567890",
    "phoneLink": "tel:+1234567890",
    "gps": "12.345678, -98.765432",
    "deliveryMethod": "Recoger en tienda",
    "appName": "Mi Aplicación",
    "direccion": "123 Calle Falsa, Ciudad, País",
    // Datos bancarios agrupados en una variable
    "banco": {
        "nombre": "Banco XYZ",
        "cuenta": "1234567890",
        "clabe": "012345678901234567"
    }
};

var datap = data;
data = <?php echo json_encode($datsosP[0]["Pagina_Datos"], JSON_PRETTY_PRINT); ?>;
data = JSON.parse(data);
console.log(data);	
var idInfoEditar = 0;

// Función para abrir el modal y generar el formulario
function textoDataForm(id) {
    idInfoEditar = id;
    $('#infoModal').modal('show');
}

// Generar formulario dinámico
function generateForm(data) {
    const form = document.getElementById("dynamicForm");
    form.innerHTML = ''; // Limpiar el contenido existente

    for (const key in data) {
        if (data.hasOwnProperty(key)) {
            const value = data[key];
            
            // Verifica si el valor es un objeto (para datos bancarios o cualquier otro objeto anidado)
            if (typeof value === 'object' && value !== null) {
                // Itera sobre los campos dentro del objeto anidado
                for (const subKey in value) {
                    if (value.hasOwnProperty(subKey)) {
                        createInputField(form, `${key}.${subKey}`, value[subKey]);
                    }
                }
            } else {
                createInputField(form, key, value);
            }
        }
    }
}

// Función para crear campos de entrada
function createInputField(form, name, value) {
    const div = document.createElement("div");
    div.classList.add("form-group");

    const label = document.createElement("label");
    label.textContent = name.split('.').map(part => part.charAt(0).toUpperCase() + part.slice(1)).join(' ') + ':';

    const input = document.createElement("input");
    input.type = "text";  // Tipo de input por defecto

    // Personalización de inputs para campos específicos
    if (name === "email") {
        input.type = "email";  // Cambiar tipo de input
    } else if (name === "phone" || name === "whatsapp") {
        input.type = "tel";  // Tipo teléfono
    } else if (name.includes("cuenta") || name.includes("clabe")) {
        input.type = "number";  // Tipo numérico para cuenta bancaria
    }

    input.name = name;
    input.value = value;
    input.classList.add("form-control");

    div.appendChild(label);
    div.appendChild(input);
    form.appendChild(div);
}

// Guardar cambios
document.getElementById("saveButtonJSONinfo").onclick = function() {
    try {
        const formData = new FormData(document.getElementById("dynamicForm"));
        const updatedData = {};

        formData.forEach((value, key) => {
            const keys = key.split('.');
            if (keys.length > 1) {
                if (!updatedData[keys[0]]) {
                    updatedData[keys[0]] = {};
                }
                updatedData[keys[0]][keys[1]] = value;
            } else {
                updatedData[key] = value;
            }
        });

        // Convertir los datos actualizados a JSON
        const updatedDataJSON = JSON.stringify(updatedData);
        console.log("Datos actualizados:", updatedDataJSON);

        // Llamar a la función de guardado
        editarTablaJSONinfo(idInfoEditar, updatedDataJSON);

        $('#infoModal').modal('hide'); // Ocultar el modal

    } catch (error) {
        console.error("Error al guardar los datos:", error);
    }
}

// Guardar el arreglo preestablecido de datos
document.getElementById("savePresetButton").onclick = function() {
    try {
        const presetDataJSON = JSON.stringify(datap);
        console.log("Datos preestablecidos guardados:", presetDataJSON);

        // Aquí puedes enviar los datos preestablecidos al servidor o guardarlos localmente
        editarTablaJSONinfo(idInfoEditar, presetDataJSON);

        alert("Datos preestablecidos guardados correctamente.");

    } catch (error) {
        console.error("Error al guardar los datos preestablecidos:", error);
    }
}

function editarTablaJSONinfo(id, valor) {
    try {
        var formData = JSON.parse(valor); // Convertir el valor JSON a objeto
        var columnas = ["Bloque", "Pagina", "Pagina_Datos", "Pagina_Iconos"];
        var valores = ["Tarjeta", "Tarjeta", valor, "valor_pagina_i"];

        var formDataToSend = {
            id: id,
            NoCol: 4,
            column: columnas,
            value: valores,
            funcion: "updateMVL"
        };

        console.log(formDataToSend);
        $.ajax({
            url: urlajaxUpdate, // Reemplaza con la URL del servidor
            type: 'POST',
            data: formDataToSend,
            success: function(response) {
                $("#Mensaje").html('<div class="alert alert-success alert-dismissible alert-alt fade show"><button type="button" class="close h-100" data-dismiss="alert" aria-label="Close"><span><i class="mdi mdi-close"></i></span></button><strong>Listo </strong> Se actualizó correctamente.</div>');
                setTimeout(function() { $('#Mensaje').empty(); }, 2000);
                console.log(response);
            },
            error: function(error) {
                console.error('Error al enviar datos al servidor:', error);
            }
        });

    } catch (error) {
        console.error("Error al procesar datos:", error);
    }
}

// Cuando se muestra el modal, generar el formulario
$('#infoModal').on('show.bs.modal', function (event) {
    generateForm(data);
});
</script>
