<!-- Modal -->
<div class="modal fade" id="textColorModal" tabindex="-1" role="dialog" aria-labelledby="textColorModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document" style="max-width: 800px;">
        <div class="modal-content">
            <!-- Encabezado del Modal -->
            <div class="modal-header">
                <h5 class="modal-title" id="textColorModalLabel">Editor de Colores</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <!-- Cuerpo del Modal -->
            <div class="modal-body">
                <div class="form-group">
                    <label for="colorScheme">Selecciona una configuración de colores:</label>
                    <select id="colorScheme" class="form-control">
                        <!-- Opciones se llenarán con JavaScript -->
                    </select>
                </div>
        
                <div class="form-group" style="margin-top: 20px;">
                    <label for="backgroundInput">Fondo:</label>
                    <input type="color" id="backgroundInput" class="form-control">
                </div>
                <div class="form-group">
                    <label for="textInput">Texto:</label>
                    <input type="color" id="textInput" class="form-control">
                </div>
                <div class="form-group">
                    <label for="titleInput">Título:</label>
                    <input type="color" id="titleInput" class="form-control">
                </div>
                <div class="form-group">
                    <label for="contactInput">Contacto:</label>
                    <input type="color" id="contactInput" class="form-control">
                </div>
                <div class="form-group">
                    <label for="socialMediaInput">Redes Sociales:</label>
                    <input type="color" id="socialMediaInput" class="form-control">
                </div>
                <div class="form-group">
                    <label for="socialMediaHoverInput">Redes Sociales Hover:</label>
                    <input type="color" id="socialMediaHoverInput" class="form-control">
                </div>
                <div class="form-group">
                    <label for="qrBackgroundInput">Fondo QR:</label>
                    <input type="color" id="qrBackgroundInput" class="form-control">
                </div>
                <div class="form-group">
                    <label for="qrForegroundInput">Primer Plano QR:</label>
                    <input type="color" id="qrForegroundInput" class="form-control">
                </div>
                <div class="form-group">
                    <label for="cardBackgroundInput">Fondo de Tarjeta:</label>
                    <input type="color" id="cardBackgroundInput" class="form-control">
                </div>
            </div>
            <!-- Pie del Modal -->
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
                <button type="button" class="btn btn-primary" id="saveButton">Guardar</button>
            </div>
        </div>
    </div>
</div>

<script>
    var urlajaxUpdate = "http://167.172.224.160/MiSi/librerias/ajaxAPP/ajaxSimple.php";
    var idtextoeditar;

// Configuraciones de colores
const colorConfigurations = {
    "Calmante": {
        "background": "#D0E8F2",
        "text": "#6C6C6C",
        "title": "#9E9E9E",
        "contact": "#6C6C6C",
        "socialMedia": "#6C6C6C",
        "socialMediaHover": "#003F6C",
        "qrBackground": "#D0E8F2",
        "qrForeground": "#6C6C6C",
        "cardBackground": "#FFFFFF"
    },
    "Energizante": {
        "background": "#F5A623",
        "text": "#4A4A4A",
        "title": "#9E9E9E",
        "contact": "#4A4A4A",
        "socialMedia": "#4A4A4A",
        "socialMediaHover": "#F56C6C",
        "qrBackground": "#F5A623",
        "qrForeground": "#4A4A4A",
        "cardBackground": "#FFFFFF"
    },
    "Elegante": {
        "background": "#333333",
        "text": "#F0F0F0",
        "title": "#B0B0B0",
        "contact": "#F0F0F0",
        "socialMedia": "#F0F0F0",
        "socialMediaHover": "#D0D0D0",
        "qrBackground": "#333333",
        "qrForeground": "#F0F0F0",
        "cardBackground": "#444444"
    },
    "Fresca": {
        "background": "#E0F7FA",
        "text": "#00695C",
        "title": "#004D40",
        "contact": "#004D40",
        "socialMedia": "#004D40",
        "socialMediaHover": "#00796B",
        "qrBackground": "#E0F7FA",
        "qrForeground": "#004D40",
        "cardBackground": "#FFFFFF"
    },
    "Creativa": {
        "background": "#F2C6B2",
        "text": "#6D4C41",
        "title": "#8D6E63",
        "contact": "#6D4C41",
        "socialMedia": "#6D4C41",
        "socialMediaHover": "#BF5B40",
        "qrBackground": "#F2C6B2",
        "qrForeground": "#6D4C41",
        "cardBackground": "#FFFFFF"
    },
    "Serena": {
        "background": "#B2DFDB",
        "text": "#004D40",
        "title": "#00796B",
        "contact": "#004D40",
        "socialMedia": "#004D40",
        "socialMediaHover": "#00796B",
        "qrBackground": "#B2DFDB",
        "qrForeground": "#004D40",
        "cardBackground": "#FFFFFF"
    },
    "Cálida": {
        "background": "#FFEB3B",
        "text": "#FF6F00",
        "title": "#FF9800",
        "contact": "#FF6F00",
        "socialMedia": "#FF6F00",
        "socialMediaHover": "#FFB300",
        "qrBackground": "#FFEB3B",
        "qrForeground": "#FF6F00",
        "cardBackground": "#FFFFFF"
    },
    "Natural": {
        "background": "#F0F4C3",
        "text": "#4A4A4A",
        "title": "#8BC34A",
        "contact": "#4A4A4A",
        "socialMedia": "#4A4A4A",
        "socialMediaHover": "#7CB342",
        "qrBackground": "#F0F4C3",
        "qrForeground": "#4A4A4A",
        "cardBackground": "#FFFFFF"
    },
    "Moderno": {
        "background": "#212121",
        "text": "#BDBDBD",
        "title": "#757575",
        "contact": "#BDBDBD",
        "socialMedia": "#BDBDBD",
        "socialMediaHover": "#757575",
        "qrBackground": "#212121",
        "qrForeground": "#BDBDBD",
        "cardBackground": "#333333"
    },
    "Romántico": {
        "background": "#F8BBD0",
        "text": "#C2185B",
        "title": "#D81B60",
        "contact": "#C2185B",
        "socialMedia": "#C2185B",
        "socialMediaHover": "#D81B60",
        "qrBackground": "#F8BBD0",
        "qrForeground": "#C2185B",
        "cardBackground": "#FFFFFF"
    },
    "Neutro": {
        "background": "#F5F5F5",
        "text": "#9E9E9E",
        "title": "#BDBDBD",
        "contact": "#9E9E9E",
        "socialMedia": "#9E9E9E",
        "socialMediaHover": "#757575",
        "qrBackground": "#F5F5F5",
        "qrForeground": "#9E9E9E",
        "cardBackground": "#FFFFFF"
    },
    "Vibrante": {
        "background": "#FF5722",
        "text": "#FFFFFF",
        "title": "#FFAB91",
        "contact": "#FFFFFF",
        "socialMedia": "#FFFFFF",
        "socialMediaHover": "#FF8A65",
        "qrBackground": "#FF5722",
        "qrForeground": "#FFFFFF",
        "cardBackground": "#FFFFFF"
    },
    "Suave": {
        "background": "#E0E0E0",
        "text": "#757575",
        "title": "#9E9E9E",
        "contact": "#757575",
        "socialMedia": "#757575",
        "socialMediaHover": "#9E9E9E",
        "qrBackground": "#E0E0E0",
        "qrForeground": "#757575",
        "cardBackground": "#FFFFFF"
    },
    "Luminosa": {
        "background": "#FFEB3B",
        "text": "#F57F17",
        "title": "#F9A825",
        "contact": "#F57F17",
        "socialMedia": "#F57F17",
        "socialMediaHover": "#F9A825",
        "qrBackground": "#FFEB3B",
        "qrForeground": "#F57F17",
        "cardBackground": "#FFFFFF"
    },
    "Profesional": {
        "background": "#ECEFF1",
        "text": "#37474F",
        "title": "#607D8B",
        "contact": "#37474F",
        "socialMedia": "#37474F",
        "socialMediaHover": "#607D8B",
        "qrBackground": "#ECEFF1",
        "qrForeground": "#37474F",
        "cardBackground": "#FFFFFF"
    }
};


    $(document).ready(function() {
        // Cargar las opciones en el select
        $('#textColorModal').on('shown.bs.modal', function () {
            var colorSchemeSelect = $('#colorScheme');
            colorSchemeSelect.empty();
            $.each(colorConfigurations, function(key, value) {
                colorSchemeSelect.append(new Option(key, key));
            });

            // Cargar la configuración de color por defecto
            var defaultConfig = Object.keys(colorConfigurations)[0];
            loadColors(colorConfigurations[defaultConfig]);
            setInputs(colorConfigurations[defaultConfig]);
        });

        // Cambiar la vista previa del color basado en el select
        $('#colorScheme').on('change', function() {
            var selectedKey = $(this).val();
            var selectedConfig = colorConfigurations[selectedKey];
            loadColors(selectedConfig);
            setInputs(selectedConfig);
        });

        // Actualizar la vista previa cuando se cambien los colores manualmente
        $('#backgroundInput').on('input', function() {
            $('#backgroundColor').css('background-color', $(this).val());
        });
        $('#textInput').on('input', function() {
            $('#textColor').css('background-color', $(this).val());
        });
        $('#titleInput').on('input', function() {
            $('#titleColor').css('background-color', $(this).val());
        });
        $('#contactInput').on('input', function() {
            $('#contactColor').css('background-color', $(this).val());
        });
        $('#socialMediaInput').on('input', function() {
            $('#socialMediaColor').css('background-color', $(this).val());
        });
        $('#socialMediaHoverInput').on('input', function() {
            $('#socialMediaHoverColor').css('background-color', $(this).val());
        });
        $('#qrBackgroundInput').on('input', function() {
            $('#qrBackgroundColor').css('background-color', $(this).val());
        });
        $('#qrForegroundInput').on('input', function() {
            $('#qrForegroundColor').css('background-color', $(this).val());
        });
        $('#cardBackgroundInput').on('input', function() {
            $('#cardBackgroundColor').css('background-color', $(this).val());
        });

        // Botón de guardar
        $('#saveButton').click(function() {
            var updatedColors = {
                "background": $('#backgroundInput').val(),
                "text": $('#textInput').val(),
                "title": $('#titleInput').val(),
                "contact": $('#contactInput').val(),
                "socialMedia": $('#socialMediaInput').val(),
                "socialMediaHover": $('#socialMediaHoverInput').val(),
                "qrBackground": $('#qrBackgroundInput').val(),
                "qrForeground": $('#qrForegroundInput').val(),
                "cardBackground": $('#cardBackgroundInput').val()
            };
            console.log('Colores actualizados:', updatedColors);
            editarTablaColor(idtextoeditar, JSON.stringify(updatedColors));
        });
    });

    function loadColors(colors) {
        $('#backgroundColor').css('background-color', colors.background);
        $('#textColor').css('background-color', colors.text);
        $('#titleColor').css('background-color', colors.title);
        $('#contactColor').css('background-color', colors.contact);
        $('#socialMediaColor').css('background-color', colors.socialMedia);
        $('#socialMediaHoverColor').css('background-color', colors.socialMediaHover);
        $('#qrBackgroundColor').css('background-color', colors.qrBackground);
        $('#qrForegroundColor').css('background-color', colors.qrForeground);
        $('#cardBackgroundColor').css('background-color', colors.cardBackground);
    }

    function setInputs(colors) {
        $('#backgroundInput').val(colors.background);
        $('#textInput').val(colors.text);
        $('#titleInput').val(colors.title);
        $('#contactInput').val(colors.contact);
        $('#socialMediaInput').val(colors.socialMedia);
        $('#socialMediaHoverInput').val(colors.socialMediaHover);
        $('#qrBackgroundInput').val(colors.qrBackground);
        $('#qrForegroundInput').val(colors.qrForeground);
        $('#cardBackgroundInput').val(colors.cardBackground);
    }

    // Función para abrir el modal
    function textoColor(id) {
        idtextoeditar = id;
        $('#textColorModal').modal('show');
    }

    function editarTablaColor(id, valor) {
        var formDataToSend = {
            id: id,
            NoCol: 4, 
            column: ["Bloque", "Pagina", "Pagina_Colores", "Pagina_Iconos"],
            value: ["Tarjeta", "Tarjeta", valor, "valor_pagina_i"],
            funcion: "updateMVL"
        };

        console.log(formDataToSend);
        $.ajax({
            url: urlajaxUpdate,
            type: 'POST',
            data: formDataToSend,
            success: function(response) {
                console.log(response);
                $('#textColorModal').modal('hide');
                location.reload();
            },
            error: function(xhr, status, error) {
                console.error('Error en la solicitud:', status, error);
            }
        });
    }
</script>
