<?php
// Ejemplo de arreglo con información para el formulario dinámico
$camposCliente = array(

    array( 'nombre', 'Nombre', 'text' ),
    array( 'telefono', 'Telefono', 'number' ),
    array( 'direccion', 'Direccion', 'text' ),
    array( 'email', 'Email', 'text' ),
    // Puedes agregar más campos según sea necesario
);
?>

<!-- Modal para agregar un nuevo cliente (dinámico) -->
<div class="modal" id="modalAgregarClienteDinamico" tabindex="-1" role="dialog" aria-labelledby="modalAgregarClienteDinamicoLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="modalAgregarClienteDinamicoLabel">Agregar Nuevo Cliente</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"> <span aria-hidden="true">&times;</span> </button>
      </div>
      <div class="modal-body"> 
        <!-- Formulario para agregar nuevo cliente (dinámico) -->
        <form id="formAgregarClienteDinamico">
          <?php foreach ($camposCliente as $campo): ?>
          <div class="form-group">
            <label for="<?php echo $campo[0]; ?>"><?php echo $campo[1]; ?>:</label>
            <input type="<?php echo $campo[2]; ?>" class="form-control" id="<?php echo $campo[0]; ?>" name="<?php echo $campo[1]; ?>" required>
          </div>
          <?php endforeach; ?>
          <button type="button" class="btn btn-success" onclick="agregarNuevoClienteDinamico()"> <i class="fa fa-plus"></i> <!-- Icono de agregar persona de Bootstrap --> 
          Agregar Cliente </button>
        </form>
      </div>
    </div>
  </div>
</div>


<script>
function agregarCliente() {
  $('#modalAgregarClienteDinamico').modal('show');
}	
// Función para agregar un nuevo cliente desde el formulario dinámico
function agregarNuevoClienteDinamico() {
    agregandoNuevoClienteDinamico();
}

function agregandoNuevoClienteDinamico() {
    // Recopila la información del formulario
    var formDataArray = $('#formAgregarClienteDinamico').serializeArray();
    var formDataObj = {};
    
    $.each(formDataArray, function(index, field) {
        formDataObj[field.name] = field.value;
    });
    
    console.log('Datos del formulario:');
    console.log(formDataObj);

    var formData = {
        id: 0,
        IDU: "<?php echo $IDLs; ?>",
        Nombre: formDataObj["Nombre"],
        Direccion: formDataObj["Direccion"],
        Telefono: formDataObj["Telefono"],
        Email: formDataObj["Email"],
        Pass: "00000",
        Datos: "{}",
        Token: "<?php echo $token; ?>",
        Vector: "1", //aqui decides que columnas y consulta usar
        funcion: "insertS"
    };

    $.ajax({
        url: urlajaxUpdate,
        type: 'POST',
        data: formData, 
        success: function(response) {
			$('#modalAgregarClienteDinamico').modal('hide');
            // Maneja la respuesta del servidor
            $("#MensajeMM").html('<div class="alert alert-success alert-dismissible alert-alt fade show"><button type="button" class="close h-100" data-dismiss="alert" aria-label="Close"><span><i class="mdi mdi-close"></i></span></button><strong>Listo </strong> Se actualizó correctamente.</div>');
            setTimeout(function () { $('#MensajeMM').empty(); }, 2000);
            console.log(response);
			 setTimeout(function() {
                location.reload();
            }, 1000);
			
        },
        error: function(error) {
            setTimeout(function () { $('#MensajeMM').empty(); }, 10);
            $("#MensajeMM").html('<div class="alert alert-danger alert-dismissible alert-alt fade show"><button type="button" class="close h-100" data-dismiss="alert" aria-label="Close"><span><i class="mdi mdi-close"></i></span></button><strong>Error </strong> Ocurrió un problema al actualizar.</div>');
            setTimeout(function () { $('#MensajeMM').empty(); }, 3000);
            console.error('Error al enviar datos al servidor:', error);
        }
    });
}
</script>
