<?php
// Datos JSON iniciales
$json_data = '[
    {"Categoria": "DisplayCelular"},
    {"Categoria": "DisplayLaptop"},
    {"Categoria": "prueba2"},
    {"Categoria": "pruebaa a"},
    {"Categoria": "2"},
    {"Categoria": "test"},
    {"Categoria": "qq"},
    {"Categoria": "cs"},
    {"Categoria": "Tintas"}
]';


$json_data = json_encode($cat, JSON_PRETTY_PRINT);

$data = json_decode($json_data, true);

// URL para AJAX
$urlajaxUpdate= "http://167.172.224.160/MiSi/librerias/ajaxAPP/ajaxSimple.php";
?>


<h2>Subir Imagen por Categoría</h2>

<!-- Botones por categoría -->
<div id="categoryButtons">
    <?php foreach ($data as $index => $category): ?>
        <button type="button" class="btn btn-outline-secondary btn-block btn-lg" data-toggle="modal" data-target="#IMGWEB" onclick="openModal('<?php echo $category['Categoria']; ?>', <?php echo $index; ?>)">
            <?php echo $category['Categoria']; ?>
        </button>
    <?php endforeach; ?>
</div>

<!-- Modal -->
<div class="modal fade" id="IMGWEB" tabindex="-1" role="dialog" aria-labelledby="monolitoModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <!-- Encabezado del Modal -->
            <div class="modal-header">
                <h4 class="modal-title" id="monolitoModalLabel">Modal de Imágenes</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>

            <!-- Cuerpo del Modal -->
            <div class="modal-body" style="max-height: 800px; overflow-y: auto;">
                <form id="imageUploadForm">
                    <!-- El formulario se construirá dinámicamente aquí -->
                </form>
            </div>

            <!-- Pie del Modal -->
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
                <button type="button" class="btn btn-primary" id="saveButton">Guardar</button>
            </div>
        </div>
    </div>
</div>

<div id="Mensaje"></div>

<script>
    var urlajaxUpdate = "<?php echo $urlajaxUpdate; ?>";
    var data = <?php echo json_encode($data); ?>;
    console.log('Datos iniciales:', data);

    function openModal(category, index) {
        console.log('Abriendo modal para categoría:', category, 'en índice:', index);

        var formContent = '';
        var uniqueId = 'category_' + index;

        formContent += '<div class="form-group row">';
        formContent += '<label class="col-sm-2 col-form-label">' + category + '</label>';
        formContent += '<div class="col-sm-8">';
        formContent += '<input type="file" class="form-control-file" id="' + uniqueId + '" accept="image/*">';
        formContent += '</div>';
        formContent += '<div class="col-sm-2">';
        formContent += '<button type="button" class="btn btn-primary btn-block" onclick="subir(' + index + ')">Subir</button>';
        formContent += '</div>';
        formContent += '</div>';

        $('#imageUploadForm').html(formContent);
    }

    function subir(index) {
        console.log('Intentando subir archivo para índice:', index);
        console.log('Datos actuales:', data);

        if (index >= 0 && index < data.length) {
            var archivo = $('#category_' + index).prop('files')[0];

            if (archivo) {
                console.log('Subiendo archivo para categoría:', data[index].Categoria);

                uploadImageMono(index, data[index].Categoria, archivo);
            } else {
                console.error('No se ha seleccionado ningún archivo.');
            }
        } else {
            console.error('Índice fuera de los límites del arreglo.');
            console.log('Longitud del arreglo:', data.length);
        }
    }

    function uploadImageMono(index, categoria, archivo) {
        if (archivo.size <= <?php echo $ArchivoC[2]; ?> && archivo.type === '<?php echo $ArchivoC[1]; ?>') {
            var formData = new FormData();
            formData.append('id', index);
            formData.append('nombreA', "<?php echo $ArchivoC[0]; ?>" + categoria + "-");
            formData.append('dirA', "<?php echo $ArchivoC[3]; ?>");
            formData.append('funcion', "SubirArchivo");
            formData.append('file', archivo);

            $.ajax({
                url: urlajaxUpdate,
                type: 'POST',
                data: formData,
                processData: false,
                contentType: false,
                success: function(response) {
                    var fileInfo = "Nombre: " + archivo.name + "<br>" +
                                   "Tipo: " + archivo.type + "<br>" +
                                   "Tamaño: " + archivo.size + " bytes";
                    var successMessage = '<div class="alert alert-success alert-dismissible alert-alt fade show">' +
                                         '<button type="button" class="close h-100" data-dismiss="alert" aria-label="Close">' +
                                         '<span><i class="mdi mdi-close"></i></span>' +
                                         '</button>' +
                                         '<strong>Listo </strong> Se actualizó correctamente. <br>' +
                                         fileInfo +
                                         '</div>';
                    $("#Mensaje").html(successMessage);
                    console.log(response);
                },
                error: function(error) {
                    console.error('Error al enviar datos al servidor:', error);
                }
            });
        } else {
            alert("Por favor, seleccione un archivo JPEG de menos de 2MB.");
        }
    }

    $(document).ready(function() {
        $('#saveButton').click(function() {
            console.log('Guardar formulario');
        });
    });
</script>
