

<div class="col-lg-4 grid-margin stretch-card">
    <div class="card">
        <div class="card-header">
            <h5 class="card-title"><?= $tarjeta['titulo'] ?></h5>
        </div>
        <div class="card-body">
            <p class="card-text"><?= $tarjeta['contenido'] ?></p>
        </div>
        <div class="card-body">
            <div class="row">
                <?php foreach ($tarjeta['elementos'] as $elemento): ?>
                    <div class="col-md-4 mb-3">
                        <button class="btn btn-primary btn-lg btn-block">
                            <i class="<?= $elemento['icono'] ?> fa-3x"></i><br>
                            <?= $elemento['nombre'] ?>
                        </button>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
        <div class="card-footer text-muted">
            <?= $tarjeta['pie'] ?>
        </div>
    </div>
</div>

<!-- Agrega esto dentro del <head> o antes de cerrar el </body> en head2.php -->
<script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>

<!-- Agrega este script después de tu código HTML actual -->
<script>
    $(document).ready(function () {
        // Manejar el clic en los botones
        $('.btn-block').on('click', function () {
            // Obtener el nombre y la consulta del elemento
            var nombre = $(this).text().trim();
            var consulta = '';
            var url = '';

            // Buscar el elemento correspondiente en la matriz
            $.each(<?= json_encode($tarjeta['elementos']) ?>, function (index, elemento) {
                if (elemento.nombre === nombre) {
                    consulta = elemento.consulta;
                    url = elemento.url; // Usar la URL del elemento
                    return false; // Salir del bucle forEach
                }
            });

            // Hacer la solicitud AJAX
            $.ajax({
                url: url, // Utilizar la URL del elemento
                type: 'GET', // O 'POST' según sea necesario
                data: { consulta: consulta }, // Enviar la consulta como parámetro GET o POST
                success: function (respuesta) {
                    // Manejar la respuesta del servidor (puede ser necesario parsearla dependiendo del formato)
                    console.log(respuesta);
                    // Aquí puedes hacer lo que necesites con la respuesta, por ejemplo, mostrarla en una alerta
                    alert('Respuesta del servidor: ' + respuesta);
                },
                error: function (error) {
                    // Manejar errores de la solicitud AJAX
                    console.error('Error en la solicitud AJAX:', error);
                }
            });
        });

    });
</script>

<?php include_once("foot.php"); ?>
<?php include_once("head2.php"); ?>
