<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Lista de Membresías</title>
  <style>
    .card-custom {
      position: relative;
      background: linear-gradient(135deg, #4caf50, #8bc34a);
      color: white;
      overflow: hidden;
      border-radius: 10px;
      margin-bottom: 1.5rem;
      transition: transform 0.2s, box-shadow 0.2s;
    }
    .card-custom:hover {
      transform: translateY(-5px);
      box-shadow: 0 5px 15px rgba(0, 0, 0, 0.3);
    }
    .card-custom.expired {
      background: linear-gradient(135deg, #d32f2f, #f44336); /* Rojo degradado */
    }
    .card-custom h5 {
      font-weight: bold;
      font-size: 1.2rem;
    }
    .card-custom p {
      margin-bottom: 0.5rem;
    }
    .member-list {
      padding-left: 1.5rem;
    }
    .card-status {
      position: absolute;
      bottom: 0;
      right: 0;
      padding: 0.5rem 1rem;
      background: rgba(0, 0, 0, 0.7);
      color: white;
      font-size: 0.9rem;
      text-transform: uppercase;
      border-top-left-radius: 10px;
    }
  </style>
  <script>
    let allCards = []; // Variable para almacenar todas las cards

    function filterMembresias() {
      const search = document.getElementById('search').value.toLowerCase();
      const container = document.querySelector('.row.gy-4');
      
      // Si es la primera vez que cargamos las cards, las guardamos en la variable allCards
      if (allCards.length === 0) {
        allCards = Array.from(container.children);
      }

      // Si el campo de búsqueda está vacío, mostramos todas las cards
      if (search === '') {
        allCards.forEach(card => card.style.display = 'block');
        return;
      }

      // Filtro de cards
      allCards.forEach(card => {
        const id = card.querySelector('.card-title').innerText.toLowerCase();
        const users = card.querySelector('.member-list').innerText.toLowerCase();
        const match = id.includes(search) || users.includes(search);

        card.style.display = match ? 'block' : 'none';
      });
    }
  </script>
</head>
<body>
  <div class="container my-5">
    <h1 class="text-center mb-4">Lista de Membresías</h1>
    <div class="row mb-4">
      <div class="col">
        <input type="text" id="search" class="form-control" placeholder="Buscar por ID o Nombre de Usuario" onkeyup="filterMembresias()">
      </div>
    </div>
    <div class="row gy-4">
      <?php foreach ($Membresias as $membresia) {
        // Comprobamos si la membresía está caducada
        $isExpired = strtotime($membresia['TimeStampFin']) < time();
        // Decodificamos el JSON contenido en Datos
        $datosJson = json_decode($membresia['Datos'], true);
      ?>
        <div class="col-md-6">
          <div class="card card-custom p-4 shadow <?php echo $isExpired ? 'expired' : ''; ?>">
            <div class="card-body">
              <h5 class="card-title">Membresía ID: <?php echo $membresia['ID_Membresia']; ?></h5>
              <p><strong>Estado:</strong> <?php echo $membresia['Estado']; ?></p>
              <p><strong>Fecha Inicio:</strong> <?php echo date('d/m/Y H:i', strtotime($membresia['TimeStampInicio'])); ?></p>
              <p><strong>Fecha Fin:</strong> <?php echo date('d/m/Y H:i', strtotime($membresia['TimeStampFin'])); ?></p>
              <h6>Usuarios de Membresía:</h6>
              <ul class="member-list">
                <?php foreach ($datosJson as $datos) { ?>
                  <li>
                    <?php echo implode(', ', $datos['users']); ?><br>
                  </li>
                <?php } ?>
              </ul>
            </div>
            <div class="card-status">
              <p>Token: <?php echo htmlspecialchars($membresia['Token']); ?></p>
            </div>
          </div>
        </div>
      <?php } ?>
    </div>
  </div>
</body>
</html>
