
  <style>
    table {
      width: 100%;
      border-collapse: collapse;
    }
    th, td {
      text-align: center;
      vertical-align: middle;
    }
    .editable {
      outline: none;
      border: none;
      background: transparent;
      width: 100%;
      text-align: center;
    }
    .action-btn {
      cursor: pointer;
      font-size: 1.2rem;
    }
    .action-btn.add {
      color: green;
    }
    .action-btn.delete {
      color: red;
    }
  </style>

  <div class="container mt-5">
    <h1 class="text-center mb-4">Formulario Dinámico</h1>
    <div class="d-flex justify-content-end mb-2">
      <button class="btn btn-success" onclick="addColumn()">+ Agregar Columna</button>
    </div>
    <table id="dynamicTable" class="table table-bordered">
      <thead>
        <tr id="tableHeader">
          <!-- Encabezados dinámicos -->
          <th>Acciones</th>
        </tr>
      </thead>
      <tbody id="tableBody">
        <!-- Filas dinámicas -->
      </tbody>
    </table>
    <div class="d-flex justify-content-between mt-3">
      <button class="btn btn-primary" onclick="addRow()">Agregar Fila</button>
      <button id="saveJSON" class="btn btn-success">Guardar JSON</button>
    </div>
  </div>

  <!-- JavaScript -->
  <script>
    const tableHeader = document.getElementById("tableHeader");
    const tableBody = document.getElementById("tableBody");

    // JSON inicial
    const initialData = <?php echo $_SESSION[ "IDU-ConfiguracionxNombre" ][0]["DatosMembresia"];?>

    // Función para inicializar la tabla con un JSON
    function initializeTable(data) {
      // Obtener claves del primer objeto como encabezados
      const headers = Object.keys(data[0]);
      headers.forEach((header) => {
        const th = document.createElement("th");
        th.innerHTML = `<input type="text" class="editable" value="${header}">`;
        tableHeader.insertBefore(th, tableHeader.lastElementChild); // Antes de la columna "Acciones"
      });

      // Llenar filas con datos iniciales
      data.forEach((rowData) => {
        addRow(rowData);
      });
    }

    // Función para agregar una nueva columna
    function addColumn() {
      const columnCount = tableHeader.children.length - 1; // Excluyendo columna "Acciones"
      const newHeader = document.createElement("th");
      newHeader.innerHTML = `<input type="text" class="editable" value="Campo ${columnCount + 1}">`;
      tableHeader.insertBefore(newHeader, tableHeader.lastElementChild);

      // Agregar un campo vacío en cada fila existente
      Array.from(tableBody.children).forEach((row) => {
        const newCell = document.createElement("td");
        newCell.innerHTML = `<input type="text" class="form-control" placeholder="Valor">`;
        row.insertBefore(newCell, row.lastElementChild);
      });
    }

    // Función para agregar una nueva fila
    function addRow(rowData = {}) {
      const row = document.createElement("tr");
      const headers = Array.from(tableHeader.children).slice(0, -1); // Excluyendo columna "Acciones"

      headers.forEach((header, index) => {
        const key = header.querySelector("input").value || `Campo ${index + 1}`;
        const cell = document.createElement("td");
        cell.innerHTML = `<input type="text" class="form-control" value="${rowData[key] || ""}" placeholder="Valor">`;
        row.appendChild(cell);
      });

      // Agregar botón de eliminar
      const actionCell = document.createElement("td");
      actionCell.innerHTML = `<span class="action-btn delete" onclick="deleteRow(this)">-</span>`;
      row.appendChild(actionCell);

      tableBody.appendChild(row);
    }

    // Función para eliminar una fila
    function deleteRow(button) {
      const row = button.parentElement.parentElement;
      tableBody.removeChild(row);
    }

    // Función para guardar datos en formato JSON
    document.getElementById("saveJSON").addEventListener("click", () => {
      const headers = Array.from(tableHeader.children).slice(0, -1).map((th) =>
        th.querySelector("input").value.trim()
      );

      const data = Array.from(tableBody.children).map((row) => {
        const rowData = {};
        Array.from(row.children).slice(0, -1).forEach((cell, index) => {
          const input = cell.querySelector("input");
          if (input) {
            rowData[headers[index]] = input.value;
          }
        });
        return rowData;
      });

      console.log(data);
      //alert(JSON.stringify(data, null, 2)); // Muestra el JSON generado
	  editarTabla("<?php echo $IDUsuario;?>", "<?php echo $ColumnaEdi;?>", JSON.stringify(data, null, 2));
    });
	  
	
<?php 
//UPDATE `MicroSi_Datos`.`1-Catalogo` SET `Codigo` = '11' WHERE (`IDCa` = '1');
 $urlajaxUpdate= "http://167.172.224.160/MiSi/librerias/ajaxAPP/ajaxSimple.php";

?>

function editarTabla(id, columna, valor) {
  // alert("Función editar tabla: " + id + ", " + columna + ", " + valor);

    // Datos a enviar al servidor
    var formData = {
        id: id, 
        column: columna,
        value: valor, 
		funcion: "update"
    };

    // AJAX para enviar los datos al servidor 
    $.ajax({
        url: '<?php echo $urlajaxUpdate; ?>', // Reemplaza con la ruta correcta a tu script del servidor
        type: 'POST',
        data: formData,
        success: function(response) {
            // Maneja la respuesta del servidor
			$("#Mensaje").html(' <div class="alert alert-success alert-dismissible alert-alt fade show"><button type="button" class="close h-100" data-dismiss="alert" aria-label="Close"><span><i class="mdi mdi-close"></i></span></button><strong>Listo </strong> Se actualizo correctamente.</div>');
			setTimeout(function() {$('#Mensaje').empty();}, 2000);
			
            console.log(response);
        },
        error: function(error) {
            console.error('Error al enviar datos al servidor:', error);
        }
    });
}  

    // Inicializar la tabla con datos iniciales
    initializeTable(initialData);
  </script>
