<?php
session_start();
$_SESSION[ "tconf" ] = $tconf;

?>
<?php include_once("foot.php"); ?>
<?php include_once("head2.php"); ?>
<style>

  body {
    margin: 40px 10px;
    padding: 0;
    font-family: Arial, Helvetica Neue, Helvetica, sans-serif;
    font-size: 14px;
  }

  #calendar {
    max-width: 1100px;
    margin: 0 auto;
  }

</style>

<div class="col-lg-9 grid-margin stretch-card">
  <div class="card">
    <div class="card-body">
      <h5 class="card-title"><?php echo $tconf;?></h5>
      <p class="card-description">Calendario</p>
       <div id='calendar'></div>
    </div>
  </div>
</div>

<?php 	echo  $fechas[0][0];?>


<script>
FullCalendar.globalLocales.push(function () {
  'use strict';

  var es = {
    code: 'es',
    week: {
      dow: 1, // Monday is the first day of the week.
      doy: 4, // The week that contains Jan 4th is the first week of the year.
    },
    buttonText: {
      prev: 'Ant',
      next: 'Sig',
      today: 'Hoy',
      month: 'Mes',
      week: 'Semana',
      day: 'Día',
      list: 'Agenda',
    },
    buttonHints: {
      prev: '$0 antes',
      next: '$0 siguiente',
      today(buttonText) {
        return (buttonText === 'Día') ? 'Hoy' :
          ((buttonText === 'Semana') ? 'Esta' : 'Este') + ' ' + buttonText.toLocaleLowerCase()
      },
    },
    viewHint(buttonText) {
      return 'Vista ' + (buttonText === 'Semana' ? 'de la' : 'del') + ' ' + buttonText.toLocaleLowerCase()
    },
    weekText: 'Sm',
    weekTextLong: 'Semana',
    allDayText: 'Todo el día',
    moreLinkText: 'más',
    moreLinkHint(eventCnt) {
      return `Mostrar ${eventCnt} eventos más`
    },
    noEventsText: 'No hay eventos para mostrar',
    navLinkHint: 'Ir al $0',
    closeHint: 'Cerrar',
    timeHint: 'La hora',
    eventHint: 'Evento',
  };

  return es;

}());


  document.addEventListener('DOMContentLoaded', function() {

    var calendarEl = document.getElementById('calendar');

    var calendar = new FullCalendar.Calendar(calendarEl, {
		 initialView: 'timeGridWeek',
      headerToolbar: {
        left: 'prevYear,prev,next,nextYear today',
        center: 'title',
        right: 'dayGridMonth,dayGridWeek,timeGridWeek,dayGridDay',
	 
      },
	  	locale: 'es',
    
      navLinks: true, // can click day/week names to navigate views
      editable: true,
      dayMaxEvents: true, // allow "more" link when too many events
      events: [
           {
          title: 'Happy Hour',
          start: '2022-09-08T17:30:00',
		  slotMinutes: 15
        },
       
		{
		  
          title: 'Dinner',
          start: '2022-09-08T20:00:00',
			end: '2022-09-08T20:30:00',
		 // slotMinutes: 160
		 dow: [1,3,4]
        },
        {
        title: 'BCH237',
		daysOfWeek: [ '3' ],
			
      start: '2020-09-12T10:30:00',
      end: '2020-09-12T11:30:00',
      color: 'yellow',   // an option!
      textColor: 'black'
        },
        {
          title: 'Click for Google',
          url: 'http://google.com/',
          start: '2022-09-28'
        }
      ]
    });

    calendar.render();
  });

</script>
