<?php
$urlajaxUpdate = "http://167.172.224.160/MiSi/librerias/ajaxAPP/ajaxSimple.php";
?>

  <style>
    .timeline { position: relative; margin-left: 20px; border-left: 3px solid #0d6efd; padding-left: 20px; }
    .timeline-item { position: relative; margin-bottom: 20px; }
    .timeline-item::before {
      content: ""; position: absolute; left: -12px; top: 0; width: 15px; height: 15px;
      background-color: #0d6efd; border-radius: 50%; border: 3px solid white;
    }
    .tag { font-size: 0.8rem; padding: 2px 6px; border-radius: 4px; margin-left: 10px; }
    .tag-revision { background-color: #ffc107; color: black; }
    .tag-entregado { background-color: #17a2b8; color: white; }
    .tag-listo { background-color: #28a745; color: white; }
	  /* Estilo agradable para los botones de minuta */

	  
	  /* Estilo agradable para los botones de minuta */
.minuta-actions { gap: 0.5rem; align-items: center; flex-wrap: wrap; }

	  
	  .minuta-actions .action-btn {
  display: flex;
  align-items: center;
  gap: 0.5rem;
  min-width: 120px;
  white-space: nowrap;
  font-weight: bold;
}

/* En pantallas pequeñas: botones al 100% de ancho */
@media (max-width: 576px) {
  .minuta-actions {
    width: 100%;
  }
  .minuta-actions .action-btn {
    flex: 1 1 100%;
    min-width: 0;
    font-size: 1rem;
    padding: 0.6rem;
    justify-content: flex-start; /* ícono + texto alineados a la izquierda */
  }
}

}



  </style>


<div class="container py-4">
  <h2 class="mb-4 text-primary">Seguimiento de Servicios</h2>

  <!-- Buscar Orden -->
  <div class="card mb-4">
    <div class="card-body d-flex flex-column flex-md-row gap-2 align-items-md-end">
      <div class="flex-grow-1">
        <label for="buscarIdInput" class="form-label">Buscar ID de Orden</label>
        <input type="text" class="form-control" id="buscarIdInput" placeholder="Ej: 1" />
      </div>
      <button class="btn btn-primary" onclick="buscarOrden()">
        <i class="bi bi-search"></i> Buscar
      </button>
    </div>
  </div>

  <div class="row">
    <!-- Formulario -->
    <div class="col-md-5 mb-4">
      <div class="card mb-3">
        <div class="card-body">
          <div class="mb-3 text-muted">
            <strong>Orden actual:</strong> <span id="ordenActual">Ninguna</span>
          </div>
          <div class="mb-3">
            <label for="minutaInput" class="form-label">Minuta</label>
            <textarea class="form-control" id="minutaInput" rows="4" disabled></textarea>
          </div>
       
			
			<div class="d-flex gap-2 flex-wrap mb-3 minuta-actions">
  <button class="btn btn-warning action-btn" onclick="agregarMinuta('Revisión')" id="btnRevision">
    <i class="fas fa-search"></i> <span>Revisión</span>
  </button>
  <button class="btn btn-info text-white action-btn" onclick="agregarMinuta('Entregado')" id="btnEntregado">
    <i class="fas fa-truck"></i> <span>Entregado</span>
  </button>
  <button class="btn btn-success action-btn" onclick="agregarMinuta('Listo')" id="btnListo">
    <i class="fas fa-check"></i> <span>Listo</span>
  </button>
  <button class="btn btn-primary action-btn" onclick="agregarMinuta('Garantía')" id="btnGarantia">
    <i class="fas fa-shield-alt"></i> <span>Garantía</span>
  </button>
</div>

			
          <button class="btn btn-secondary w-100" id="btnMostrarInfo" disabled data-bs-toggle="modal" data-bs-target="#infoModal">
            <i class="bi bi-info-circle"></i> Información de la Orden
          </button>
        </div>
      </div>
    </div>

    <!-- Línea de tiempo -->
    <div class="col-md-7">
      <h5 class="text-secondary">Línea de tiempo</h5>
      <div id="timeline" class="timeline"></div>
    </div>
  </div>
</div>

<!-- Modal info -->
<div class="modal fade" id="infoModal" tabindex="-1" aria-labelledby="infoModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-scrollable">
    <div class="modal-content">
      <div class="modal-header bg-secondary text-white">
        <h5 class="modal-title" id="infoModalLabel">Información de la Orden</h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Cerrar"></button>
      </div>
      <div class="modal-body" id="modalInfoContent">
        <p class="text-muted">No hay orden seleccionada.</p>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
      </div>
    </div>
  </div>
</div>

<!-- Scripts -->
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

<script>
  let ordenActual = null;

  function buscarOrden() {
  const id = document.getElementById('buscarIdInput').value.trim();
  if (!id) {
    alert("Ingresa un ID válido.");
    return;
  }

  $.ajax({
    url: '<?php echo $urlajaxUpdate; ?>',
    method: 'POST',
    data: {
      id: id,
      nco: 1,
      funcion: 'selectM'
    },
    success: function (respuesta) {
      try {
        const datos = JSON.parse(respuesta);
        const orden = datos["0"];

        if (!orden) {
          alert("No se encontraron datos para la orden.");
          return;
        }

        // ✅ Guarda en variable global
        ordenActual = orden;

        // ✅ Muestra ID actual
        document.getElementById("ordenActual").textContent = `ID ${ordenActual.IDS}`;

        // ✅ Habilita funcionalidades
        document.getElementById("minutaInput").disabled = false;
        document.getElementById("btnRevision").disabled = false;
        document.getElementById("btnEntregado").disabled = false;
        document.getElementById("btnListo").disabled = false;
        document.getElementById("btnMostrarInfo").disabled = false;
		  document.getElementById("btnGarantia").disabled = false;


        // ✅ Limpia/minuta inicial si existe
        document.getElementById("minutaInput").value = "";
        mostrarMinutas();
        actualizarModalInfo();

      } catch (error) {
        console.error("Error al parsear JSON:", error);
        alert("Error al procesar la información del servidor.");
        limpiarInterfaz();
      }
    },
    error: function () {
      alert("Error al conectar con el servidor.");
      limpiarInterfaz();
    }
  });
}

  function limpiarInterfaz() {
    ordenActual = null;
    document.getElementById('ordenActual').textContent = "Ninguna";
    document.getElementById("minutaInput").disabled = true;
    document.getElementById("btnRevision").disabled = true;
    document.getElementById("btnEntregado").disabled = true;
    document.getElementById("btnListo").disabled = true;
    document.getElementById("btnMostrarInfo").disabled = true;
	  document.getElementById("btnGarantia").disabled = true;

    document.getElementById("timeline").innerHTML = "";
    actualizarModalInfo();
  }

  function mostrarMinutas() {
    const timeline = document.getElementById('timeline');
    timeline.innerHTML = "";

    const datosSeg = JSON.parse(ordenActual.DatosSeg || '[]');
    datosSeg.slice().reverse().forEach(minuta => {
      const item = document.createElement("div");
      item.className = "timeline-item";
      item.innerHTML = `
        <div class="card">
          <div class="card-body">
            <small class="text-muted">${minuta.fecha}</small><br>
            <strong>Minuta:</strong> ${minuta.texto}
            ${getEstadoTag(minuta.estado)}
          </div>
        </div>
      `;
      timeline.appendChild(item);
    });
  }

function agregarMinuta(estado) {
  const texto = document.getElementById('minutaInput').value.trim();
  if (!ordenActual || !texto) {
    alert("Completa el texto de la minuta.");
    return;
  }

  const nueva = {
    fecha: new Date().toLocaleString(),
    texto,
    estado
  };

  const seguimientos = JSON.parse(ordenActual.DatosSeg || '[]');
  seguimientos.push(nueva);
  ordenActual.DatosSeg = JSON.stringify(seguimientos);

  // 🆕 Mostrar IDS y JSON en el alert
  alert(
    "ID de orden: " + ordenActual.IDS + "\n\n" +
    "JSON actualizado:\n" + JSON.stringify(seguimientos, null, 2)
  );

  editarTabla(ordenActual.IDS, JSON.stringify(seguimientos, null, 2));
  // Limpia textarea y actualiza línea de tiempo
  document.getElementById('minutaInput').value = "";
  mostrarMinutas();
}

	
  function editarTabla(id, valor) {
  // alert("Función editar tabla: " + id + ", " + columna + ", " + valor);

    // Datos a enviar al servidor
    var formData = {
        id: id,
        column: "DatosSeg",
        value: valor, 
		funcion: "update"
    };

    // AJAX para enviar los datos al servidor 
    $.ajax({
        url: '<?php echo $urlajaxUpdate; ?>', // Reemplaza con la ruta correcta a tu script del servidor
        type: 'POST',
        data: formData,
        success: function(response) {
            // Maneja la respuesta del servidor
			$("#Mensaje").html(' <div class="alert alert-success alert-dismissible alert-alt fade show"><button type="button" class="close h-100" data-dismiss="alert" aria-label="Close"><span><i class="mdi mdi-close"></i></span></button><strong>Listo </strong> Se actualizo correctamente.</div>');
			setTimeout(function() {$('#Mensaje').empty();}, 2000);
			
            console.log(response);
        },
        error: function(error) {
            console.error('Error al enviar datos al servidor:', error);
        }
    });
}
 
	
function getEstadoTag(estado) {
  const estilos = {
    "Revisión": { clase: "warning", texto: "Revisión" },
    "Listo": { clase: "success", texto: "Listo" },
    "Entregado": { clase: "info", texto: "Entregado" },
    "Garantía": { clase: "primary", texto: "Garantía" }
  };

  if (!estilos[estado]) return "";

  return `<span class="badge bg-${estilos[estado].clase} px-2 py-1">
            ${estilos[estado].texto}
          </span>`;
}

  function actualizarModalInfo() {
    const modalBody = document.getElementById('modalInfoContent');
    if (!ordenActual) {
      modalBody.innerHTML = `<p class="text-muted">No hay orden seleccionada.</p>`;
      return;
    }
    modalBody.innerHTML = `
     <ul class="list-group">
  <li class="list-group-item"><strong>ID:</strong> ${ordenActual.IDS}</li>
  <li class="list-group-item"><strong>IDC:</strong> ${ordenActual.IDC}</li>
  <li class="list-group-item"><strong>Categoría:</strong> ${ordenActual.Categoria}</li>
  <li class="list-group-item"><strong>Marca:</strong> ${ordenActual.Marca}</li>
  <li class="list-group-item"><strong>Modelo:</strong> ${ordenActual.Modelo}</li>
  <li class="list-group-item"><strong>No. Serie:</strong> ${ordenActual.NoSerie}</li>
  <li class="list-group-item"><strong>Diagnóstico:</strong> ${ordenActual.Diagnostico}</li>
  <li class="list-group-item"><strong>Cotización:</strong> ${ordenActual.Cotizacion}</li>
  <li class="list-group-item"><strong>Anticipo:</strong> ${ordenActual.Anticipo}</li>
  <li class="list-group-item"><strong>Fecha:</strong> ${ordenActual.Fecha}</li>
  <li class="list-group-item"><strong>Datos adicionales:</strong> ${ordenActual.DatosSeg}</li>
</ul>

    `;
  }
	
	// Inicializar tooltips y enlazar botones (usa data-estado)
document.addEventListener('DOMContentLoaded', function () {
  // Inicializa tooltips de Bootstrap
  const tipTriggerList = Array.from(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
  tipTriggerList.forEach(el => new bootstrap.Tooltip(el));

  // Evita usar onclick inline duplicado: enlazamos aquí
  document.querySelectorAll('.minuta-actions .action-btn').forEach(btn => {
    btn.addEventListener('click', function () {
      const estado = this.getAttribute('data-estado');
      // efecto visual breve
      this.classList.add('btn-flash');
      setTimeout(() => this.classList.remove('btn-flash'), 220);

      // Llama a tu función existente para agregar minuta
      // (agregarMinuta debe seguir en tu código)
      agregarMinuta(estado);
    });
  });
});
g
</script>


