<?php
// Datos del paciente
$paciente = [
    "nombre" => $originalArray[0]['Nombre'],
    "telefono" => $originalArray[0]['Telefono'] ?: "Sin teléfono", // Valor por defecto si está vacío
    "fecha" => $originalArray[0]['Desde'],
    "peso" => 70, // Valor fijo o generado
    "edad" => 30  // Valor fijo o calculado
];

// Datos del doctor
$doctor = $DoctorDatos;
?>

<style>
    .prescription-container {
        max-width: 800px;
        margin: 20px auto;
        padding: 20px;
        border: 1px solid #000;
        border-radius: 10px;
        box-shadow: 0px 4px 6px rgba(0, 0, 0, 0.1);
    }
    .prescription-header, .prescription-footer {
        text-align: center;
        margin-bottom: 20px;
    }
    .prescription-section {
        margin-bottom: 15px;
    }
    .label {
        font-weight: bold;
        color: #555;
    }
    .doctor-info {
        color: #333;
        font-size: 0.9em;
        margin-bottom: 10px;
    }
    .medicamento-card {
        border: 1px solid #007bff;
        border-radius: 5px;
        padding: 15px;
        margin-bottom: 10px;
        background-color: #f8f9fa;
    }
    .medicamento-card h5 {
        margin: 0;
        font-size: 1.25rem;
    }
    .medicamento-card .active-substance {
        font-size: 0.9rem;
        color: #6c757d;
    }
    .medicamento-card .card-footer {
        display: flex;
        justify-content: flex-end;
    }
    .prescription-footer-details {
        text-align: right;
    }
    .footer-divider {
        margin: 20px 0;
        border-top: 1px solid #ccc;
    }
</style>

<div class="container prescription-container">

	
    <div class="prescription-header">
        <p>
            <?php
            echo htmlspecialchars($doctor['nombre']) . " | " .
                 htmlspecialchars($doctor['especialidad']) . " | " .
                 "Tel: " . htmlspecialchars($doctor['telefono']) . " | " .
                 "Cédula: " . htmlspecialchars($doctor['cedula']);
            ?>
        </p>
    </div>


    <div class="doctor-info">
        <p><i class="fa fa-user"></i> <span class="label">Nombre del Paciente:</span> <span id="infoNombre"></span></p>
        <p><i class="fa fa-phone"></i> <span class="label">Teléfono:</span> <span id="infoTelefono"></span></p>
        <p><i class="fa fa-calendar"></i> <span class="label">Fecha de Receta:</span> <span id="infoFecha"></span></p>
    </div>

    <form id="prescriptionForm">
        <div class="form-group row">
            <div class="col-md-6">
                <label class="label"><i class="fa fa-balance-scale"></i> Peso del Paciente (kg):</label>
                <input type="number" class="form-control" id="pesoPacienteInput" placeholder="Peso en kg" required>
            </div>
            <div class="col-md-6">
                <label class="label"><i class="fa fa-birthday-cake"></i> Edad del Paciente (años):</label>
                <input type="number" class="form-control" id="edadPacienteInput" placeholder="Edad en años" required>
            </div>
        </div>

        <!-- Lista de medicamentos -->
        <div class="prescription-section">
            <label class="label"><i class="fa fa-medkit"></i> Medicamentos:</label>
            <div id="medicamentoList" class="mt-3"></div>
            <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#medicamentoModal">
                <i class="fa fa-plus"></i> Agregar Medicamento
            </button>
        </div>

        <div class="prescription-section">
            <label class="label"><i class="fa fa-stethoscope"></i> Diagnóstico:</label>
            <input type="text" class="form-control" id="diagnostico" placeholder="Diagnóstico" required>
        </div>
        <div class="prescription-section">
            <label class="label"><i class="fa fa-file-text-o"></i> Instrucciones:</label>
            <textarea class="form-control" id="instrucciones" rows="3" placeholder="Instrucciones para el paciente" required></textarea>
        </div>
        <button type="button" class="btn btn-primary btn-block mt-3" id="verImprimir" onclick="verImprimir()">Ver e Imprimir</button>
        <button type="button" class="btn btn-success btn-block mt-3" onclick="generarJSON()"><i class="fa fa-save"></i> Guardar Receta</button>
    </form>

    <div class="footer-divider"></div>
</div>

<!-- Modal para agregar medicamentos -->
<div class="modal fade" id="medicamentoModal" tabindex="-1" role="dialog" aria-labelledby="medicamentoModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="medicamentoModalLabel">Agregar Medicamento</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="form-group">
                    <label for="medicamentoNombre">Medicamento:</label>
                    <input type="text" class="form-control" id="medicamentoNombre" placeholder="Nombre del medicamento" required>
                </div>
                <div class="form-group">
                    <label for="sustanciaActiva">Sustancia Activa:</label>
                    <input type="text" class="form-control" id="sustanciaActiva" placeholder="Sustancia activa" required>
                </div>
                <div class="form-group">
                    <label for="cantidad">Cantidad:</label>
                    <input type="text" class="form-control" id="cantidad" placeholder="Cantidad" required>
                </div>
                <div class="form-group">
                    <label for="duracion">Duración:</label>
                    <input type="text" class="form-control" id="duracion" placeholder="Duración" required>
                </div>
            </div>
            <div class="modal-footer"> 
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
                <button type="button" class="btn btn-primary" onclick="agregarMedicamento()">Agregar Medicamento</button>
            </div>
        </div>
    </div>
</div>
<script>
    document.getElementById("verImprimir").addEventListener("click", verImprimir);

    // Datos del paciente
    const pacienteData = <?php echo json_encode($paciente); ?>;
    // Datos del doctor
    const doctorData = <?php echo json_encode($doctor); ?>;

    function verImprimir() {
        const recetaData = {
            paciente: {
                nombre: document.getElementById("infoNombre").innerText,
                telefono: document.getElementById("infoTelefono").innerText,
                fecha: document.getElementById("infoFecha").innerText,
                peso: document.getElementById("pesoPacienteInput").value,
                edad: document.getElementById("edadPacienteInput").value
            },
            doctor: {
                nombre: doctorData.nombre,
                especialidad: doctorData.especialidad,
                dgP: doctorData.dgP,
                cedula: doctorData.cedula
            },
            medicamentos: [],
            diagnostico: document.getElementById("diagnostico").value,
            instrucciones: document.getElementById("instrucciones").value
        };

        // Obtener medicamentos
        const medicamentoCards = document.querySelectorAll('.medicamento-card');
        medicamentoCards.forEach(card => {
            const nombre = card.querySelector('h5').innerText;
            const sustancia = card.querySelector('.active-substance').innerText.split(': ')[1];
            const cantidad = card.querySelector('p:nth-child(2)').innerText.split(': ')[1];
            const duracion = card.querySelector('p:nth-child(3)').innerText.split(': ')[1];

            recetaData.medicamentos.push({ nombre, sustancia, cantidad, duracion });
        });

        fetch('../librerias/Impresora/ImprimirRaceta.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json'
            },
            body: JSON.stringify(recetaData)
        })
        .then(response => {
            if (response.ok) {
                return response.blob(); // Recibe el PDF como blob
            }
            throw new Error('Error en la generación del PDF');
        })
        .then(blob => {
            const pdfUrl = URL.createObjectURL(blob); // Crea un URL para el blob
            const pdfWindow = window.open(pdfUrl, '_blank', 'width=450,height=600'); // Dimensiones para media carta
            pdfWindow.focus();
        })
        .catch(error => {
            console.error('Error al imprimir la receta:', error);
        });
    }

    function agregarMedicamento() {
    const nombre = document.getElementById("medicamentoNombre").value;
    const sustancia = document.getElementById("sustanciaActiva").value;
    const cantidad = document.getElementById("cantidad").value;
    const duracion = document.getElementById("duracion").value;

    if (!nombre || !sustancia || !cantidad || !duracion) {
        alert("Por favor, completa todos los campos del medicamento.");
        return;
    }

    const medicamentoList = document.getElementById("medicamentoList");
    const medicamentoCard = document.createElement("div");
    medicamentoCard.classList.add("medicamento-card");

    medicamentoCard.innerHTML = `
        <h5>${nombre}</h5>
        <p class="active-substance">Sustancia Activa: ${sustancia}</p>
        <p>Cantidad: ${cantidad}</p>
        <p>Duración: ${duracion}</p>
        <div class="card-footer">
            <button class="btn btn-danger" onclick="this.closest('.medicamento-card').remove()">Eliminar</button>
        </div>
    `;

    medicamentoList.appendChild(medicamentoCard);

    // Limpia únicamente los campos del modal de medicamentos
    document.getElementById("medicamentoNombre").value = "";
    document.getElementById("sustanciaActiva").value = "";
    document.getElementById("cantidad").value = "";
    document.getElementById("duracion").value = "";

    // Cierra el modal
    $('#medicamentoModal').modal('hide');
}

	<?php 
    $urlajaxUpdate= "http://167.172.224.160/MiSi/librerias/ajaxAPP/ajaxSimple.php";
?>

    function generarJSON() {
        const recetaData = {
            paciente: {
                nombre: document.getElementById("infoNombre").innerText,
                telefono: document.getElementById("infoTelefono").innerText,
                fecha: document.getElementById("infoFecha").innerText,
                peso: document.getElementById("pesoPacienteInput").value,
                edad: document.getElementById("edadPacienteInput").value
            },
            doctor: {
                nombre: doctorData.nombre,
                especialidad: doctorData.especialidad,
                dgP: doctorData.dgP,
                cedula: doctorData.cedula
            },
            medicamentos: [],
            diagnostico: document.getElementById("diagnostico").value,
            instrucciones: document.getElementById("instrucciones").value
        };

        // Obtener medicamentos
        const medicamentoCards = document.querySelectorAll('.medicamento-card');
        medicamentoCards.forEach(card => {
            const nombre = card.querySelector('h5').innerText;
            const sustancia = card.querySelector('.active-substance').innerText.split(': ')[1];
            const cantidad = card.querySelector('p:nth-child(2)').innerText.split(': ')[1];
            const duracion = card.querySelector('p:nth-child(3)').innerText.split(': ')[1];

            recetaData.medicamentos.push({ nombre, sustancia, cantidad, duracion });
        });

        console.log(JSON.stringify(recetaData)); // Muestra el JSON en la consola
		guardar(JSON.stringify(recetaData));
    }
	
	
function guardar(json) {
    var datos = {
        IDU: <?php echo $iduul;?>+"",
        IDC: <?php echo $idPaciente;?>+"",
        Tipo: "Receta",
        Observaciones:  "Sin observaciones",
        Datos: json,
        Token: "<?php echo bin2hex( openssl_random_pseudo_bytes( 4 ) );?>",
        Conjunto_A: "1",
        Conjunto_B: "2"
    };
    
    var valores= JSON.stringify(datos);
    
    var formData = {
        id: 0,
        valores: valores, 
        funcion: "insert"
    };
    
    $.ajax({
        url: '<?php echo $urlajaxUpdate; ?>',
        type: 'POST',
        data: formData,
        success: function(response) {
            $("#Mensaje").html('<div class="alert alert-success alert-dismissible alert-alt fade show"><button type="button" class="close h-100" data-dismiss="alert" aria-label="Close"><span><i class="mdi mdi-close"></i></span></button><strong>Listo </strong> Se actualizo correctamente.</div>');
            setTimeout(function() {$('#Mensaje').empty();}, 2000);
            console.log(response);
            setTimeout(function() {location.reload();}, 3000);
        },
        error: function(error) {
            console.error('Error al enviar datos al servidor:', error);
        }
    });
}	
	

    // Asignar datos del paciente y doctor a los elementos correspondientes
    document.getElementById("infoNombre").innerText = pacienteData.nombre;
    document.getElementById("infoTelefono").innerText = pacienteData.telefono;
    document.getElementById("infoFecha").innerText = new Date().toLocaleDateString();
</script>
