

<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet" />
<style>
body {
    background-color: #f8f9fa;
}
.card {
    border-radius: 1rem;
}
.estado-icono i {
    font-size: 1.2rem;
}
.list-group-item:hover {
    background-color: #e9ecef;
    cursor: pointer;
}
.disabled {
    pointer-events: none;
    opacity: 0.6;
}
.tabla-creditos-scroll {
    max-height: 300px; /* ajusta la altura para que entren 10 filas aprox */
    overflow-y: auto;
}
.lista-clientes-scroll {
    max-height: 350px; /* altura para 10 elementos aprox */
    overflow-y: auto;
}
</style>

<div class="container-fluid py-4">
  <div class="row"> 
    <!-- Lista de Clientes -->
    <div class="col-md-4">
      <div class="card shadow-sm">
        <div class="card-header bg-secundary text-white border border-primary">


          <h5 class="mb-0"><i class="fa fa-users"></i> Clientes</h5>
        </div>
        <div class="card-body p-3">
          <input type="text" class="form-control mb-3" placeholder="Buscar cliente..." onkeyup="filtrarClientes(this)" />
          <ul class="list-group" id="listaClientes">
            <?php foreach ($clientes as $c): ?>
            <li class="list-group-item list-group-item-action"
                  data-id="<?= $c['id'] ?>"
                  data-nombre="<?= $c['Nombre'] ?>"
                  data-telefono="<?= $c['Telefono'] ?>"> <strong>
              <?= htmlspecialchars($c['Nombre']) ?>
              </strong><br />
              <small>ID:
              <?= $c['id'] ?>
              -
              <?= htmlspecialchars($c['Telefono']) ?>
              </small> </li>
            <?php endforeach; ?>
          </ul>
        </div>
      </div>
    </div>
    
    <!-- Panel Cliente con pestañas -->
    <div class="col-md-8">
      <div class="card shadow-sm d-none" id="panelCliente">
        <div class="card-header border border-dark  d-flex justify-content-between align-items-center">

          <h5 id="nombreCliente" class="mb-0"><i class="fa fa-user-circle"></i> Cliente</h5>
          <small id="telefonoCliente" class="text-end"></small> </div>
        <div class="card-body">
          <ul class="nav nav-tabs" id="tabCliente" role="tablist">
            <li class="nav-item" role="presentation">
              <button class="nav-link active" id="pedidos-tab" data-bs-toggle="tab" data-bs-target="#pedidos" type="button" role="tab" aria-controls="pedidos" aria-selected="true">Pedidos</button>
            </li>
            <li class="nav-item" role="presentation">
              <button class="nav-link" id="creditos-tab" data-bs-toggle="tab" data-bs-target="#creditos" type="button" role="tab" aria-controls="creditos" aria-selected="false">Créditos</button>
            </li>
          </ul>
          <div class="tab-content mt-3" id="tabContentCliente">
            <div class="tab-pane fade show active" id="pedidos" role="tabpanel" aria-labelledby="pedidos-tab">
              <div class="table-responsive">
                <table class="table table-sm table-bordered align-middle">
                  <thead class="table-light">
                    <tr>
                      <th>#</th>
                      <th>Fecha</th>
                      <th>Total</th>
                      <th>Estado</th>
                      <th>Acciones</th>
                    </tr>
                  </thead>
                  <tbody id="tablaPedidosCliente">
                  </tbody>
                </table>
              </div>
            </div>
            <div class="tab-pane fade" id="creditos" role="tabpanel" aria-labelledby="creditos-tab"> 
              <!-- Formulario para registrar pago -->
              <div class="mb-3">
                <label for="inputPago" class="form-label">Monto a pagar:</label>
                <div class="input-group">
                  <input type="number" min="0" step="0.01" class="form-control" id="inputPago" placeholder="Ejemplo: 100.00" />
                  <button class="btn btn-success" id="btnPagar" disabled>Pagar</button>
                </div>
              </div>
              <div id="resumenCreditos" class="border border-danger mt-3 p-3 d-none" style="background-color: white; color: #a94442;">
 <strong>Resumen:</strong><br>
                Total Créditos: <span id="totalCreditos">$0.00</span><br>
                Total Pagos: <span id="totalPagos">$0.00</span><br>
                <strong>Deuda actual:</strong> <span id="totalDeuda" class="text-danger">$0.00</span> </div>
              <div class="table-responsive tabla-creditos-scroll">
                <table class="table table-sm table-bordered align-middle">
                  <thead class="table-light">
                    <tr>
                      <th>ID</th>
                      <th>IDN</th>
                      <th>IDC</th>
                      <th>Tipo</th>
                      <th>Monto</th>
                      <th>Fecha</th>
                    </tr>
                  </thead>
                  <tbody id="tablaCreditosCliente">
                  </tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Modal Detalle Pedido -->
<div class="modal fade" id="detallePedidoModal" tabindex="-1" aria-labelledby="detallePedidoLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-scrollable">
    <div class="modal-content">
      <div class="modal-header border-bottom border-dark">
          <h5 class="modal-title" id="detallePedidoLabel">Detalle del Pedido</h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Cerrar">X</button>
      </div>
      <div class="modal-body" id="contenidoDetallePedido"> 
        <!-- Se carga dinámicamente --> 
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
      </div>
    </div>
  </div>
</div>
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script> 
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script> 
<script>
let pedidosActuales = [];

const estadoIconos = {
  Banco: "fa-university",
  Efectivo: "fa-money-bill-wave",
  Pendiente: "fa-clock",
  Cancelado: "fa-times",
  default: "fa-question-circle"
};

const estadosPermitidos = ["Abierta", "Preparando", "Listo", "Entregado"];

document.querySelectorAll("#listaClientes li").forEach(li => {
  li.addEventListener("click", function () {
    const clienteId = this.dataset.id;
    const nombre = this.dataset.nombre;
    const telefono = this.dataset.telefono;

    document.getElementById("nombreCliente").textContent = `👤 ${nombre}`;
    document.getElementById("telefonoCliente").textContent = `📞 ${telefono}`;
    document.getElementById("panelCliente").classList.remove("d-none");

    // Cargar pedidos
    $.ajax({
      url: '../librerias/ajaxAPP/ajaxSimple.php',
      method: 'POST',
      data: { id: clienteId, funcion: 'selectID', Vector: 0 },
      dataType: 'json',
      success: function (data) {
        pedidosActuales = data;
        const tbody = document.getElementById("tablaPedidosCliente");
        tbody.innerHTML = "";

        if (!Array.isArray(data) || data.length === 0) {
          tbody.innerHTML = `<tr><td colspan="5" class="text-center text-muted">Sin pedidos registrados</td></tr>`;
        } else {
          data.forEach(p => {
            const estadoActual = p.Estado || "Pendiente";
            const icono = estadoIconos[estadoActual] || estadoIconos.default;
            const disabled = estadosPermitidos.includes(estadoActual) ? "" : "disabled";

            let total = 0;
            try {
              const contenido = JSON.parse(p.Datos);
              if (contenido.productos && Array.isArray(contenido.productos)) {
                contenido.productos.forEach(prod => {
                  total += (parseFloat(prod.precio) || 0) * (parseInt(prod.cantidad) || 0);
                });
              }
            } catch (e) {
              console.error("Error al parsear Datos JSON:", e);
            }

            const tr = document.createElement("tr");
            tr.innerHTML = `
              <td>${p.IDP}</td>
              <td>${p.TimeStamp}</td>
              <td>$${total.toFixed(2)}</td>
              <td class="estado-icono"><i class="fa ${icono}" title="${estadoActual}"></i></td>
              <td>
                <button class="btn btn-sm btn-info" onclick="verPedido(${p.IDP})" title="Ver"><i class="fa fa-eye"></i></button>
                
              </td>
            `;
            tbody.appendChild(tr);
          });
        }
      },
      error: function () {
        alert("Error al obtener pedidos.");
      }
    });

    // Cargar créditos
    $.ajax({
      url: '../librerias/ajaxAPP/ajaxSimple.php',
      method: 'POST',
      data: { id: clienteId, funcion: 'selectID', Vector: 1 },  // Usamos Vector=1 para créditos
      dataType: 'json',
      success: function (creditos) {
		  console.log(creditos);
        const tbodyCred = document.getElementById("tablaCreditosCliente");
        tbodyCred.innerHTML = "";

        if (!Array.isArray(creditos) || creditos.length === 0) {
  tbodyCred.innerHTML = `<tr><td colspan="6" class="text-center text-muted">Sin créditos registrados</td></tr>`;
  calcularResumenCreditos([]); // Limpiar resumen cuando no hay créditos
  return; // salir
}
 else {
          creditos.forEach(c => {
            const tr = document.createElement("tr");
            tr.innerHTML = `
              <td>${c.id || ''}</td>
              <td>${c.IDN || ''}</td>
			 	<td>${c.IDC || ''}</td>
 				<td>${c.Tipo || ''}</td>
              <td>${c.Monto || ''}</td>
              <td>${c.fecha || ''}</td>
            `;
            tbodyCred.appendChild(tr);
			

          });
			 calcularResumenCreditos(creditos); // Esto actualiza el resumen
        }
      },
      error: function () {
        alert("Error al obtener créditos.");
      }
    });
  });
});

function confirmarCambio(idPedido, nuevoEstado, boton) {
  if (!confirm(`¿Estás seguro de cambiar el estado del pedido ${idPedido} a "${nuevoEstado}"?`)) return;

  $.ajax({
    url: '../librerias/ajaxAPP/ajaxSimple.php',
    method: 'POST',
    data: { id: idPedido, value: nuevoEstado, column: 'Estado', funcion: 'update' },
    success: function() {
      boton.closest("td").querySelectorAll("button").forEach(b => b.classList.add("disabled"));
      alert("Estado actualizado con éxito.");
    },
    error: function() {
      alert("Error al actualizar estado.");
    }
  });
}

function verPedido(idPedido) {
  const pedido = pedidosActuales.find(p => p.IDP == idPedido);
  if (!pedido) {
    alert("Pedido no encontrado");
    return;
  }

  let contenido;
  try {
    contenido = JSON.parse(pedido.Datos);
  } catch (e) {
    alert("Error al procesar la información del pedido.");
    return;
  }

  let totalGeneral = 0;
  const productosHTML = contenido.productos.map(p => {
    const total = (parseFloat(p.precio) || 0) * (parseInt(p.cantidad) || 0);
    totalGeneral += total;
    return `
      <tr>
        <td>${p.nombre}</td>
        <td>${p.descripcion || ''}</td>
        <td>${p.cantidad}</td>
        <td>$${parseFloat(p.precio).toFixed(2)}</td>
        <td>$${total.toFixed(2)}</td>
      </tr>`;
  }).join('');

  const htmlDetalle = `
    <h5>Cliente</h5>
    <p>
      <strong>${contenido.cliente.nombre || ''}</strong><br>
      Teléfono: ${contenido.cliente.telefono || ''}<br>
      Dirección: ${contenido.cliente.direccion || ''}
    </p>

    <h5>Productos</h5>
    <div class="table-responsive">
      <table class="table table-sm table-bordered">
        <thead class="table-light">
          <tr>
            <th>Nombre</th>
            <th>Descripción</th>
            <th>Cantidad</th>
            <th>Precio</th>
            <th>Total</th>
          </tr>
        </thead>
        <tbody>
          ${productosHTML}
        </tbody>
        <tfoot>
          <tr>
            <th colspan="4" class="text-end">Total General</th>
            <th>$${totalGeneral.toFixed(2)}</th>
          </tr>
        </tfoot>
      </table>
    </div>

    <h5>Entrega y Observaciones</h5>
    <p>
      <strong>Tipo de entrega:</strong> ${contenido.tipo_entrega || ''}<br>
      <strong>Observaciones:</strong> ${contenido.observaciones || ''}
    </p>
  `;

  document.getElementById("contenidoDetallePedido").innerHTML = htmlDetalle;
  const modal = new bootstrap.Modal(document.getElementById('detallePedidoModal'));
  modal.show();
}

function filtrarClientes(input) {
  const filtro = input.value.toLowerCase();
  document.querySelectorAll("#listaClientes li").forEach(li => {
    li.style.display = li.textContent.toLowerCase().includes(filtro) ? "" : "none";
  });
}
	
	
	// Variable para guardar el cliente actual
let clienteActualId = null;

// Modifica el evento click para guardar el cliente actual
document.querySelectorAll("#listaClientes li").forEach(li => {
  li.addEventListener("click", function () {
    clienteActualId = this.dataset.id;
    // resto de tu código para cargar pedidos y créditos...

    // Después de mostrar panel y cargar AJAX...
    // También limpia y deshabilita el botón de pagar
    document.getElementById("inputPago").value = "";
    document.getElementById("btnPagar").disabled = true;
  });
});

// Habilitar botón pagar solo si hay monto válido
document.getElementById("inputPago").addEventListener("input", function() {
  const val = parseFloat(this.value);
  document.getElementById("btnPagar").disabled = isNaN(val) || val <= 0;
});

// Al hacer click en pagar, llamar a función pagar con id cliente y monto
document.getElementById("btnPagar").addEventListener("click", function() {
  const monto = parseFloat(document.getElementById("inputPago").value);
  if (!clienteActualId) {
    alert("Selecciona un cliente primero.");
    return;
  }
  if (isNaN(monto) || monto <= 0) {
    alert("Ingresa un monto válido.");
    return;
  }
  pagar(clienteActualId, monto);
});

// Función pagar (de momento solo muestra alerta, aquí iría el AJAX)
function pagar(id, monto) {
  alert(`Pagando $${monto.toFixed(2)} para cliente ID: ${id}`);

 const formData = {
    id: 0,
    IDL: "<?php echo $IDLs; ?>",
    IDC: id,
    IDN: 0,
    Tipo: "Pago",
    Monto: monto,
    Token: "<?php echo bin2hex(openssl_random_pseudo_bytes(4)); ?>",
    Vector: "0", // según la configuración que uses
    funcion: "insertS"
  };

  const urlajaxUpdate = "http://167.172.224.160/MiSi/librerias/ajaxAPP/ajaxSimple.php";

  $.ajax({
    url: urlajaxUpdate,
    type: 'POST',
    data: formData,
    success: function (response) {
      console.log("Respuesta del crédito:", response);
    },
    error: function (error) {
      console.error('Error al registrar crédito:', error);
    }
  });
  cargarCreditos(id);
	
}
	
	function calcularResumenCreditos(creditos) {
  let totalCreditos = 0;
  let totalPagos = 0;

  creditos.forEach(c => {
    const monto = parseFloat(c.Monto) || 0;
    if (c.Tipo === "Credito") {
      totalCreditos += monto;
    } else if (c.Tipo === "Pago") {
      totalPagos += monto;
    }
  });

  const deuda = totalCreditos - totalPagos;

  document.getElementById("totalCreditos").textContent = `$${totalCreditos.toFixed(2)}`;
  document.getElementById("totalPagos").textContent = `$${totalPagos.toFixed(2)}`;
  document.getElementById("totalDeuda").textContent = `$${deuda.toFixed(2)}`;

  const resumen = document.getElementById("resumenCreditos");
  if (totalCreditos > 0 || totalPagos > 0) {
    resumen.classList.remove("d-none");
  } else {
    resumen.classList.add("d-none");
  }
}

	
	
	
function cargarCreditos(idCliente) {
  $.ajax({
    url: '../librerias/ajaxAPP/ajaxSimple.php',
    method: 'POST',
    data: { id: idCliente, funcion: ' ', Vector: 1 }, // Créditos
    dataType: 'json',
    success: function (creditos) {
      const tbodyCred = document.getElementById("tablaCreditosCliente");
      tbodyCred.innerHTML = "";

      if (!Array.isArray(creditos) || creditos.length === 0) {
        tbodyCred.innerHTML = `<tr><td colspan="6" class="text-center text-muted">Sin créditos registrados</td></tr>`;
      } else {
        creditos.forEach(c => {
          const tr = document.createElement("tr");
          tr.innerHTML = `
            <td>${c.id || ''}</td>
            <td>${c.IDN || ''}</td>
            <td>${c.IDC || ''}</td>
            <td>${c.Tipo || ''}</td>
            <td>${c.Monto || ''}</td>
            <td>${c.fecha || ''}</td>
          `;
          tbodyCred.appendChild(tr);
        });
      }

      calcularResumenCreditos(creditos); // Esto actualiza el resumen
    },
    error: function () {
      alert("Error al obtener créditos.");
    }
  });
}


</script> 
