<style>
  body {
    background: #f8f9fa;
  }
  .card {
    position: relative;
    transition: transform 0.2s ease;
  }
  .card:hover {
    transform: scale(1.01);
  }
  .estado-btn {
    margin-right: 0.5rem;
  }
  .badge-estado {
    font-size: 0.9rem;
  }
  .btn-cerrar {
    position: absolute;
    top: 0.5rem;
    right: 0.5rem;
    border: none;
    background: none;
    font-size: 1.2rem;
    color: #FF0004;
    z-index: 2;
  }
  .btn-cerrar:hover {
    color: #dc3545;
  }
  .tiempo-transcurrido {
    font-weight: 500;
    font-size: 0.9rem;
    color: #ccc;
  }
  .tiempo-transcurrido.alerta {
    color: #dc3545 !important; /* rojo cuando pasa el tiempo límite */
  }
</style>

<div class="container py-4">
  <h2 class="mb-4">Historial de Pedidos</h2>
  <div id="pedidosContainer" class="row gy-4"></div>
</div>

<script>
  function fetchPedidosAjax() {
    $.ajax({
      url: '../librerias/ajaxAPP/ajaxSimple.php',
      method: 'POST',
      data: { id: 2, funcion: 'select' },
      dataType: 'json',
      success: function (data) {
        const pedidos = Object.values(data);
        renderPedidos(pedidos);
      },
      error: function (err) {
        console.error('❌ Error al obtener pedidos:', err);
      }
    });
  }

  function renderPedidos(pedidos) {
    const container = $('#pedidosContainer');
    container.empty();

    pedidos.forEach(pedido => {
      let contenido;
      try {
        contenido = JSON.parse(pedido.contenido);
      } catch (e) {
        contenido = { error: true };
      }
      if (!contenido || contenido.error) return;

      // Calcular total venta
      let totalVenta = 0;
      contenido.productos.forEach(prod => {
        totalVenta += prod.cantidad * prod.precio;
      });

      const productosHTML = contenido.productos.map(prod => `
        <li class="list-group-item d-flex justify-content-between align-items-start">
          <div class="ms-2 me-auto">
            <div class="fw-bold">${prod.nombre}</div>
            ${prod.descripcion}<br>
            Cantidad: ${prod.cantidad}<br>
            Precio: $${prod.precio}<br>
            ${prod.instrucciones ? `<em>Instrucciones: ${prod.instrucciones}</em>` : ''}
          </div>
          <span class="badge btn-outline-success rounded-pill">$${(prod.precio * prod.cantidad).toFixed(2)}</span>
        </li>
      `).join('');

      const tarjeta = $(`
        <div class="col-md-6">
          <div class="card shadow-sm">
            <button class="btn-cerrar" onclick="accionPedido(this, 'Cerrada', ${pedido.id})" title="Cerrar pedido">
              <i class="fa fa-times"></i>
            </button>
            <div class="card-header bg-primary text-white d-flex justify-content-between align-items-center">
              <span>Pedido #${pedido.id}</span>
              <small>
                ${pedido.fecha} - 
                <span class="tiempo-transcurrido" data-fecha="${pedido.fecha}">0s</span>
              </small>
            </div>
            <div class="card-body">
              <h5 class="card-title">👤 ${contenido.cliente.nombre}</h5>
              <p class="card-text mb-1">
                <i class="fa fa-phone"></i> ${contenido.cliente.telefono}<br>
                <i class="fa fa-map-marker-alt"></i> ${contenido.cliente.direccion}<br>
                <strong>Entrega:</strong> ${contenido.tipo_entrega}
              </p>
              ${contenido.observaciones ? `<p class="text-muted"><em>Nota: ${contenido.observaciones}</em></p>` : ''}
              <ul class="list-group mb-3">${productosHTML}</ul>
              <p><strong>Total Venta:</strong> $${totalVenta.toFixed(2)}</p>
<div class="d-flex align-items-center">
  <button class="btn estado-btn ${pedido.estado === 'Preparando' ? 'btn-warning text-dark' : 'btn-outline-warning'}" onclick="accionPedido(this, 'Preparando', ${pedido.id})"><i class="fa fa-hourglass-half"></i></button>
  <button class="btn estado-btn ${pedido.estado === 'Listo' ? 'btn-info text-dark' : 'btn-outline-info'}" onclick="accionPedido(this, 'Listo', ${pedido.id})"><i class="fa fa-check-circle"></i></button>
  <button class="btn estado-btn ${pedido.estado === 'Entregado' ? 'btn-success text-dark' : 'btn-outline-success'}" onclick="accionPedido(this, 'Entregado', ${pedido.id})"><i class="fa fa-truck"></i></button>
  <span class="ms-auto badge bg-secondary badge-estado">${pedido.estado || 'Pendiente'}</span>
</div>

            </div>
          </div>
        </div>
      `);

      container.append(tarjeta);
    });

    iniciarRelojes();
  }

  function cambiarEstadoVisual(btn, estado) {
    const badge = $(btn).closest('.card').find('.badge-estado');
    let color = 'secondary';
    if (estado === 'Preparando') color = 'warning';
    else if (estado === 'Listo') color = 'info';
    else if (estado === 'Entregado') color = 'success';

    badge.removeClass().addClass(`badge bg-${color} badge-estado`).text(estado);
  }

  function accionPedido(btn, accion, idPedido) {
    if (accion === 'Cerrar') {
      if (confirm('¿Deseas cerrar este pedido?')) {
        $(btn).closest('.col-md-6').remove();
       
		  actualizarEstadoPedido(idPedido, accion, btn);
		 
        // Aquí podrías hacer un AJAX para notificar al servidor del cierre
      }
    } else {
      cambiarEstadoVisual(btn, accion);
     
		actualizarEstadoPedido(idPedido, accion, btn);
      // Aquí podrías hacer un AJAX para actualizar el estado en servidor
    }
  }
	
function actualizarEstadoPedido(idPedido, nuevoEstado, btn) {
  $.ajax({
    url: '../librerias/ajaxAPP/ajaxSimple.php',
    method: 'POST',
    data: { 
      id: idPedido, 
      value: nuevoEstado,
	  column: 'Estado',	
      funcion: 'update' 
    },
   
    success: function(response) {
		//console.log(response);
      
    },
    error: function(err) {
      alert('Error en la conexión AJAX para actualizar pedido.');
      console.error(err);
    }
  });
}


  // Función para actualizar todos los relojes de pedidos
  function iniciarRelojes() {
    $('.tiempo-transcurrido').each(function () {
      const elem = $(this);
      const fechaPedido = new Date(elem.data('fecha'));

      function actualizar() {
        const ahora = new Date();
        let diffMs = ahora - fechaPedido;
        if (diffMs < 0) diffMs = 0;
        const diffSec = Math.floor(diffMs / 1000);
        const h = Math.floor(diffSec / 3600);
        const m = Math.floor((diffSec % 3600) / 60);
        const s = diffSec % 60;

        elem.text(`${h}h ${m}m ${s}s`);

        // Cambiar color a rojo si pasa 15 minutos (900 segundos)
        if (diffSec >= 900) {
          elem.addClass('alerta');
        } else {
          elem.removeClass('alerta');
        }
      }

      actualizar();
      setInterval(actualizar, 1000);
    });
  }

  // Llamada inicial y actualización cada 10 segundos
  fetchPedidosAjax();
  setInterval(fetchPedidosAjax, 10000);
</script>
