    <style>
		.row {  display: flex; justify-content: center;  width: 100%;  margin: 0 20px; }
        .odontograma { display: flex; justify-content: center; margin: 20px; flex-wrap: wrap; }
		.odontograma-group { display: flex;   justify-content: center;  margin: 10px; flex-wrap: nowrap;}
        .diente { width: 60px; height: 60px; margin: 5px; border: 1px solid #333; position: relative; display: inline-block; }
        .cara { width: 100%; height: 100%; position: absolute; text-align: center; cursor: pointer; }
        .oclusal { top: 0; left: 0; width: 100%; height: 20%; background: none; }
        .mesial { top: 0; left: 0; width: 20%; height: 100%; background: none; }
        .distal { top: 0; right: 0; width: 20%; height: 100%; background: none; }
        .lingual { bottom: 0; left: 0; width: 100%; height: 20%; background: none; }
        .bucal { top: 20%; left: 20%; width: 60%; height: 60%; background: none; }
        .caries { background: red !important; }
        .fractura { background: orange !important; }
        .obturacion { background: blue !important; }
        .extraccion { background: url('http://167.172.224.160/MiSi/librerias/Archivos/IMG/malla.png'); color: #000; background-size: cover;}
        .perdida_temprana { background: black !important; }
        .vacio { background: none !important; }
        .menu-dano { display: none; position: absolute; top: 60px; left: 0; background: white; border: 1px solid #ccc; z-index: 10; }
        .menu-dano button { display: block; width: 100%; border: none; padding: 5px; background: white; cursor: pointer; }
        .row { display: flex; justify-content: center; width: 100%; }
		.diente-label {margin-top: 5px; text-align: center;}
        .diente-container { display: flex; flex-direction: column; align-items: center; margin: 5px; }
        .reporte { margin-top: 20px; width: 100%; text-align: center; }
		.reporte h3 { font-size: 1.5em; color: #333; margin-bottom: 10px; }
		.reporte-contenedor { background-color: #f4f4f4; border: 1px solid #ccc; padding: 20px; width: 80%; margin: 0 auto; box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1); border-radius: 8px; }
		.reporte-contenedor p { font-size: 1.1em; color: #666; }
		.reporte, .observaciones-form { margin-top: 20px; width: 100%; text-align: center; }
		.buttons { margin-top: 20px; display: flex; justify-content: space-around; width: 50%; }
		.buttons button { padding: 10px 20px; font-size: 1em; border-radius: 5px; cursor: pointer; }
		.perfil-selector { display: flex; flex-direction: column; align-items: center; margin-bottom: 20px; }
		.perfil-selector label { font-size: 1.2em; margin-bottom: 10px; }
		#perfil { padding: 10px; font-size: 1em; border: 1px solid #ccc; border-radius: 5px; background-color: #f4f4f4; appearance: none; -moz-appearance: none; -webkit-appearance: none; cursor: pointer; transition: border-color 0.3s ease; }
		#perfil:hover { border-color: #4CAF50; }
		#perfil:focus { outline: none; border-color: #FF9800; }
		.perfil-selector::after { content: '▼'; position: absolute; right: 10px; pointer-events: none; font-size: 0.8em; color: #666; }

    </style>
	 
	 <div class="row page-titles mx-0">
    
   <!-- Selector de perfil -->
<div class="container mt-3">
      <!-- Grupo de Input -->
    <div class="input-group">
        <label class="input-group-text" for="perfil">Perfil</label>
        <select class="form-select flex-grow-1" id="perfil">
            <option value="adulto">Adulto</option>
            <option value="pediatrico">Pediátrico</option>
        </select>

        <!-- Botones de Odontogramas -->
		<label class="input-group-text" for="perfil">Odontogramas</label>
       
		<?php
// Suponiendo que tienes el arreglo en una variable llamada $data
$data = [
    [
        "id" => 15,
        "IDU" => 0,
        "Datos" => '{"11":{"caras":{"bucal":"obturacion"}},"23":{"caras":{"bucal":"caries","mesial":"caries"}}}',
        "Fecha" => '2024-10-27 09:42:05'
    ],
    [
        "id" => 14,
        "IDU" => 0,
        "Datos" => '{"13":{"caras":{"bucal":"caries"}}}',
        "Fecha" => '2024-10-27 09:41:45'
    ]
];

foreach ($data as $item) {
    $id = $item['id'];
    $fecha = $item['Fecha'];
    $datos = htmlspecialchars($item['Datos']); // Escapar caracteres especiales

    echo "<button class='btn btn-outline-primary' value='{$datos}'>ID: {$id} <br> {$fecha}</button>";
}
?>
       
    </div>
</div>

<!-- Odontograma para perfil adulto -->

<div class="odontograma" id="odontograma">
	 
    <!-- Agrupación de dientes permanentes superiores (cuadrantes 1 y 2) -->
    <div class="odontograma-group">
        <!-- Cuadrante 1 -->
        <div class="row">
            <?php for ($i = 18; $i >= 11; $i--): ?>
                <div class="diente-container">
                    <div class="diente" data-id="<?= $i ?>">
                        <div class="cara oclusal" data-cara="oclusal"></div>
                        <div class="cara mesial" data-cara="mesial"></div>
                        <div class="cara distal" data-cara="distal"></div>
                        <div class="cara lingual" data-cara="lingual"></div>
                        <div class="cara bucal" data-cara="bucal"></div>
                    </div>
                    <div class="diente-label"><?= $i ?></div>
                </div>
            <?php endfor; ?>
        </div>

        <!-- Cuadrante 2 -->
        <div class="row">
            <?php for ($i = 21; $i <= 28; $i++): ?>
                <div class="diente-container">
                    <div class="diente" data-id="<?= $i ?>">
                        <div class="cara oclusal" data-cara="oclusal"></div>
                        <div class="cara mesial" data-cara="mesial"></div>
                        <div class="cara distal" data-cara="distal"></div>
                        <div class="cara lingual" data-cara="lingual"></div>
                        <div class="cara bucal" data-cara="bucal"></div>
                    </div>
                    <div class="diente-label"><?= $i ?></div>
                </div>
            <?php endfor; ?>
        </div>
    </div>

    <!-- Agrupación de dientes permanentes inferiores (cuadrantes 3 y 4) -->
    <div class="odontograma-group">
        <!-- Cuadrante 3 -->
        <div class="row">
            <?php for ($i = 48; $i >= 41; $i--): ?>
                <div class="diente-container">
                    <div class="diente" data-id="<?= $i ?>">
                        <div class="cara oclusal" data-cara="oclusal"></div>
                        <div class="cara mesial" data-cara="mesial"></div>
                        <div class="cara distal" data-cara="distal"></div>
                        <div class="cara lingual" data-cara="lingual"></div>
                        <div class="cara bucal" data-cara="bucal"></div>
                    </div>
                    <div class="diente-label"><?= $i ?></div>
                </div>
            <?php endfor; ?>
        </div>

        <!-- Cuadrante 4 -->
        <div class="row">
            <?php for ($i = 31; $i <= 38; $i++): ?>
                <div class="diente-container">
                    <div class="diente" data-id="<?= $i ?>">
                        <div class="cara oclusal" data-cara="oclusal"></div>
                        <div class="cara mesial" data-cara="mesial"></div>
                        <div class="cara distal" data-cara="distal"></div>
                        <div class="cara lingual" data-cara="lingual"></div>
                        <div class="cara bucal" data-cara="bucal"></div>
                    </div>
                    <div class="diente-label"><?= $i ?></div>
                </div>
            <?php endfor; ?>
        </div>
    </div>
</div>

<!-- Dientes primarios para perfil pediátrico (cuadrantes 5 al 8) -->
<div class="odontograma" id="dientes-pediatrico" style="display: none;">
    <!-- Agrupación de dientes primarios superiores (cuadrantes 5 y 6) -->
    <div class="odontograma-group">
        <!-- Cuadrante 5 -->
        <div class="row">
            <?php for ($i = 55; $i >= 51; $i--): ?>
                <div class="diente-container">
                    <div class="diente" data-id="<?= $i ?>">
                        <div class="cara oclusal" data-cara="oclusal"></div>
                        <div class="cara mesial" data-cara="mesial"></div>
                        <div class="cara distal" data-cara="distal"></div>
                        <div class="cara lingual" data-cara="lingual"></div>
                        <div class="cara bucal" data-cara="bucal"></div>
                    </div>
                    <div class="diente-label"><?= $i ?></div>
                </div>
            <?php endfor; ?>
        </div>

        <!-- Cuadrante 6 -->
        <div class="row">
            <?php for ($i = 61; $i <= 65; $i++): ?>
                <div class="diente-container">
                    <div class="diente" data-id="<?= $i ?>">
                        <div class="cara oclusal" data-cara="oclusal"></div>
                        <div class="cara mesial" data-cara="mesial"></div>
                        <div class="cara distal" data-cara="distal"></div>
                        <div class="cara lingual" data-cara="lingual"></div>
                        <div class="cara bucal" data-cara="bucal"></div>
                    </div>
                    <div class="diente-label"><?= $i ?></div>
                </div>
            <?php endfor; ?>
        </div>
    </div>

    <!-- Agrupación de dientes primarios inferiores (cuadrantes 7 y 8) -->
    <div class="odontograma-group">
        <!-- Cuadrante 7 -->
        <div class="row">
            <?php for ($i = 85; $i >= 81; $i--): ?>
                <div class="diente-container">
                    <div class="diente" data-id="<?= $i ?>">
                        <div class="cara oclusal" data-cara="oclusal"></div>
                        <div class="cara mesial" data-cara="mesial"></div>
                        <div class="cara distal" data-cara="distal"></div>
                        <div class="cara lingual" data-cara="lingual"></div>
                        <div class="cara bucal" data-cara="bucal"></div>
                    </div>
                    <div class="diente-label"><?= $i ?></div>
                </div>
            <?php endfor; ?>
        </div>

        <!-- Cuadrante 8 -->
        <div class="row">
            <?php for ($i = 71; $i <= 75; $i++): ?>
                <div class="diente-container">
                    <div class="diente" data-id="<?= $i ?>">
                        <div class="cara oclusal" data-cara="oclusal"></div>
                        <div class="cara mesial" data-cara="mesial"></div>
                        <div class="cara distal" data-cara="distal"></div>
                        <div class="cara lingual" data-cara="lingual"></div>
                        <div class="cara bucal" data-cara="bucal"></div>
                    </div>
                    <div class="diente-label"><?= $i ?></div>
                </div>
            <?php endfor; ?>
        </div>
    </div>
</div>


    <div class="menu-dano">
        <button data-dano="vacio">Vacío</button>
        <button data-dano="caries">Caries</button>
        <button data-dano="fractura">Fractura</button>
        <button data-dano="obturacion">Obturación</button>
        <button data-dano="extraccion">Extracción</button>
        <button data-dano="perdida_temprana">Pérdida Temprana</button>
    </div>

		       <!-- Formulario de Observaciones -->

    <div class="observaciones-form p-4 rounded bg-light">
        <h3 class="text-center mb-3">Observaciones</h3>
        <div class="observaciones-container">
            <textarea id="observaciones" class="form-control" rows="4" placeholder="Escriba observaciones adicionales aquí..."></textarea>
        </div>
       
    </div>
	 
		 
    <div class="reporte">
        <h3>Reporte del Odontograma</h3>
        <div class="reporte-contenedor">
            <p id="reporte-texto"></p>
        </div>
    </div>
		 

    <!-- Botones (Parte inferior) -->
    <div class="buttons">
        <button id="guardar" class="btn btn-success">Guardar</button>
	
    	<button onclick="imprimirOdontograma()">Imprimir Odontograma</button>


        <button id="restablecer" class="btn btn-warning">Restablecer</button>
    </div>
</div>
    <script>
        let odontograma = {};
        let currentDiente = null;
        let currentCara = null;
        let perfilActual = 'adulto';  // Perfil por defecto

        $(document).ready(function() {
			       // Función para cargar odontograma desde JSON
        
		    $('.btn-outline-primary').on('click', function() {
        const jsonOdontograma = $(this).val(); // Obtener el valor JSON del botón
        cargarOdontogramaDesdeJson(jsonOdontograma); // Cargar el odontograma
    });

function cargarOdontogramaDesdeJson(json) {
    // Limpiar el odontograma
    limpiarOdontograma();

    // Parsear el JSON
    const data = JSON.parse(json);

    // Limpiar el arreglo odontograma
    odontograma = []; // Reiniciar el arreglo antes de llenarlo

    Object.keys(data).forEach(diente => {
        const caras = data[diente].caras;
        
        // Almacenar la información del diente en el arreglo odontograma
        let dienteInfo = {
            ID_Diente: diente,
            caras: {}
        };

        for (const cara in caras) {
            const tipo_dano = caras[cara];
            const claseDano = tipo_dano === 'vacio' ? '' : tipo_dano;

            // Añadir la información de la cara al objeto del diente
            dienteInfo.caras[cara] = tipo_dano;

            // Actualizar el diente en el DOM
            $('.diente[data-id="' + diente + '"] .cara[data-cara="' + cara + '"]')
                .removeClass('caries fractura obturacion extraccion perdida_temprana')
                .addClass(claseDano);
        }

        // Agregar la información del diente al arreglo odontograma
        odontograma.push(dienteInfo);
    });

    mostrarReporte(); // Asegúrate de que esta línea esté presente
}

    // Función para limpiar el odontograma
    function limpiarOdontograma() {
        // Aquí limpias todas las clases de daño en los dientes
        $('.diente .cara').removeClass('caries fractura obturacion extraccion perdida_temprana');
    }	
			
			
            // Cambio de perfil
            $('#perfil').on('change', function() {
                perfilActual = $(this).val();
                if (perfilActual === 'adulto') {
                    $('#dientes-adulto').show();
                    $('#dientes-pediatrico').hide();
                } else {
                    $('#dientes-adulto').hide();
                    $('#dientes-pediatrico').show();
                }
            });

            // Control de selección de caras
            $('.cara').on('click', function() {
                currentDiente = $(this).closest('.diente').data('id');
                currentCara = $(this).data('cara');
                const menu = $('.menu-dano').css({top: $(this).offset().top, left: $(this).offset().left}).show();
            });

            // Selección de daño
            $('.menu-dano button').on('click', function() {
                const tipo_dano = $(this).data('dano');
                const claseDano = tipo_dano === 'vacio' ? '' : tipo_dano;
                $('.diente[data-id="' + currentDiente + '"] .cara[data-cara="' + currentCara + '"]').removeClass('caries fractura obturacion extraccion perdida_temprana').addClass(claseDano);
                
                if (!odontograma[currentDiente]) {
                    odontograma[currentDiente] = {caras: {}};
                }

                if (tipo_dano === 'vacio') {
                    delete odontograma[currentDiente]['caras'][currentCara];
                } else {
                    odontograma[currentDiente]['caras'][currentCara] = tipo_dano;
                }

                $('.menu-dano').hide();
                mostrarReporte();
            });

            // Guardar
            $('#guardar').on('click', function() {
				
				
				 const serializedData = JSON.stringify(odontograma);
                 alert("Datos guardados");
				guardar(serializedData);
            
                // Guardar la información de odontograma en base de datos usando AJAX
                // Implementar código para enviar odontograma al backend
            });

            // Restablecer
            $('#restablecer').on('click', function() {
                $('.diente .cara').removeClass('caries fractura obturacion extraccion perdida_temprana');
                odontograma = {};
                $('#reporte-texto').text('');
            });
        });
		
	<?php 
    $urlajaxUpdate= "http://167.172.224.160/MiSi/librerias/ajaxAPP/ajaxSimple.php";
?>

function guardar(json) {
    var datos = {
        IDU: <?php echo $iduul;?>+"",
        IDC: <?php echo $idPaciente;?>+"",
        Tipo: "Odontograma",
        Observaciones: document.getElementById('observaciones').value || "Sin observaciones",
        Datos: json,
        Token: "<?php echo bin2hex( openssl_random_pseudo_bytes( 4 ) );?>",
        Conjunto_A: "1",
        Conjunto_B: "2"
    };
    
    var valores= JSON.stringify(datos);
    
    var formData = {
        id: 0,
        valores: valores, 
        funcion: "insert"
    };
    
    $.ajax({
        url: '<?php echo $urlajaxUpdate; ?>',
        type: 'POST',
        data: formData,
        success: function(response) {
            $("#Mensaje").html('<div class="alert alert-success alert-dismissible alert-alt fade show"><button type="button" class="close h-100" data-dismiss="alert" aria-label="Close"><span><i class="mdi mdi-close"></i></span></button><strong>Listo </strong> Se actualizo correctamente.</div>');
            setTimeout(function() {$('#Mensaje').empty();}, 2000);
            console.log(response);
            setTimeout(function() {location.reload();}, 3000);
        },
        error: function(error) {
            console.error('Error al enviar datos al servidor:', error);
        }
    });
}	

  function mostrarReporte() {
    if (!$.isEmptyObject(odontograma)) {
        $('.reporte').fadeIn(); // Mostrar el reporte con una animación cuando haya cambios
    }
    
    let reporte = 'Reporte:\n';
    for (let diente in odontograma) {
        reporte += `Diente ${diente}: `;
        for (let cara in odontograma[diente].caras) {
            reporte += `${cara} - ${odontograma[diente].caras[cara]}, `;
        }
        reporte += '\n';
    }
    $('#reporte-texto').text(reporte);
}

	function imprimirOdontograma() { 
		
		alert();
    const membership = memberships.find(m => m.id === membershipId);

    // Convertir el objeto de la membresía en formato JSON
    const jsonData = JSON.stringify(membership, null, 2);

    // Crear un formulario dinámico para enviar el JSON via POST
    const form = document.createElement('form');
    form.method = 'POST';
    form.action = 'http://167.172.224.160/MiSi/librerias/Impresora/ImprimirOdontograma.php';
    
    // Crear un campo oculto para enviar el JSON
    const hiddenField = document.createElement('input');
    hiddenField.type = 'hidden';
    hiddenField.name = 'membershipData'; // Nombre de la variable POST
    hiddenField.value = jsonData; // El valor es el JSON

    form.appendChild(hiddenField);

    // Abrir una ventana hija y enviar el formulario
    const printWindow = window.open('', '_blank', 'width=100,height=100'); // Tamaño de la ventana

    // Asegúrate de que la ventana hija se haya abierto correctamente antes de enviar el formulario
    printWindow.document.body.appendChild(form); // Agregar el formulario al body de la ventana hija
    form.submit(); // Enviar el formulario via POST
}

    </script>