<!-- Estilos personalizados -->
<style>
/* Tarjeta de notas en timeline */
.timeline-card {
    border-left: 5px solid #3c2f7a;
    background-color: #f8f9fa;
    border-radius: 0.5rem;
}
.timeline-card .card-body {
    padding: 1.25rem;
    border-radius: 0.5rem;
    box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
}
.timeline-card .card-body:hover {
    background-color: #e9ecef;
}
/* Fecha pequeña y estilizada */
.timeline-card small {
    font-style: italic;
    color: #6c757d;
}
/* Título del formulario */
.card-header {
    background-color: #9a77ff;
    color: white;
    text-align: center;
    font-weight: bold;
}
/* Botón agregar */
.btn-primary {
    background-color: #00002e;
    border: none;
}
.btn-primary:hover {
    background-color: #9a77ff;
}
</style>



<div class="container mt-5">
    <!-- Formulario para agregar una nueva nota -->
    <div class="card mb-4">
        <div class="card-header">
            <h5>Agregar Nota de Evolución</h5>
        </div>
        <div class="card-body">
            <!-- Formulario de Nota -->
            <form id="notaForm">
                <div class="form-group">
                    <label for="nota">Nota:</label>
                    <textarea class="form-control" id="nota" name="nota" rows="3" placeholder="Escribe la nota aquí..."></textarea>
                </div>
            </form>
            <!-- Formulario de Observaciones -->
            <form id="observacionesForm">
                <div class="form-group">
                    <label for="observacion">Observaciones:</label>
                    <textarea class="form-control" id="observacion" name="observacion" rows="3" placeholder="Escribe las observaciones aquí..."></textarea>
                </div>
                <button type="button" class="btn btn-primary btn-block" onclick="agregarNota()">Agregar Nota</button>
            </form>
        </div>
    </div>

    <!-- Timeline de notas de evolución -->
    <div id="timeline" class="mb-5">
        <!-- Notas existentes se cargan aquí dinámicamente -->
    </div>
</div>

<?php 
    $urlajaxUpdate= "http://167.172.224.160/MiSi/librerias/ajaxAPP/ajaxSimple.php";
	$datosJson = ($datosNotas);
?>


<script>
    // Arreglo de notas de ejemplo para mostrar al cargar
   // Función para interpretar los datos
	const datosDeEntrada = <?php echo json_encode($datosJson); ?>;
	console.log(datosDeEntrada);
	
function interpretarDatos(datos) {
    const notasEvolucion = [];

    datos.forEach(item => {
        // Extraer la fecha
        const fecha = item.Fecha;
        // Crear un objeto para la nota
        const notaObj = {
            nota: '',
            observacion: '',
            fecha: fecha
        };

        // Parsear 'Datos' como JSON
        let datosParsed;
        try {
            datosParsed = JSON.parse(item.Datos); // Intenta parsear los datos
        } catch (e) {
            console.error("Error al parsear Datos:", e);
            return; // Si no se puede parsear, no continúes con este item
        }

        // Ahora verifica si 'datosParsed' es un array
        if (Array.isArray(datosParsed)) {
            datosParsed.forEach(dato => {
                if (dato.name === 'nota') {
                    notaObj.nota = dato.value;
                } else if (dato.name === 'observacion') {
                    notaObj.observacion = dato.value;
                }
            });
        } else {
            console.warn("DatosParsed no es un array:", datosParsed);
        }

        // Agregar el objeto de nota al arreglo de notas de evolución
        notasEvolucion.push(notaObj);
    });

    return notasEvolucion;
}

// Llamar a la función y almacenar el resultado
const notasEvolucion = interpretarDatos(datosDeEntrada);

// Imprimir el resultado para verificar
console.log(notasEvolucion);
    // Función para cargar las notas iniciales
    function cargarNotas() {
        const timeline = document.getElementById('timeline');
        notasEvolucion.forEach(nota => {
            const nuevaNota = `
                <div class="card mb-3 timeline-card">
                    <div class="card-body">
                        <p><strong>Nota:</strong> ${nota.nota}</p>
                        <p><strong>Observaciones:</strong> ${nota.observacion}</p>
                        <small class="text-muted">Fecha: ${nota.fecha}</small>
                    </div>
                </div>
            `;
            timeline.insertAdjacentHTML('beforeend', nuevaNota);
        });
    }

    // Función para agregar nuevas notas al timeline y guardarlas
    function agregarNota() {
        // Serializar ambos formularios y combinarlos en un solo objeto JSON
        const notaData = $("#notaForm").serializeArray();
        const observacionData = $("#observacionesForm").serializeArray();
        
        // Combina los datos en un solo arreglo y convierte a JSON
        const formData = JSON.stringify([...notaData, ...observacionData]);
        
        console.log("Datos combinados del formulario:", formData);
        
        // Crear una nueva nota en el timeline
        const nota = notaData.find(field => field.name === "nota").value;
        const observacion = observacionData.find(field => field.name === "observacion").value;

        if (nota.trim() === "" && observacion.trim() === "") {
            alert("Ambos campos no pueden estar vacíos.");
            return;
        }

        const nuevaNota = `
            <div class="card mb-3 timeline-card">
                <div class="card-body">
                    <p><strong>Nota:</strong> ${nota}</p>
                    <p><strong>Observaciones:</strong> ${observacion}</p>
                    <small class="text-muted">Fecha: ${new Date().toLocaleString()}</small>
                </div>
            </div>
        `;

        document.getElementById('timeline').insertAdjacentHTML('afterbegin', nuevaNota);

        // Limpiar los campos de texto
        document.getElementById('nota').value = "";
        document.getElementById('observacion').value = "";

        // Llamar a la función guardar() con el JSON serializado
        guardar(formData);
    }

    // Función guardar para enviar el JSON serializado
    function guardar(json) {
        var datos = {
            IDU: <?php echo $iduul; ?> + "",
            IDC: <?php echo $idPaciente; ?> + "",
            Tipo: "Nota_Evolucion",
            Observaciones: "-",
        	Datos: json,
            Token: "<?php echo bin2hex(openssl_random_pseudo_bytes(4)); ?>",
            Conjunto_A: "1",
            Conjunto_B: "2"
        };

        var valores = JSON.stringify(datos);

        var formData = {
            id: 0,
            valores: valores, 
            funcion: "insert"
        };

        $.ajax({
            url: '<?php echo $urlajaxUpdate; ?>',
            type: 'POST',
            data: formData,
            success: function(response) {
                $("#Mensaje").html('<div class="alert alert-success alert-dismissible alert-alt fade show"><button type="button" class="close h-100" data-dismiss="alert" aria-label="Close"><span><i class="mdi mdi-close"></i></span></button><strong>Listo </strong> Se actualizo correctamente.</div>');
                setTimeout(function() { $('#Mensaje').empty(); }, 2000);
                console.log(response);
                setTimeout(function() { location.reload(); }, 3000);
            },
            error: function(error) {
                console.error('Error al enviar datos al servidor:', error);
            }
        });
    }

    // Cargar notas iniciales al cargar la página
    window.onload = function() {
        cargarNotas();
    };
</script>