<!-- Estilos personalizados -->
<style>
    /* Estilos para el modal */
    .modal {
        display: none; /* Oculto por defecto */
        position: fixed;
        z-index: 1000;
        padding-top: 60px;
        left: 0;
        top: 0;
        width: 100%;
        height: 100%;
        background-color: rgba(0, 0, 0, 0.8);
    }
.modal-content {
    display: block;
    max-width: none; /* Permite que la imagen use su tamaño original */
    max-height: none; /* Permite que la imagen use su tamaño original */
    width: auto; /* Ancho automático */
    height: auto; /* Alto automático */
    margin: auto; /* Centra la imagen en el modal */
}

    .close {
        position: absolute;
        top: 15px;
        right: 35px;
        color: #f1f1f1;
        font-size: 40px;
        font-weight: bold;
        cursor: pointer;
    }
    .close:hover,
    .close:focus {
        color: #bbb;
        text-decoration: none;
        cursor: pointer;
    }

    .gallery-item {
        position: relative;
        overflow: hidden;
        transition: transform 0.3s ease;
        margin-bottom: 20px;
        margin-right: 10px;
    }
    .gallery-item:hover {
        transform: scale(1.05);
    }
    .gallery-item img {
        width: 150px; /* Ajusta el ancho deseado */
        height: 150px; /* Ajusta la altura deseada */
        object-fit: cover; /* Mantiene el recorte de la imagen */
        border-radius: 0.5rem;
        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
    }
    .gallery-item .overlay {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: rgba(0, 0, 0, 0.6);
        color: white;
        opacity: 0;
        transition: opacity 0.3s ease;
        display: flex;
        justify-content: center;
        align-items: center;
        text-align: center;
        border-radius: 0.5rem;
    }
    .gallery-item:hover .overlay {
        opacity: 1;
    }
    .overlay p {
        font-size: 1rem;
    }
    .overlay small {
        font-size: 0.8rem;
    }
    .gallery-container {
        display: flex;
        flex-wrap: wrap;
    }
</style>



<div class="container mt-5">
    <!-- Sección para agregar una nueva foto -->
    <div class="card mb-4 border-primary">
        <div class="card-header text-primary border-primary">
            <h5>Agregar Evidencia Fotográfica</h5>
        </div>
        <div class="card-body">
            <form id="photoForm">
                <div class="input-group">
                    <!-- Descripción de la foto -->
                    <span class="input-group-text">
                        <i class="fa fa-pencil"></i> <!-- Ícono de lápiz -->
                    </span>
                    <input type="text" class="form-control" id="photoDescription" placeholder="Descripción de la imagen">

                    <!-- Selector de archivo -->
                    <span class="input-group-text">
                        <i class="fa fa-upload"></i> <!-- Ícono de carga de archivo -->
                    </span>
                    <input type="file" class="form-control" id="photoUpload">

                    <!-- Botón de agregar foto -->
                    <span class="input-group-btn">
                        <button type="button" class="btn btn-outline-primary" onclick="agregarFoto()">
                            <i class="fa fa-plus-circle"></i> <!-- Ícono de agregar -->
                            Agregar Foto
                        </button>
                    </span>
                </div>
            </form>
        </div>
    </div>
	
	
<div id="imageModal" class="modal">
    <span class="close" onclick="closeModal()">&times;</span>
    <img class="modal-content" id="modalImage" alt="Imagen en tamaño real">
</div>

    <!-- Galería agrupada por fecha -->
    <div id="groupedGallery"></div>
</div>


<script>
const datos = <?php echo json_encode($datosFotos);?>;
// Dirección base del servidor para completar las rutas relativas

// Generar el arreglo fotosEvidencia
const fotosEvidencia = datos.map(item => {
    return {
        descripcion: item.Observaciones,
        fecha: item.Fecha.split(" ")[0], // Tomar solo la fecha en formato "YYYY-MM-DD"
        imgUrl: item.Datos // Mantener la URL en su formato original
    };
}); 

    // Función para cargar las fotos agrupadas por fecha
  function cargarFotosPorFecha() {
        const groupedGallery = document.getElementById('groupedGallery');
        groupedGallery.innerHTML = '';  // Asegura que esté vacío antes de cargar nuevas imágenes
        const fotosAgrupadas = agruparFotosPorFecha(fotosEvidencia);

        Object.keys(fotosAgrupadas).forEach(fecha => {
            const fotos = fotosAgrupadas[fecha];
			console.log(fotos);
           const cardHtml = `
    <div class="card mb-4">
        <div class="card-header text-white bg-light">
            <h5>${fecha}</h5>
        </div>
        <div class="card-body">
            <div class="gallery-container">
                ${fotos.map(foto => `
                    <div class="gallery-item" onclick="openModal('${limpiarUrl(foto.imgUrl)}')">

                        <div class="image-wrapper">
                            <img src="${foto.imgUrl}" alt="Evidencia Fotográfica" loading="lazy">
                        </div>
                        <div class="overlay">
                            <div>
                                <p>${foto.descripcion}</p>
                                <small>Fecha: ${fecha}</small>
                            </div>
                        </div>
                    </div>
                `).join('')}
            </div>
        </div>
    </div>
`;
			
 groupedGallery.insertAdjacentHTML('beforeend', cardHtml);
        });
    }

    // Función para abrir el modal y mostrar la imagen en tamaño completo
function openModal(imgUrl) {
	alert(imgUrl);
    const modal = document.getElementById("imageModal");
    const modalImage = document.getElementById("modalImage");

    modalImage.src = imgUrl; // Asigna la nueva URL
    modal.style.display = "block"; // Muestra el modal
}

function closeModal() {
    const modal = document.getElementById("imageModal");
    modal.style.display = "none";
}


    // Cerrar el modal si se hace clic fuera de la imagen
 window.onclick = function(event) {
    const modal = document.getElementById("imageModal");
    if (event.target === modal) {
        closeModal();
    }
};
	
	const limpiarUrl = (url) => {
    return url.replace(/[\r\t]/g, '').trim();
};


    // Función para agrupar fotos por fecha
    function agruparFotosPorFecha(fotos) {
        return fotos.reduce((group, foto) => {
            const { fecha } = foto;
            if (!group[fecha]) {
                group[fecha] = [];
            }
            group[fecha].push(foto);
            return group;
        }, {});
    }

    // Función para agregar nuevas fotos
	var obser;
    function agregarFoto() {
        const descripcion = document.getElementById('photoDescription').value;
        const archivo = document.getElementById('photoUpload').files[0];
		obser=descripcion;

        if (!descripcion || !archivo) {
            alert("Debe agregar una descripción y seleccionar una imagen.");
            return;
        }
		subirFoto( archivo);
        const reader = new FileReader();
        reader.onload = function(event) {
            const nuevaFoto = {
                descripcion: descripcion,
                fecha: new Date().toISOString().split('T')[0],
                imgUrl: event.target.result
            };
            fotosEvidencia.push(nuevaFoto);
            document.getElementById('groupedGallery').innerHTML = ''; // Limpiar la galería
            cargarFotosPorFecha(); // Recargar la galería con la nueva foto
        };
        reader.readAsDataURL(archivo);

        // Limpiar el formulario
        document.getElementById('photoForm').reset();
    }

    // Cargar las fotos agrupadas al cargar la página
    window.onload = function() {
        cargarFotosPorFecha();
    };
	
	 // Función AJAX para subir la foto
    function subirFoto(archivo) {
		var formData = new FormData();
        var files = archivo;

        formData.append('file', files);

            $.ajax({
            url: 'http://167.172.224.160/MiSi/librerias/ajax/ajaxUpArchivo.php?tconff=<?php echo $tconf;?>',
            type: 'post',
            data: formData,
            contentType: false,
            processData: false,
            success: function(response) { 
				
                if (response != 0) {
					//alert("ok");
					// Ruta relativa
					console.log(response);
					guardar(response, obser);
					alert(response);  
					setTimeout(function() {location.reload();}, 1500);
                 
                } else {
                    alert('Formato de imagen incorrecto.');
                }
            }
        });

        return false;
    

        
    }
<?php 
    $urlajaxUpdate= "http://167.172.224.160/MiSi/librerias/ajaxAPP/ajaxSimple.php";
?>

	 // Función guardar para enviar el JSON serializado
    function guardar(json, obs) {
		alert(json);
        var datos = {
            IDU: <?php echo $iduul; ?> + "",
            IDC: <?php echo $idPaciente; ?> + "",
            Tipo: "Foto",
            Observaciones: obs,
        	Datos:json,
            Token: "<?php echo bin2hex(openssl_random_pseudo_bytes(4)); ?>",
            Conjunto_A: "1",
            Conjunto_B: "2"
        };

        var valores = JSON.stringify(datos);

        var formData = {
            id: 0,
            valores: valores, 
            funcion: "insert"
        };

        $.ajax({
            url: '<?php echo $urlajaxUpdate; ?>',
            type: 'POST',
            data: formData,
            success: function(response) {
                $("#Mensaje").html('<div class="alert alert-success alert-dismissible alert-alt fade show"><button type="button" class="close h-100" data-dismiss="alert" aria-label="Close"><span><i class="mdi mdi-close"></i></span></button><strong>Listo </strong> Se actualizo correctamente.</div>');
                setTimeout(function() { $('#Mensaje').empty(); }, 2000);
                console.log(response);
                //setTimeout(function() { location.reload(); }, 3000);
            },
            error: function(error) {
                console.error('Error al enviar datos al servidor:', error);
            }
        });
    }



</script>


