
    <style>
        .col-cantidad { width: 10%; }
        .col-precio { width: 15%; }
        .col-total { width: 15%; }
        .col-descripcion { width: 50%; }
        .table th, .table td { vertical-align: middle; }
        .form-control, .select2-selection { border-radius: 8px; }
        .highlight { background-color: #f1f8ff; border-radius: 5px; }
        .total-input { font-weight: bold; color: #007bff; border: 2px solid #007bff; }
        .action-buttons { display: flex; gap: 10px; }
        .footer-summary { padding: 10px; background: #f8f9fa; border-radius: 5px; }
    </style>
<div class="row page-titles mx-0">
<div class="container mt-5">
    <h2 class="text-center mb-4">Cotizador</h2>
    <div class="table-responsive">
        <table class="table table-bordered" id="cotizadorTable">
            <thead class="thead-light">
                <tr>
                    <th class="col-cantidad text-center">Cantidad</th>
                    <th class="col-descripcion text-center">Descripción</th>
                    <th class="col-precio text-center">Precio Unitario</th>
                    <th class="col-total text-center">Total</th>
                    <th class="text-center">Acciones</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td><input type="number" class="form-control cantidad" onchange="actualizarTotal(this)" min="1" value="1"></td>
                    <td>
                        <select class="form-control descripcion select2" onchange="actualizarPrecio(this)" title="Seleccione una descripción">
                            <option value="">Seleccione una opción</option>
                        </select>
                    </td>
                    <td><input type="number" class="form-control precio" onchange="actualizarTotal(this)" min="0" step="0.01" readonly></td>
                    <td><input type="number" class="form-control total" readonly></td>
                    <td class="text-center"><button type="button" class="btn btn-danger" onclick="eliminarFila(this)"><i class="fa fa-times-circle-o" aria-hidden="true"></i></button></td>
                </tr>
            </tbody>
            <tfoot>
                <tr class="footer-summary">
                    <td><button type="button" class="btn btn-primary" onclick="agregarFila()"><i class="fa fa-plus-circle" aria-hidden="true"></i></button></td>
                    <td colspan="2" class="text-right font-weight-bold">Gran Total:</td>
                    <td><input type="number" class="form-control total-input" id="granTotal" readonly></td>
                    <td></td>
                </tr>
            </tfoot>
        </table>
    </div>
    <div class="text-right mt-4">
        <button type="button" class="btn btn-success" onclick="guardarCotizacion()">Guardar Cotización</button>
    </div>
</div></div>

<?php 
    $urlajaxUpdate= "http://167.172.224.160/MiSi/librerias/ajaxAPP/ajaxSimple.php";
 
	//print_r($datosCatalogo);
// Convertir el arreglo PHP a JSON
	$datosJson = json_encode($datosCatalogo, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
?>
<script>
    // Asignar el JSON generado desde PHP a la constante
    const opcionesDescripcion = <?php echo $datosJson; ?>;

    // Imprimir para verificar que se asignó correctamente
    console.log(opcionesDescripcion);

    function inicializarSelect2(elemento) {
    $(elemento).select2({
        data: opcionesDescripcion.map(opcion => ({ 
            id: opcion.id, 
            text: opcion.descripcion,
            precio: parseFloat(opcion.precio) // Asegúrate de convertirlo a número
        })),
        placeholder: "Seleccione una opción",
        width: '100%'
    });
}


    function agregarFila() {
        const nuevaFila = `
            <tr class="highlight">
                <td><input type="number" class="form-control cantidad" onchange="actualizarTotal(this)" min="1" value="1"></td>
                <td><select class="form-control descripcion select2" onchange="actualizarPrecio(this)"><option value="">Seleccione una opción</option></select></td>
                <td><input type="number" class="form-control precio" onchange="actualizarTotal(this)" min="0" step="0.01" readonly></td>
                <td><input type="number" class="form-control total" readonly></td>
                <td class="text-center"><button type="button" class="btn btn-danger" onclick="eliminarFila(this)"><i class="fa fa-times-circle-o" aria-hidden="true"></i></button></td>
            </tr>`;
        $('#cotizadorTable tbody').append(nuevaFila);
        inicializarSelect2($('#cotizadorTable tbody tr:last .descripcion'));
    }

    function actualizarPrecio(elemento) {
        const selectedOption = $(elemento).select2('data')[0];
        const fila = $(elemento).closest('tr');
        const precio = selectedOption ? selectedOption.precio : 0;
        fila.find('.precio').val(precio.toFixed(2));
        actualizarTotal(elemento);
    }

    function actualizarTotal(elemento) {
        const fila = $(elemento).closest('tr');
        const cantidad = parseFloat(fila.find('.cantidad').val()) || 0;
        const precio = parseFloat(fila.find('.precio').val()) || 0;
        const total = cantidad * precio;
        fila.find('.total').val(total.toFixed(2));
        actualizarGranTotal();
    }

    function actualizarGranTotal() {
        let granTotal = 0;
        $('#cotizadorTable tbody .total').each(function() {
            granTotal += parseFloat($(this).val()) || 0;
        });
        $('#granTotal').val(granTotal.toFixed(2));
    }

    function eliminarFila(button) {
        $(button).closest('tr').remove();
        actualizarGranTotal();
    }

    function guardarCotizacion() {
        const cotizacion = [];
        $('#cotizadorTable tbody tr').each(function() {
            const fila = $(this);
            const cantidad = parseFloat(fila.find('.cantidad').val()) || 0;
            const descripcionId = fila.find('.descripcion').val();
            const descripcionText = fila.find('.descripcion option:selected').text();
            const precio = parseFloat(fila.find('.precio').val()) || 0;
            const total = parseFloat(fila.find('.total').val()) || 0;

            if (descripcionId) {
                cotizacion.push({
                    id: descripcionId,
                    descripcion: descripcionText,
                    cantidad: cantidad,
                    precio_unitario: precio,
                    total: total
                });
            }
        });
		var cot=JSON.stringify(cotizacion);
        console.log(cot);
 
       guardar(cot); 
    }

    $(document).ready(function() {
        inicializarSelect2($('.descripcion'));
    });
	
	
	    // Función guardar para enviar el JSON serializado
    function guardar(json) {
        var datos = {
            IDU: <?php echo $iduul; ?> + "",
            IDC: <?php echo $idPaciente; ?> + "",
            Tipo: "Cotizacion",
            Observaciones: "-",
        	Datos: json,
            Token: "<?php echo bin2hex(openssl_random_pseudo_bytes(4)); ?>",
            Conjunto_A: "1",
            Conjunto_B: "2"
        };

        var valores = JSON.stringify(datos);
		//console.log(valores); 
        var formData = {
            id: 0,
            valores: valores, 
            funcion: "insert"
        };

        $.ajax({
            url: '<?php echo $urlajaxUpdate; ?>',
            type: 'POST',
            data: formData,
            success: function(response) {
                $("#Mensaje").html('<div class="alert alert-success alert-dismissible alert-alt fade show"><button type="button" class="close h-100" data-dismiss="alert" aria-label="Close"><span><i class="mdi mdi-close"></i></span></button><strong>Listo </strong> Se actualizo correctamente.</div>');
                setTimeout(function() { $('#Mensaje').empty(); }, 2000);
                console.log(response);
               // setTimeout(function() { location.reload(); }, 3000);
            },
            error: function(error) {
                console.error('Error al enviar datos al servidor:', error);
            }
        });
    }
</script>

