<!-- Estilos y formulario existentes -->
<style>
  .container {
    max-width: 900px;
  }
  .form-label {
    font-weight: 600;
  }
  /* Para que el textarea crezca según cantidad de líneas */
  #series {
    resize: vertical;
    min-height: 60px;
  }
  /* Para tabla con scroll horizontal */
  .table-responsive {
    overflow-x: auto;
  }
  /* Cursor pointer para filas clickeables */
  .cursor-pointer {
    cursor: pointer;
  }
  /* Ajuste botón pequeño */
  #formProducto button[type="submit"] {
    padding: 0.375rem 0.6rem;
    font-size: 1.25rem;
  }
</style>

<div class="container py-4">

 <h4 class="mb-3">Proveedor</h4>
<div class="row g-3 align-items-end mb-4">
  <div class="col-md-4">
    <label class="form-label" for="nombreProveedor">Nombre del Proveedor</label>
    <input type="text" class="form-control" id="nombreProveedor" placeholder="Nombre completo" required>
  </div>
  <div class="col-md-4">
    <label class="form-label" for="numeroFactura">Número de Factura</label>
    <input type="text" class="form-control" id="numeroFactura" placeholder="Ej. F123456" required>
  </div>
  <div class="col-md-4">
    <label class="form-label" for="fechaCompra">Fecha de Compra</label>
    <input type="date" class="form-control" id="fechaCompra" required>
  </div>
</div>

      
<h4 class="mb-3">Agregar</h4>
 <form id="formProducto" class="d-flex gap-2 mb-3 align-items-end">
  <!-- ID Producto con botón -->
  <div class="input-group" style="width: 25%;">
    <span class="input-group-text">ID</span>
    <input type="text" class="form-control" id="idProducto" placeholder="ID Producto" required readonly>
    <button type="button" class="btn btn-outline-secondary" onclick="abrirCatalogo()" title="Buscar producto">🔍</button>
  </div>

  <!-- Cantidad -->
  <div class="input-group" style="width: 20%;">
    <span class="input-group-text">#</span>
    <input type="number" class="form-control" id="cantidad" placeholder="Cantidad" min="1" required>
  </div>

  <!-- Costo -->
  <div class="input-group" style="width: 20%;">
    <span class="input-group-text">$</span>
    <input type="number" class="form-control" id="costo" placeholder="Costo" min="0" step="0.01" required>
  </div>

  <!-- Series -->
  <div class="input-group" style="width: 35%;">
    <span class="input-group-text">N/S</span>
    <textarea class="form-control" id="series" placeholder="Uno por línea" rows="1" required></textarea>
  </div>

  <!-- Botón Agregar -->
  <div style="width: 5%;">
    <button type="submit" class="btn btn-primary w-100">+</button>
  </div>
</form>


  <h4 class="mb-3">Productos Agregados</h4>
  <div class="table-responsive mb-3">
    <table class="table table-bordered table-hover" id="tablaProductos" style="min-width: 650px;">
      <thead class="table-secondary">
        <tr>
          <th>ID</th>
          <th>Cantidad</th>
          <th>Costo</th>
          <th>Series</th>
          <th>Total</th>
          <th>Acción</th>
        </tr>
      </thead>
      <tbody></tbody>
    </table>
  </div>

  <form method="post" onsubmit="return prepararCompraFinal();" class="text-end">
    <input type="hidden" name="productos_json" id="productos_json">
    <button type="submit" class="btn btn-success" id="btnFinalizar" disabled>Finalizar Compra</button>
  </form>

  <!-- MODAL DE CATÁLOGO -->
  <div class="modal fade" id="modalCatalogo" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">Catálogo de Productos</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
        </div>
        <div class="modal-body">
          <input type="text" id="busquedaCatalogo" class="form-control mb-3" placeholder="Buscar producto por ID o descripción..." oninput="filtrarCatalogo()">
          <div class="table-responsive">
            <table class="table table-hover mb-0">
              <thead>
                <tr>
                  <th>IDCa</th>
                  <th>Descripción</th>
                </tr>
              </thead>
              <tbody id="tablaCatalogo">
                <!-- Productos se insertan aquí -->
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>


<!-- Scripts -->

<script>
	let productos = [];

const catalogo = [
  { id: "P1001", descripcion: "Monitor 24 pulgadas" },
  { id: "P1002", descripcion: "Teclado mecánico RGB" },
  { id: "P1003", descripcion: "Laptop i7 16GB RAM" },
  { id: "P1004", descripcion: "Mouse inalámbrico" },
  { id: "P1005", descripcion: "Impresora multifunción" },
  { id: "P2001", descripcion: "Cable HDMI 2m" },
  { id: "P2002", descripcion: "Base para laptop metálica" }
];

let modalCatalogo = new bootstrap.Modal(document.getElementById('modalCatalogo'));

function abrirCatalogo() {
  document.getElementById("busquedaCatalogo").value = "";
  filtrarCatalogo(); // Renderiza el catálogo sin filtro
  modalCatalogo.show();
}

function filtrarCatalogo() {
  const filtro = document.getElementById("busquedaCatalogo").value.toLowerCase();
  const tbody = document.getElementById("tablaCatalogo");
  tbody.innerHTML = "";

  catalogo
    .filter(p => 
      p.id.toLowerCase().includes(filtro) || 
      p.descripcion.toLowerCase().includes(filtro)
    )
    .forEach(prod => {
      const row = `<tr class="cursor-pointer" onclick="seleccionarProducto('${prod.id}')">
        <td>${prod.id}</td>
        <td>${prod.descripcion}</td>
      </tr>`;
      tbody.insertAdjacentHTML("beforeend", row);
    });
}


function seleccionarProducto(id) {
  document.getElementById("idProducto").value = id;
  modalCatalogo.hide();
}

document.getElementById("formProducto").addEventListener("submit", function(e) {
  e.preventDefault();
  const id = document.getElementById("idProducto").value.trim();
  const cantidad = parseInt(document.getElementById("cantidad").value);
  const costo = parseFloat(document.getElementById("costo").value);
  const series = document.getElementById("series").value.trim().split('\n').map(s => s.trim()).filter(s => s);

  if (series.length !== cantidad) {
    alert("La cantidad debe coincidir con el número de series ingresadas.");
    return;
  }

  productos.push({ id, cantidad, costo, series });
  renderTabla();
  this.reset();
});

function renderTabla() {
  const tbody = document.querySelector("#tablaProductos tbody");
  tbody.innerHTML = "";
  productos.forEach((p, index) => {
    const row = `<tr>
      <td>${p.id}</td>
      <td>${p.cantidad}</td>
      <td>$${p.costo.toFixed(2)}</td>
      <td>${p.series.join(", ")}</td>
      <td>$${(p.cantidad * p.costo).toFixed(2)}</td>
      <td><button class="btn btn-danger btn-sm" onclick="eliminar(${index})">Eliminar</button></td>
    </tr>`;
    tbody.insertAdjacentHTML("beforeend", row);
  });
  document.getElementById("btnFinalizar").disabled = productos.length === 0;
}

function eliminar(index) {
  productos.splice(index, 1);
  renderTabla();
}
var cantidadTotal;
var costoTotal;
function prepararCompraFinal() {
  // Validar campos del proveedor
  const nombreProveedor = document.getElementById("nombreProveedor").value.trim();
  const numeroFactura = document.getElementById("numeroFactura").value.trim();
  const fechaCompra = document.getElementById("fechaCompra").value;

  if (!nombreProveedor || !numeroFactura || !fechaCompra) {
    alert("Por favor completa todos los datos del proveedor.");
    return false;
  }

  // Calcular resumen
   cantidadTotal = productos.reduce((sum, p) => sum + p.cantidad, 0);
   costoTotal = productos.reduce((sum, p) => sum + p.cantidad * p.costo, 0);

  // Estructura de salida
  const compra = {
    proveedor: {
      nombre: nombreProveedor,
      factura: numeroFactura,
      fecha: fechaCompra
    },
    resumen: {
      cantidad_total: cantidadTotal,
      costo_total: costoTotal,
      estado: "Comprado"
    },
    productos: productos
  };

  // Guardar en campo oculto
  document.getElementById("productos_json").value = JSON.stringify(productos);

  // Mostrar en consola
  console.log("=== COMPRA REGISTRADA ===");
  console.log(JSON.stringify(compra, null, 2));

  // Ahora mandamos cantidadTotal y costoTotal a ACompra
  ACompra(0, JSON.stringify(compra, null, 2), cantidadTotal, costoTotal);

  return false; // evita la recarga
}
	
function ACompra(id, Datos) {

 //INSERT INTO `MicroSi_Datos`.`61-Compras` (`IDL`, `IDP`, `IDCa`, `Descripcion`, `Cantidad`, `Precio`, `Total`, `Estado`, `Datos`, `Token`, `Conjunto_A`) VALUES ('1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '');
 const formData = {
    id: 0,
    IDL: "<?php echo $IDLs; ?>",
	IDP:0,
    IDCa: 0,
    Descripcion: "Compra",
    Cantidad: cantidadTotal,
	Precio: 0,
	Total: costoTotal, 
    Estado: "Comprado",
	Datos: Datos,
    Token: "<?php echo bin2hex(openssl_random_pseudo_bytes(4)); ?>",
    Vector: "0", 
    funcion: "insertS"
  };

  const urlajaxUpdate = "http://167.172.224.160/MiSi/librerias/ajaxAPP/ajaxSimple.php";

  $.ajax({
    url: urlajaxUpdate,
    type: 'POST',
    data: formData,
    success: function (response) {
      console.log("Respuesta del crÃ©dito:", response);
    },
    error: function (error) {
      console.error('Error al registrar crÃ©dito:', error);
    }
  });

	
}	
	
	
</script>
