
    <style>
        body {
            font-family: 'Inter', sans-serif;
            background-color: #f8f9fa;
        }
        .container {
            max-width: 1200px;
            margin: 30px auto;
        }
        h2 {
            font-weight: 600;
            margin-bottom: 20px;
            color: #343a40;
        }
        .search-bar {
            background: #ffffff;
            border: 1px solid #dee2e6;
            border-radius: 8px;
            box-shadow: 0px 2px 5px rgba(0, 0, 0, 0.1);
            padding: 15px;
            display: flex;
            align-items: center;
            margin-bottom: 20px;
        }
        .search-bar i {
            margin-right: 10px;
            color: #6c757d;
        }
        .search-bar input {
            border: none;
            outline: none;
            flex-grow: 1;
        }
        .search-bar input::placeholder {
            color: #6c757d;
        }
        .table-container {
            background: #ffffff;
            border-radius: 12px;
            box-shadow: 0px 4px 8px rgba(0, 0, 0, 0.1);
            overflow: hidden;
        }
        .table {
            margin-bottom: 0;
        }
        .table thead {
            background: #495057;
            color: #ffffff;
        }
        .table-hover tbody tr:hover {
            background: #e9ecef;
        }
        .color-box {
            display: inline-block;
            width: 20px;
            height: 20px;
            border-radius: 50%;
            border: 1px solid #000;
        }
        .btn {
            border-radius: 50px;
            transition: all 0.2s ease-in-out;
        }
        .btn:hover {
            transform: scale(1.05);
        }
        .btn-success {
            background-color: #28a745;
            border-color: #28a745;
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Título -->
        <h2 class="text-center"><i class="fas fa-calendar-alt"></i> Recordatorios</h2>
        
        <!-- Barra de búsqueda -->
        <div class="search-bar">
            <i class="fas fa-search"></i>
            <input id="searchInput" type="text" placeholder="Buscar por título, cliente o doctor...">
        </div>
        
        <!-- Tabla -->
        <div class="table-container">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th><i class="fas fa-file-alt"></i> Título</th>
                        <th><i class="fas fa-user"></i> Cliente</th>
                        <th><i class="fas fa-user-md"></i> Doctor</th>
                        <th><i class="fas fa-clock"></i> Inicio</th>
                        <th><i class="fas fa-hourglass"></i> Duración</th>
                        <th><i class="fas fa-check-circle"></i> Estado</th>
                        <th><i class="fas fa-palette"></i> </th>
                        <th><i class="fas fa-comment"></i> Acción</th>
                    </tr>
                </thead>
                <tbody id="recordTable">
                    <?php foreach ($Agenda as $evento): ?>
                    <tr>
                        <td><?= htmlspecialchars($evento['Horario_Titulo']) ?></td>
                        <td><?= htmlspecialchars($evento['Cliente_Nombre']) ?></td>
                        <td><?= htmlspecialchars($evento['Loggin_Nombre']) ?></td>
                        <td><?= htmlspecialchars($evento['Horario_Inicio']) ?></td>
                        <td><?= htmlspecialchars($evento['Horario_Fin']) ?> minutos</td>
                        <td><?= htmlspecialchars($evento['Horario_Estado']) ?></td>
                        <td>
                            <span class="color-box" style="background-color: <?= htmlspecialchars($evento['Horario_Color']) ?>;">
                        </td>
                        <td>


<a href="https://wa.me/<?= urlencode($evento['Cliente_Telefono']) ?>?text=<?= urlencode(
    $mensaje_base . ' ' . 
    'Evento: ' . $evento['Horario_Titulo'] . 
    ' - Cliente: ' . $evento['Cliente_Nombre'] . 
    ' - Doctor: ' . $evento['Loggin_Nombre'] . 
    ' - Inicio: ' . $evento['Horario_Inicio'] . 
    ' (' . $evento['Horario_Fin'] . ' minutos)'
) ?>" class="btn btn-success btn-sm">
    <i class="fa fa-whatsapp"></i> 
</a>


                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- JavaScript -->
    <script>
        // Filtro interactivo
        document.getElementById('searchInput').addEventListener('keyup', function () {
            let filter = this.value.toLowerCase();
            let rows = document.querySelectorAll('#recordTable tr');
            rows.forEach(row => {
                let text = row.innerText.toLowerCase();
                row.style.display = text.includes(filter) ? '' : 'none';
            });
        });
    </script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.0/js/bootstrap.bundle.min.js"></script>

