<?php
session_start();

$opciones = json_decode($json, true);
$opcionesDefault = json_decode($jsonDefault, true);

?>

<?php foreach ($opciones as $nombre_arreglo => $arreglo) : ?>

<form id="formularioOpciones<?php echo $nombre_arreglo; ?>">
    <div class="row page-titles mx-0">
        <div class="col-sm-6 p-md-0">
            <div class="welcome-text">
                <h4><?php echo $nombre_arreglo;?></h4>
                <span class="ml-1">Selecciona una de las opciones de <?php echo $nombre_arreglo; ?>.</span>
            </div>
            <h5 class="mb-3"></h5>
            <div class="btn-group btn-group-toggle ml-auto" data-toggle="buttons">
                <?php foreach ($arreglo as $opcion) : ?>
                    <?php
                    $labelClasses = 'btn';
                    $inputClasses = 'checked';
                    if ($opcion['seleccionado']) {
                        $labelClasses .= ' btn-primary active';
                    } else {
                        $labelClasses .= ' btn-outline-transparent';
                        $inputClasses = '';
                    }
                    ?>
                    <label class="<?php echo $labelClasses; ?>">
                        <input type="radio" name="opcion_seleccionada_<?php echo $nombre_arreglo; ?>" value="<?php echo $opcion['id']; ?>" autocomplete="off" class="<?php echo $inputClasses; ?>">
                        <i class="<?php echo $opcion['icono']; ?> fa-5x"></i>
                        <span class="d-block"><?php echo $opcion['nombre']; ?></span>
                    </label>
                <?php endforeach; ?>
            </div>
        </div>
        <div class="col-sm-6 p-md-0 justify-content-end mt-2 mt-sm-0 d-flex">
            <button type="button" class="btn btn-success ml-2"  id="botonGuardar_<?php echo $nombre_arreglo; ?>" style="display: none;" onclick="guardarOpciones('<?php echo $nombre_arreglo; ?>')">
                <i class="fa fa-save fa-5x"></i> <span class="d-block">Guardar.</span>
            </button>
        </div>
    </div>
</form>

<?php endforeach; ?>

<!-- Botón "Configuración Default" fuera del formulario -->
<div class="row justify-content-end mt-2">
    <div class="col-sm-6 p-md-0 justify-content-end mt-2 mt-sm-0 d-flex">
        <button type="button" class="btn btn-danger ml-2" onclick="configuracionDefault()">
            <i class="fa fa-cog"></i> <span class="d-block">Configuración Default</span>
        </button>
    </div>
</div>

<script>
// Función para guardar opciones
function guardarOpciones(nombre_arreglo) {
    var opcionSeleccionada = document.querySelector('input[name="opcion_seleccionada_' + nombre_arreglo + '"]:checked');
    if (opcionSeleccionada !== null) {
        var opcionId = opcionSeleccionada.value;

        // Obtener las opciones correspondientes al nombre del arreglo
        var opciones = <?php echo json_encode($opciones); ?>;
        opciones[nombre_arreglo].forEach(function(opcion) {
            opcion.seleccionado = (opcion.id === opcionId);
        });

        // Actualizar el JSON en el navegador
        var json = JSON.stringify(opciones);

        // Puedes hacer lo que necesites con el nuevo JSON, como enviarlo a través de una solicitud AJAX o simplemente mostrarlo en la consola
        console.log(json);

        guardarConfiguracion(json);
    } else {
        console.log("Debe seleccionar una opción antes de guardar.");
    }
}

function ocultarBotonGuardar(nombre_arreglo) {
    $('#botonGuardar_' + nombre_arreglo).hide();
}

function mostrarBotonGuardar(nombre_arreglo) {
    $('#botonGuardar_' + nombre_arreglo).show();
}

function actualizarBotonGuardar(nombre_arreglo) {
    var opcionSeleccionada = $('input[name="opcion_seleccionada_' + nombre_arreglo + '"]:checked').length > 0;
    if (opcionSeleccionada) {
        mostrarBotonGuardar(nombre_arreglo);
    } else {
        ocultarBotonGuardar(nombre_arreglo);
    }
}

$(document).ready(function() {
    <?php foreach ($opciones as $nombre_arreglo => $arreglo) : ?>
        ocultarBotonGuardar('<?php echo $nombre_arreglo; ?>');
    <?php endforeach; ?>
    
    $('input[name^="opcion_seleccionada_"]').change(function() {
        var nombre_arreglo = $(this).attr('name').replace('opcion_seleccionada_', '');
        actualizarBotonGuardar(nombre_arreglo);
    });
});
	
	
	// Función para manejar la configuración default
function configuracionDefault() {
    // Preguntar al usuario si está seguro de establecer la configuración predeterminada
    var confirmacion = confirm("¿Estás seguro de establecer la configuración predeterminada?");
    
    // Si el usuario confirma, proceder con la configuración predeterminada
    if (confirmacion) {
        // Aquí implementa la lógica para establecer la configuración predeterminada
        console.log("Configuración predeterminada");
        
        var opciones = <?php echo json_encode($opcionesDefault); ?>;
        var json = JSON.stringify(opciones);
        console.log(json);
        guardarConfiguracion(json);
    } else {
        console.log("Configuración predeterminada cancelada.");
    }
}
	
	function guardarConfiguracion(json) {
    // Convertir el objeto JSON a una cadena JSON
    var jsonString = JSON.stringify(json);

    // Realizar la solicitud AJAX
    $.ajax({
        url: "<?php echo $urlajaxeditarproductos; ?>",
        type: 'POST',
        data: { json: jsonString }, // Pasar la cadena JSON como valor de la clave "json"
        success: function(response) {
            console.log(response);
            //location.reload();
        },
        error: function(error) {
            console.log('Error en la solicitud AJAX:', error);
        }
    });

    // Convertir el JSON de texto a objeto
    var opciones = JSON.parse(json);

    // Obtener la ID de la impresora seleccionada
    let idImpresoraSeleccionada = null;
    let SImpresora = null;

    if (opciones.Impresora) {
        opciones.Impresora.forEach((impresora) => {
            if (impresora.seleccionado) {
                idImpresoraSeleccionada = impresora.id;
                switch (idImpresoraSeleccionada) {
                    case 'impresora2':
                        SImpresora = 'Ticket_Nota_Virtual';
                        break;
                    case 'impresora3':
                        SImpresora = '12Nota_Vertical';
                        break;
                    case 'impresora4':
                        SImpresora = '12Nota_Horizontal';
                        break;
                    default:
                        SImpresora = 'No definida';
                }
            }
        });
    }

		
	   // Datos a enviar al servidor
    var formData = {
		id: 0,
        column: "Impresora",
        value: SImpresora,         
        funcion: "updateGET"
    };

    // AJAX para enviar los datos al servidor 
    $.ajax({
        url: '<?php echo $urlajaxUpdate; ?>', // Reemplaza con la ruta correcta a tu script del servidor
        type: 'POST',
        data: formData,
        success: function(response) {
            // Maneja la respuesta del servidor
			$("#Mensaje").html(' <div class="alert alert-success alert-dismissible alert-alt fade show"><button type="button" class="close h-100" data-dismiss="alert" aria-label="Close"><span><i class="mdi mdi-close"></i></span></button><strong>Listo </strong> Se actualizo correctamente.</div>');
			setTimeout(function() {$('#Mensaje').empty();}, 2000);
			setTimeout(function() {location.reload();}, 1000);
            console.log(response);
        },
        error: function(error) {
            console.error('Error al enviar datos al servidor:', error);
        }
    });	
		
		
    console.log("ID de la impresora seleccionada:", idImpresoraSeleccionada);
    console.log("Impresora seleccionada:", SImpresora);
}


</script>
