<?php
session_start();
$clientes_json = json_encode( $clientes );
?>
<div class="row page-titles mx-0">
  <div class="col-sm-12 p-md-0">
    <div class="welcome-text">
      <h4><?php echo $_SESSION["BarraBuscarTitulo"]; ?></h4>
      <span class="ml-1"><?php echo $_SESSION["BarraBuscarSTitulo"]; ?></span> </div>
    <table class="table table-borderless" id="clienteTable" style="display:none;">
      <tbody>
        <tr id="clienteInfo">
          <td width="1"><i class="fa fa-id-card"></i></td>
          <td id="clienteID"></td>
          <td width="1"><i class="fa fa-user"></i></td>
          <td id="clienteNombre"></td>
          <td width="1"><i class="fa fa-phone"></i></td>
          <td id="clienteTelefono"></td>
        </tr>
      </tbody>
    </table>
  </div>
  <div class="col-sm-12 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
    <div class="input-group">
      <input id="searchInput" type="text" class="form-control" placeholder="Buscar clientes...">
      <div class="input-group-append">
        <button id="nextButton" class="btn btn-primary" type="button"><i class="fa fa-arrow-right"></i></button>
      </div>
      <div class="input-group-append">
        <button id="addButton" class="btn btn-primary" type="button" data-toggle="modal" data-target="#modalAgregarClienteDinamico"><i class="fa fa-plus"></i></button>
        <button id="infoButton" class="btn btn-outline-dark" type="button" data-toggle="modal" data-target="#tablaModal"> <i class="fa fa-search"></i> </button>
      </div>
    </div>
  </div>
</div>

<!-- Modal para agregar un nuevo cliente (dinámico) -->
<div class="modal" id="modalAgregarClienteDinamico" tabindex="-1" role="dialog" aria-labelledby="modalAgregarClienteDinamicoLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="modalAgregarClienteDinamicoLabel">Agregar Nuevo Cliente</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"> <span aria-hidden="true">&times;</span> </button>
      </div>
      <div class="modal-body"> 
        <!-- Formulario para agregar nuevo cliente (dinámico) -->
        <form id="formAgregarClienteDinamico">
          <?php foreach ($camposCliente as $campo): ?>
          <div class="form-group">
            <label for="<?php echo $campo[0]; ?>"><?php echo $campo[1]; ?>:</label>
            <input type="<?php echo $campo[2]; ?>" class="form-control" id="<?php echo $campo[0]; ?>" name="<?php echo $campo[1]; ?>" required>
          </div>
          <?php endforeach; ?>
          <button type="button" class="btn btn-success" onclick="agregarNuevoClienteDinamico()"> <i class="fa fa-plus"></i> <!-- Icono de agregar persona de Bootstrap --> 
          Agregar Cliente </button>
        </form>
      </div>
    </div>
  </div>
</div>
<script>
	var idseleccionado="";
    var catalogoClientes = <?php echo $clientes_json; ?>;

	function mostrarInformacion() {
    // Aquí puedes implementar la lógica para mostrar la información
    // Por ejemplo, puedes abrir un modal con los detalles de la información
    alert("Información adicional");
}

  $(document).ready(function() {
	 
    // Función para mostrar la información del cliente seleccionado
function mostrarCliente(cliente) {
    $("#clienteID").text(cliente.id);
    $("#clienteNombre").text(cliente.nombre);
    $("#clienteTelefono").text(cliente.telefono);
    $("#clienteTable").show();

    console.log("Cliente Seleccionado -> " + idseleccionado);
    detector.setValue(cliente.id);
}

    // Autocompletar
    $("#searchInput").autocomplete({
      source: function(request, response) {
        var term = request.term.toLowerCase();
        var matches = [];
        catalogoClientes.forEach(function(cliente) {
          if (cliente.nombre.toLowerCase().indexOf(term) != -1) {
            matches.push(cliente.nombre);
          }
        });
        response(matches);
      },
      select: function(event, ui) {
        // Buscar el cliente seleccionado
        var clienteSeleccionado = catalogoClientes.find(function(cliente) {
          return cliente.nombre === ui.item.value;
        });

        // Mostrar la información del cliente seleccionado
		idseleccionado=clienteSeleccionado.id;
		PagoCredito(clienteSeleccionado);
		  TablaPagoCredito(clienteSeleccionado);
        mostrarCliente(clienteSeleccionado);
		   $('#btnPagarCredito').prop('disabled', false);
		
		 
      }

    });
  });
	
	
function agregarNuevoClienteDinamico() {
	
	agregandoNuevoClienteDinamico();
 
  var nuevoCliente = {};

  <?php foreach ($camposCliente as $campo): ?>
    nuevoCliente['<?php echo $campo[0]; ?>'] = $('#<?php echo $campo[0]; ?>').val();
  <?php endforeach; ?>

  // Verifica que se ingresen valores válidos
  if (Object.values(nuevoCliente).every(Boolean)) {
    // Agrega el nuevo cliente al arreglo
    catalogoClientes.push(nuevoCliente);

    // Cierra el modal de agregar cliente dinámico
    $('#modalAgregarClienteDinamico').modal('hide');

  } else {
    // Muestra un mensaje de error si faltan datos
    alert('Por favor, complete todos los campos del nuevo cliente.');
  }
}	

	
function agregandoNuevoClienteDinamico() {
     // Recopila la información del formulario
  var formDatas = $('#formAgregarClienteDinamico').serialize();
	alert(formDatas);


    // Realiza una solicitud Ajax para enviar los datos al servidor
    $.ajax({
        url: '<?php echo $urlajaxagregarclientes; ?>', // Reemplaza con la ruta correcta a tu script del servidor
        type: 'POST',
        data: formDatas,
        success: function(response) {
            // Maneja la respuesta del servidor
            console.log(response);

            // Cierra el modal de agregar cliente dinámico si es necesario
            $('#modalAgregarClienteDinamico').modal('hide');

            // Recarga las opciones de clientes en el select
            cargarOpcionesClientes();
        },
        error: function(error) {
            console.error('Error al enviar datos al servidor:', error);
        }
    });

	
	
}	
	

  function cargarOpcionesClientes() {
    var selectCliente = $('#selectCliente');

    // Realiza una solicitud Ajax para obtener los datos de los clientes
    $.ajax({
      url: '<?php echo $urlajaxclientes; ?>', // Reemplaza con la ruta correcta a tu script del servidor
      type: 'POST',
      dataType: 'json',
      success: function(data) {
        // Limpia el select antes de agregar nuevas opciones
        selectCliente.empty();
          var arrayDatos = Object.values(data);

         catalogoClientes = convertirFormatoClientes(arrayDatos);
         console.log('Catalogo de Clientes:', catalogoClientes);
		  
        catalogoClientes.forEach(function(cliente) {
          var option = new Option(cliente.nombre + ' (' + cliente.telefono + ')', cliente.id);
          selectCliente.append(option);
        });

        // Inicializa Select2 en el select
        selectCliente.select2({
          placeholder: 'Buscar cliente',
          allowClear: true // Permite borrar la selección
        });
      },
      error: function(error) {
        console.error('Error al obtener datos de clientes:', error);
      }
    });
  }

	// Función de conversión de formato de clientes
function convertirFormatoClientes(data) {
  var clientesConvertidos = [];

     data.forEach(function(cliente) {
      
        clientesConvertidos.push({
          id: String(cliente[0]),
          nombre: String(cliente[1]),
          telefono: String(cliente[2])
          // Puedes agregar más elementos según sea necesario
        });
      
    });
  

  return clientesConvertidos;
}

	
	

	

  // Llamada a la función al cargar la página
  cargarOpcionesClientes();
</script>