

<style>
    .info-btn {
      position: fixed;
      bottom: 20px;
      right: 20px;  /* Cambiado a derecha */
      z-index: 1055;
      border-radius: 50%;
      width: 56px;
      height: 56px;
      padding: 0;
      display: flex;
      align-items: center;
      justify-content: center;
      font-size: 1.75rem;
      box-shadow: 0 4px 8px rgba(0,0,0,0.2);
    }

    .modal-bottom-slide .modal-dialog {
      margin: 0;
      position: absolute;
      bottom: 0;
      width: 100%;
      transition: transform 0.3s ease-out;
      max-height: 80vh;
    }

    .modal.show .modal-dialog {
      transform: translateY(0%);
    }

    .modal.fade .modal-dialog {
      transform: translateY(100%);
    }

    .modal-content {
      border-radius: 1rem 1rem 0 0;
    }

    .map-container iframe {
      border-radius: 1rem 1rem 0 0;
      width: 100%;
      height: 250px;
      border: none;
    }

    .btn-bar {
      display: flex;
      justify-content: space-around;
      padding: 0.75rem 0;
      border-top: 1px solid #ddd;
      margin-top: 1rem;
      background: #f8f9fa;
      border-radius: 0 0 1rem 1rem;
    }

    .btn-bar a {
      flex-grow: 1;
      margin: 0 0.25rem;
      background: white;
      border-radius: 0.75rem;
      box-shadow: 0 2px 6px rgb(0 0 0 / 0.1);
      text-align: center;
      color: #0d6efd;
      font-weight: 600;
      font-size: 1.1rem;
      padding: 0.75rem 0;
      display: flex;
      flex-direction: column;
      align-items: center;
      text-decoration: none;
      user-select: none;
      transition: background-color 0.2s ease;
    }

    .btn-bar a:hover,
    .btn-bar a:focus {
      background-color: #e2e6ea;
      color: #084298;
      text-decoration: none;
    }

    .btn-bar i {
      font-size: 2.25rem;
      margin-bottom: 0.3rem;
    }
  </style>

<!-- Botón flotante para abrir modal -->
<button class="btn btn-primary info-btn" title="Información del Restaurante" data-bs-toggle="modal" data-bs-target="#infoModal">
  <i class="fas fa-info-circle"></i>
</button>
<!-- Modal bottom sheet -->
<div class="modal fade" id="infoModal" tabindex="-1" aria-hidden="true" aria-labelledby="infoModalLabel">
  <div class="modal-dialog modal-bottom-slide">
    <div class="modal-content shadow-lg">
      <div class="modal-header">
        <h5 class="modal-title" id="infoModalLabel">
          <i class="fas fa-store me-2"></i><?= htmlspecialchars($restaurante['nombre']) ?>
        </h5>
        <button type="button" class="btn-close-custom" data-bs-dismiss="modal" aria-label="Cerrar">
          <i class="fas fa-times"></i>
        </button>
      </div>
      <div class="modal-body p-0">

        <!-- Mapa OpenStreetMap -->
        <div class="map-container">
          <iframe
            src="https://www.openstreetmap.org/export/embed.html?bbox=<?= $restaurante['longitud'] - 0.002 ?>%2C<?= $restaurante['latitud'] - 0.002 ?>%2C<?= $restaurante['longitud'] + 0.002 ?>%2C<?= $restaurante['latitud'] + 0.002 ?>&amp;layer=mapnik&amp;marker=<?= $restaurante['latitud'] ?>%2C<?= $restaurante['longitud'] ?>"
            allowfullscreen=""
            loading="lazy"
            referrerpolicy="no-referrer-when-downgrade"
            style="border:0;">
          </iframe>
        </div>

        <!-- Barra táctil con íconos grandes -->
        <div class="btn-bar" role="toolbar" aria-label="Accesos rápidos de contacto">

          <a href="tel:<?= htmlspecialchars($restaurante['telefono_llamar']) ?>" aria-label="Llamar al restaurante" role="button" tabindex="0">
            <i class="fas fa-phone"></i>
            Llamar

          </a>

          <a href="https://wa.me/<?= preg_replace('/\D/', '', $restaurante['telefono_whatsapp']) ?>" target="_blank" aria-label="Contactar por WhatsApp" role="button" tabindex="0" rel="noopener noreferrer">
            <i class="fab fa-whatsapp" style="color: #25D366;"></i>
            WhatsApp
          </a>

          <a href="mailto:<?= htmlspecialchars($restaurante['email']) ?>" aria-label="Enviar correo" role="button" tabindex="0">
            <i class="fas fa-envelope"></i>
            Correo
          </a>

          <a href="https://www.openstreetmap.org/?mlat=<?= $restaurante['latitud'] ?>&mlon=<?= $restaurante['longitud'] ?>" target="_blank" aria-label="Ver ubicación en OpenStreetMap" role="button" tabindex="0" rel="noopener noreferrer">
            <i class="fas fa-map-marker-alt"></i>
            Ubicación
          </a>

        </div>
      </div>
    </div>
  </div>
</div>
