<div class="container my-5" id="productosContainer">
  <div class="mb-4">
    <input type="text" id="buscador" class="form-control" placeholder="Buscar producto por nombre...">
  </div>
  <!-- Contenedor con scroll oculto y sin borde -->
  <div id="productosListaContainer">
    <div id="productosLista"></div>
  </div>
</div>

<!-- Modal de Imagen -->
<div class="modal fade" id="imagenModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered modal-lg">
    <div class="modal-content border-0 bg-transparent">
      <button type="button" class="btn-close position-absolute top-0 end-0 m-2" data-bs-dismiss="modal" aria-label="Cerrar"></button>
      <img src="" class="img-fluid rounded" id="imagenModalSrc" alt="Vista ampliada">
    </div>
  </div>
</div>

<style>
  #productosListaContainer {
    max-height: 80vh; /* Ajusta el máximo alto aquí */
    overflow-y: auto;

    /* Ocultar scroll en navegadores modernos */
    scrollbar-width: none; /* Firefox */
    -ms-overflow-style: none;  /* IE 10+ */
  }
  #productosListaContainer::-webkit-scrollbar {
    display: none; /* Chrome, Safari y Opera */
  }

  /* Quitar borde y padding para que quede limpio */
  #productosListaContainer {
    border: none;
    padding: 0;
  }

  .producto-item {
    height: 180px;
    overflow: hidden;
    display: flex;
    flex-direction: row;
    border: 1px solid #ddd;
    border-radius: 0.5rem;
    background: white;
  }

  .producto-imagen {
    position: relative;
    flex: 0 0 140px;
    height: 100%;
    cursor: pointer;
    overflow: hidden;
  }

  .producto-imagen img {
    width: 100%;
    height: 100%;
    object-fit: cover;
  }
  .imagen-overlay {
    position: absolute;
    top: 0;
    left: 0;
    height: 100%;
    width: 100%;
    background: linear-gradient(to right,
      rgba(255, 255, 255, 0) 0%,
      rgba(255, 255, 255, 0) 20%,
      rgba(255, 255, 255, 0.1) 40%,
      rgba(255, 255, 255, 0.25) 60%,
      rgba(255, 255, 255, 0.5) 80%,
      rgba(255, 255, 255, 0.9) 100%);
    pointer-events: none;
  }
  .btn-add {
    background-color: #AAC7FF; /* azul suave */
    border: none;
    color: white;
    font-weight: 500;
    padding: 6px 14px;
    border-radius: 6px;
    transition: background-color 0.2s ease;
    width: auto; /* Evita que sea demasiado ancho */
    max-width: 150px; /* Limita en escritorio */
    white-space: nowrap;
  }

  .btn-add:hover {
    background-color: #3aaed4;
  }

  @media (max-width: 768px) {
    .producto-item {
      flex-direction: row;
      height: auto;
    }
    @media (max-width: 376px) {
      .btn-add {
        width: 100%;
      }
    }

    .producto-imagen {
      flex: 0 0 40%;
      max-height: 200px;
    }

    .producto-imagen img {
      object-fit: cover;
    }
  }
</style>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script>
  $(function () {
    const $productosLista = $('#productosLista');
    const $buscador = $('#buscador');
    let productos = [];

    function cargarProductos() {
      $.ajax({
        type: 'POST',
        url: 'app/ajax.php',
        data: { metodo: 'Productos' },
        dataType: 'json',
        success: function (res) {
          if (res.status === 'success' && Array.isArray(res.data)) {
            productos = res.data;
            renderizarProductos();
          } else {
            $productosLista.html('<div class="alert alert-warning">No se encontraron productos.</div>');
          }
        },
        error: function () {
          $productosLista.html('<div class="alert alert-danger">Error al cargar los productos.</div>');
        }
      });
    }

    function renderizarProductos() {
      $productosLista.empty();
      productos.forEach(prod => {
        let urlImagen = 'https://previews.123rf.com/images/surfupvector/surfupvector1908/surfupvector190802662/129243509-denied-art-line-icon-censorship-no-photo-no-image-available-reject-or-cancel-concept-vector.jpg';

        try {
          let imgData = prod.imagen;
          if (typeof imgData === 'string') {
            imgData = imgData.trim();
            if (imgData.startsWith('{')) {
              imgData = JSON.parse(imgData);
            } else {
              imgData = null;
            }
          }
          if (imgData && imgData.imagen && imgData.imagen.trim() !== '') {
            urlImagen = imgData.imagen;
          }
        } catch (e) {
          console.warn('Error al parsear imagen JSON:', prod.imagen, e);
        }

        const nombre = prod.nombre ? prod.nombre.toLowerCase() : '';
        const categoria = prod.categoria || '';
        const detalle = prod.detalle || '';
        const precio = typeof prod.precio === 'number' ? prod.precio.toFixed(2) : prod.precio;

        const $item = $(`
          <div class="producto-item mb-4 shadow-sm"
               data-categoria="${categoria}"
               data-nombre="${nombre}"
               data-id="${prod.id}">
            <div class="producto-imagen">
              <img src="${urlImagen}" alt="${prod.nombre}" data-full="${urlImagen}">
              <div class="imagen-overlay"></div>
            </div>
            <div class="p-3 d-flex flex-column justify-content-center flex-grow-1">
              <h5 class="fw-semibold text-secondary mb-1">${prod.nombre}</h5>
              <p class="mb-1 text-muted fst-italic">${prod.descripcion}</p>
              <p class="mb-1 fw-bold text-success">Precio: $${precio}</p>
              <p class="text-muted" style="font-size: 0.85rem;">${detalle}</p>
              <button class="btn btn-sm btn-primary mt-2 btn-add"
                      data-prod='${JSON.stringify({ ...prod, precio: String(precio) }).replace(/'/g, "&apos;")}'>
                <i class="fa fa-cart-plus"></i> Agregar
              </button>
            </div>
          </div>
        `);
        $productosLista.append($item);
      });

      aplicarFiltros();
    }

    function aplicarFiltros() {
      const categoriaActiva = $('.categoria-btn.fw-bold').data('categoria') || 'todas';
      const busqueda = $buscador.val().trim().toLowerCase();

      $('.producto-item').each(function () {
        const $item = $(this);
        const nombre = $item.data('nombre') || '';
        const categoria = $item.data('categoria') || '';
        const visible = (categoriaActiva === 'todas' || categoria === categoriaActiva);
        const coincide = nombre.includes(busqueda);
        $item.toggle(visible && coincide);
      });
    }

    $buscador.on('input', aplicarFiltros);
    $(document).on('categoriaSeleccionada', aplicarFiltros);

    $productosLista.on('click', '.btn-add', function () {
      const prod = JSON.parse($(this).attr('data-prod'));
      addToCart(prod);
    });

    $productosLista.on('click', '.producto-imagen img', function () {
      const src = $(this).data('full');
      $('#imagenModalSrc').attr('src', src);
      const modal = new bootstrap.Modal(document.getElementById('imagenModal'));
      modal.show();
    });

    cargarProductos();
  });
</script>
