<style>
  body {
    background-color: #f8f9fa;
  }
  .card-img-overlay {
    background: rgba(0, 0, 0, 0.5);
    color: white;
    display: flex;
    flex-direction: column; 
    justify-content: flex-end;
    padding: 1rem;
  }
  .carousel-inner {
    border-radius: 10px;
    overflow: hidden;
  }
  .card img {
    height: 300px;
    object-fit: cover;
  }
  .btn-agregar {
    margin-top: 0.5rem;
  }
</style>


<div class="container py-5">
  <h1 class="text-center mb-4">Menú del Día</h1>

  <div class="orden">
    <?php foreach ($menu as $index => $tiempo): ?>
      <div class="mb-4">
        <h4 class="mb-3"><?= htmlspecialchars($tiempo['tiempo']) ?></h4>
        <div id="carousel-<?= $index ?>" class="carousel slide" data-bs-ride="false">
          <div class="carousel-inner">
            <?php foreach ($tiempo['opciones'] as $i => $opcion): ?>
              <div class="carousel-item <?= $i === 0 ? 'active' : '' ?>"
                   data-id="<?= $opcion['id'] ?>"
                   data-nombre="<?= htmlspecialchars($opcion['nombre']) ?>"
                   data-precio="<?= $opcion['precio'] ?>"
                   data-descripcion="<?= htmlspecialchars($opcion['descripcion']) ?>"
                   data-imagen="<?= htmlspecialchars($opcion['imagen']) ?>"
                   data-categoria="<?= htmlspecialchars($tiempo['tiempo']) ?>">
                <div class="card w-100">
                  <img src="<?= $opcion['imagen'] ?>" class="card-img" alt="<?= $opcion['nombre'] ?>">
                  <div class="card-img-overlay">
                    <h5 class="card-title"><?= $opcion['nombre'] ?> - $<?= $opcion['precio'] ?></h5>
                    <p class="card-text"><?= $opcion['descripcion'] ?></p>
                  </div>
                </div>
              </div>
            <?php endforeach; ?>
          </div>
          <button class="carousel-control-prev" type="button" data-bs-target="#carousel-<?= $index ?>" data-bs-slide="prev">
            <span class="carousel-control-prev-icon"></span>
          </button>
          <button class="carousel-control-next" type="button" data-bs-target="#carousel-<?= $index ?>" data-bs-slide="next">
            <span class="carousel-control-next-icon"></span>
          </button>
        </div>
      </div>
    <?php endforeach; ?>
  </div>

  <div class="text-center mt-4">
    <button id="btnAgregarTodos" class="btn btn-success btn-lg">Agregar productos seleccionados al carrito</button>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

<script>
  // La función addToCart que ya tienes en tu carrito
  // Simplemente la llamamos aquí para agregar los productos con la estructura correcta
  // cart, updateCartCount(), renderCart() ya están definidos en tu carrito offcanvas

  document.getElementById('btnAgregarTodos').addEventListener('click', () => {
    const productosSeleccionados = [];

    document.querySelectorAll('.carousel').forEach(carousel => {
      const activo = carousel.querySelector('.carousel-item.active');
      if (activo) {
        productosSeleccionados.push({
          id: parseInt(activo.getAttribute('data-id')),
          nombre: activo.getAttribute('data-nombre'),
          categoria: activo.getAttribute('data-categoria'),
          descripcion: activo.getAttribute('data-descripcion'),
          precio: activo.getAttribute('data-precio'),
          imagen: activo.getAttribute('data-imagen'),
          detalle: activo.getAttribute('data-nombre')
        });
      }
    });

    productosSeleccionados.forEach(producto => addToCart(producto));
    alert('Productos seleccionados agregados al carrito');
  });
</script>
