
    <style>
        .modal-header {
            border-bottom: none;
            position: relative;
        }
        .modal-header::before {
            content: '';
            position: absolute;
            width: 100%;
            height: 4px;
            background: linear-gradient(to right, #ff416c, #ff4b2b);
            top: 0;
            left: 0;
        }
        .modal-content {
            border-radius: 15px;
            overflow: hidden;
            box-shadow: 0px 0px 15px rgba(0, 0, 0, 0.2);
        }
        .modal-body {
            padding: 2rem;
        }
        .modal-footer {
            border-top: none;
        }
        .btn-custom {
            background: #ff4b2b;
            background: linear-gradient(to right, #ff416c, #ff4b2b);
            color: white;
            border: none;
            border-radius: 50px;
            padding: 0.75rem 1.5rem;
            transition: background 0.3s ease-in-out;
        }
        .btn-custom:hover {
            background: #ff4b2b;
        }
        .form-control {
            border-radius: 50px;
            padding: 1rem;
        }
        .form-control:focus {
            box-shadow: none;
            border-color: #ff4b2b;
        }
    </style>


<!-- Modal de Registro -->
<div class="modal fade" id="registerModal" tabindex="-1" aria-labelledby="registerModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="registerModalLabel">Registro de Cliente</h5>
       <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <form id="registerForm">
          <div class="form-group">
            <label for="name">Nombre</label>
            <input type="text" class="form-control" id="name" name="name" required>
          </div>
          <div class="form-group">
            <label for="phone">Teléfono</label>
            <input type="tel" class="form-control" id="phone" name="phone" required>
          </div>
          <div class="form-group">
            <label for="address">Dirección</label>
            <input type="text" class="form-control" id="address" name="address">
          </div>
          <button type="button" class="btn btn-custom btn-block" onclick="registerClient()">Registrarse</button>
        </form>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
      </div>
    </div>
  </div> 
</div>

<script>
	console.log("->");
  function registerClient() {
    const form = $('#registerForm');

    // Validación básica (puedes agregar más validaciones según tus requisitos)
    if (!$('#name').val() || !$('#phone').val()) {
        alert('Por favor, complete todos los campos obligatorios.');
        return;
    }

    // Serializa el formulario
    let formData = $('#registerForm').serialize();
    const metodo = 'reg';
    formData += `&metodo=${metodo}`;

    // Enviar la solicitud AJAX
    $.ajax({
        type: 'POST',
        url: 'app/ajax.php', // Reemplaza con la URL de tu servidor
        data: formData,
        success: function(response) {
			console.log(response);
			const res = JSON.parse(response);
			alert(res.message);
          
			 if (res.status === 'success') {

            const name = $('#name').val();
            const phone = $('#phone').val();
            const address = $('#address').val();

            // Actualiza el banner con los datos del cliente en el modal de pedido
            const clientBannerOrder = $('#clientBannerOrder');
            clientBannerOrder.html(`
                <strong>Cliente:</strong> ${name}<br>
                <strong>Teléfono:</strong> ${phone}<br>
                <strong>Dirección:</strong> ${address}
            `);
            clientBannerOrder.show(); // Muestra el banner en el modal de pedido

            // Actualiza también el banner inicial de identificación si lo deseas
            const clientBanner = $('#clientBanner');
            clientBanner.html(`
                <strong>${name}</strong><br>
                <span>Teléfono: ${phone}</span><br>
                <span>Dirección: ${address}</span>
            `);
            clientBanner.show(); // Muestra el banner inicial

            // Cierra el modal de registro
            $('#registerModal').modal('hide');
			$('#loginLabel').hide();
            $('#submitOrderButton').prop('disabled', false); 
			 
			 }
			
        },
        error: function(error) {
            // Manejar errores
            alert('Error al registrar el cliente. Por favor, inténtelo de nuevo.');
        }
    });
  }
</script>
