<?php
// Procesamiento del formulario
if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $nombre = $_POST['nombre'] ?? '';
    $rfc = $_POST['rfc'] ?? '';
    $razon_social = $_POST['razon_social'] ?? '';
    $direccion = $_POST['direccion'] ?? '';
    $correo = $_POST['correo'] ?? '';

    // Carpeta para subir archivos
    $uploadDir = "uploads/";
    if (!file_exists($uploadDir)) mkdir($uploadDir, 0777, true);

    // Subida de archivo
    $archivoNombre = basename($_FILES["documento"]["name"]);
    $archivoDestino = $uploadDir . time() . "_" . $archivoNombre;

    $mensaje = "";
    if (move_uploaded_file($_FILES["documento"]["tmp_name"], $archivoDestino)) {
        $mensaje = "✅ Datos enviados correctamente. Gracias, $nombre.";
    } else {
        $mensaje = "❌ Error al subir el documento. Inténtalo nuevamente.";
    }
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Kiosco Fiscal | Registro de Datos</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background: #f4f6f9;
        }
        .container {
            max-width: 700px;
            margin-top: 50px;
        }
        .card {
            border-radius: 15px;
            box-shadow: 0 4px 10px rgba(0,0,0,0.1);
        }
        .info-box {
            background: #e9f5ff;
            border-left: 5px solid #0d6efd;
            padding: 15px;
            margin-bottom: 20px;
            border-radius: 8px;
        }
        footer {
            margin-top: 50px;
            text-align: center;
            color: #777;
        }
    </style>
</head>
<body>

<div class="container">
    <div class="text-center mb-4">
        <h2 class="fw-bold text-primary">📄 Kiosco Fiscal</h2>
        <p class="text-muted">Captura tus datos fiscales y sube un documento que acredite tu identidad.</p>
    </div>

    <?php if (!empty($mensaje)): ?>
        <div class="alert alert-info text-center">
            <?= htmlspecialchars($mensaje) ?>
        </div>
    <?php endif; ?>

    <div class="info-box">
        <strong>ℹ️ Instrucciones:</strong>
        <ul class="mb-0">
            <li>Completa todos los campos con tus datos fiscales.</li>
            <li>Sube un documento de identificación oficial (INE, pasaporte o cédula profesional).</li>
            <li>Revisa que tu RFC esté correctamente escrito.</li>
        </ul>
    </div>

    <div class="card p-4">
        <form action="" method="POST" enctype="multipart/form-data" id="formKiosco">
            <div class="mb-3">
                <label class="form-label">Nombre completo</label>
                <input type="text" class="form-control" name="nombre" required>
            </div>
            <div class="mb-3">
                <label class="form-label">RFC</label>
                <input type="text" class="form-control" name="rfc" pattern="[A-ZÑ&]{3,4}\d{6}[A-Z0-9]{3}" 
                       title="Formato válido de RFC" required>
            </div>
            <div class="mb-3">
                <label class="form-label">Razón social</label>
                <input type="text" class="form-control" name="razon_social" required>
            </div>
            <div class="mb-3">
                <label class="form-label">Dirección fiscal</label>
                <textarea class="form-control" name="direccion" rows="2" required></textarea>
            </div>
            <div class="mb-3">
                <label class="form-label">Correo electrónico</label>
                <input type="email" class="form-control" name="correo" required>
            </div>
            <div class="mb-3">
                <label class="form-label">Documento de identidad (PDF o imagen)</label>
                <input type="file" class="form-control" name="documento" accept=".pdf,image/*" required>
            </div>
            <div class="d-grid">
                <button type="submit" class="btn btn-primary btn-lg">Enviar Datos</button>
            </div>
        </form>
    </div>

    <footer>
        <p>© <?= date("Y") ?> Kiosco Fiscal | Tus datos están protegidos conforme a la ley.</p>
    </footer>
</div>

<script>
document.getElementById("formKiosco").addEventListener("submit", function(e){
    const archivo = document.querySelector('input[name="documento"]').files[0];
    if(archivo && archivo.size > 5 * 1024 * 1024) { // 5 MB
        e.preventDefault();
        alert("⚠️ El archivo no debe superar los 5MB.");
    }
});
</script>
</body>
</html>
