<!DOCTYPE html>
<html lang="es">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>WebApp de Delivery</title>
<link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
<style>
.category-card {
    cursor: pointer;
}
.category-card:hover {
    box-shadow: 0px 0px 15px rgba(0,0,0,0.1);
}
.card-img-top {
    height: 100px; /* Ajustamos la altura de la imagen de la tarjeta */
    object-fit: cover;
}
.card-body {
    text-align: center;
    padding: 1rem; /* Espacio interno de la tarjeta */
}
.product-card {
    display: flex;
    align-items: center;
    margin-bottom: 1rem;
    padding: 0.5rem;
    border: 1px solid #ddd;
    border-radius: 0.5rem;
}
.product-image {
    width: 50px;
    height: 50px;
    border-radius: 50%;
    margin-right: 1rem;
}
.product-info {
    flex: 1;
}
.product-price {
    font-weight: bold;
}
.add-to-cart {
    display: flex;
    align-items: center;
    justify-content: center;
    width: 40px;
    height: 40px;
    background-color: #28a745;
    color: white;
    border-radius: 50%;
    cursor: pointer;
}
.scrollmenu {
    overflow-x: auto;
    white-space: nowrap;
}
footer {
    position: fixed;
    bottom: 0;
    width: 100%;
    background-color: #f8f9fa;
}
img.lazy {
    opacity: 0;
    transition: opacity 0.3s;
}
img.lazy.loaded {
    opacity: 1;
}
	
</style>
</head>
<body>
<div class="container">
  <h1 class="my-4"></h1>

  <nav class="navbar navbar-expand-lg navbar-light bg-light"> <a class="navbar-brand" href="#"><?php echo $primerElemento['Nombre_Empresa'];?></a>
    <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation"> <span class="navbar-toggler-icon"></span> </button>
    <div class="collapse navbar-collapse" id="navbarSupportedContent"> 
      <ul class="navbar-nav mr-auto">
        <!-- Puedes añadir más elementos de navegación aquí -->
      </ul>
      <ul class="navbar-nav">
        <li class="nav-item"> <a class="nav-link" data-toggle="modal" data-target="#loginModal"><i class="fas fa-sign-in-alt"></i> Login</a> </li>
        <li class="nav-item"> <a class="nav-link" data-toggle="modal" data-target="#registerModal"><i class="fas fa-user-plus"></i> Registro</a> </li>
      </ul>
    </div>
  </nav>
	  <div id="clientBanner" class="alert alert-info" style="display: none;"> 
    <!-- Aquí se mostrarán los datos del cliente --> 
  </div>
  <div class="row mt-4">
    <div class="col-12">
      <div class="scrollmenu" id="categoriesList"> 
        <!-- Categorías serán cargadas aquí como ítems scrollables --> 
      </div>
    </div>
  </div>
  <div id="productsList" class="mt-4"> 
    <!-- Productos serán cargados aquí --> 
  </div>
  <!-- Espacio en blanco -->
  <div style="height: 150px;"></div>
  
  <!-- Footer -->
  <footer class="footer py-3">
    <div class="container">
      <div class="d-flex justify-content-end">
        <div class="col-md-3 text-center"> <a href="#" class="text-dark" data-toggle="modal" data-target="#infoModal"><i class="fas fa-info-circle fa-3x"></i></a> </div>
        <div class="col-md-3 text-center"> <a href="https://api.whatsapp.com/send?phone=52<?php echo $primerElemento['Telefono2'];?>" class="text-success" target="_blank"><i class="fab fa-whatsapp fa-3x"></i></a> </div>
        <div class="col-md-3 text-center"> <a href="tel:<?php echo $primerElemento['Telefono2'];?>" class="text-dark"><i class="fas fa-phone fa-3x"></i></a> </div>
        <div class="col-md-3 text-center" onclick="openOrderModal()"> <i class="fas fa-shopping-cart fa-3x"></i> <span id="cartCounter" class="badge badge-pill badge-danger">0</span> </div>
      </div>
    </div>
  </footer>
</div>



<!-- Modal para Imagen Completa -->
<div class="modal fade" id="imageModal" tabindex="-1" aria-labelledby="imageModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="imageModalLabel"></h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"> <span aria-hidden="true">&times;</span> </button>
      </div>
      <div class="modal-body text-center"> <img src="" class="img-fluid" id="modalImage"> </div>
    </div>
  </div>
</div>

<!-- Modal de Pedido -->
<div class="modal fade" id="orderModal" tabindex="-1" aria-labelledby="orderModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="orderModalLabel">Hacer un Pedido</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"> <span aria-hidden="true">&times;</span> </button>
      </div>
      <div class="modal-body"> 
        <!-- Aquí se mostrarán los datos del cliente -->
        <div id="clientBannerOrder" class="alert alert-info" style="display: none;"></div>
        <div id="orderPreview"> 
          <!-- Vista previa del pedido será cargada aquí --> 
        </div>
        <form id="orderForm">
          <div class="form-group">
            <div class="btn-group btn-group-toggle" data-toggle="buttons">
              <label class="btn btn-outline-primary active">
                <input type="radio" name="pickup_delivery" id="option1" autocomplete="off" checked value="pickup">
                <i class="fas fa-store fa-3x"></i> <br>
                <span>Recoger en tienda</span> </label>
              <label class="btn btn-outline-primary">
                <input type="radio" name="pickup_delivery" id="option2" autocomplete="off" value="delivery">
                <i class="fas fa-shipping-fast fa-3x"></i> <br>
                <span>Para llevar</span> </label>
            </div>
          </div>
          <div class="form-group">
            <label for="observations">Observaciones (máximo 3 líneas)</label>
            <textarea class="form-control" id="observations" name="observations" rows="3"></textarea>
          </div>
          <div class="form-group" id="products-container"> 
            <!-- Productos serán cargados aquí --> 
          </div>
			<div class="form-group">
				
				<button type="button" id="submitOrderButton" class="btn btn-success" onclick="submitOrder()" disabled>Enviar Pedido</button>
				<label for="submitOrderButton" id="loginLabel"> - Inicia sesión</label>
			</div>

        </form>
      </div>
    </div>
  </div>
</div>

<!-- Modal de Vista Previa -->
<div class="modal fade" id="previewModal" tabindex="-1" aria-labelledby="previewModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="previewModalLabel">Vista Previa del Pedido</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <div id="clientBannerOrderPreview" class="mb-4"></div>
        <div id="orderPreviewContent"></div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
        <button type="button" class="btn btn-primary" onclick="confirmOrder()">Confirmar Pedido</button>
      </div>
    </div>
  </div>
</div>
</div>


<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script> 
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.3/dist/umd/popper.min.js"></script> 
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
<?php
	include("app/reg.php");
	include("app/login.php");
switch ( $pre ) {
    case "fb":
        $pr = 4;
        break;
    case "pz":
        $pr = 2;
        break;
    case "pu":
        $pr = 3;
        break;
    default:
        $pr = 3;
        break;
}

$consultaP = "SELECT IDCa, Categoria, Descripcion_Corta, Descripcion, Precio_$pr as Precio, Visible FROM MicroSi_Datos.`$IDs-Catalogo`, MicroSi_Datos.`$IDs-Catalogo_Precio` WHERE IDCa=ID_Catalogo AND Estado='Disponible';";
$datosP = $db->tablasDB2( $consultaP );
?>
	
	<script>
	     // Datos de productos obtenidos del servidor o base de datos
		var idc='';
        const productsData = <?php echo json_encode($datosP); ?>;
        console.log(productsData);  // Verifica la estructura y contenido de productsData en la consola
		
    $(document).ready(function() {
        clearCart();
        loadCategories();
        $(document).on('click', '.product-image', function() {
            const imageUrl = $(this).attr('data-image');
            const productDescription = $(this).attr('alt'); // Obtener la descripción del producto
            $('#modalImage').attr('src', imageUrl);
            $('#imageModalLabel').text(productDescription); // Actualizar el título del modal con la descripción del producto
            $('#imageModal').modal('show');
        });
    });

    function calculateCartTotal() {
        const cart = JSON.parse(localStorage.getItem('cart')) || [];
        let totalItems = 0;
        let totalPrice = 0;
        cart.forEach(item => {
            totalItems += 1;
            totalPrice += parseFloat(item.price) || 0; // Asegurarse de que el precio es un número
        });
        return { totalItems, totalPrice };
    }

    function clearCart() {
        localStorage.removeItem('cart'); // Elimina el carrito del localStorage
        updateCartCounter(); // Actualiza el contador de productos en el carrito
    }

    function updateCartCounter() {
        const cart = JSON.parse(localStorage.getItem('cart')) || [];
        $('#cartCounter').text(cart.length); // Mostrar la cantidad de productos en el carrito
    }

    function loadCategories() {
        const categoriesList = $('#categoriesList');
        categoriesList.empty();

        // Obtener categorías únicas
        const categories = [...new Set(productsData.map(product => product.Categoria))];

        categories.forEach(category => {
            // Generar tarjeta de categoría dinámicamente
            const categoryCard = `
                <div class="card category-card d-inline-block m-2" style="width: 200px;" onclick="loadProducts('${category}')">
                    <div class="card-body">
                        <i class="${getCategoryIcon(category)} fa-3x" style="color: ${getCategoryColor(category)}"></i>
                        <h5 class="card-title">${category}</h5>
                    </div>
                </div>`;
            categoriesList.append(categoryCard);
        });
    }

    function loadProducts(category) {
        const productsList = $('#productsList');
        productsList.empty();

        const filteredProducts = productsData.filter(product => product.Categoria === category).slice(0, 10);

        if (filteredProducts.length) {
            filteredProducts.forEach(product => {
                const productElement = `
                    <div class="product-card">
                        <img src="${getProductImage(product)}" alt="${product.Descripcion_Corta}" class="product-image" 
                             data-toggle="modal" data-target="#imageModal" data-image="${getProductImage(product)}">
                        <div class="product-info">
                            <h5>${product.Descripcion_Corta}</h5>
                            <p class="product-price">$${parseFloat(product.Precio).toFixed(2)}</p>
                        </div>
                        <div class="add-to-cart" onclick="addToCart('${product.IDCa}', '${product.Descripcion_Corta}', ${product.Precio})">
                            <span>+</span>
                        </div>
                    </div>`;
                productsList.append(productElement);
            });
        } else {
            productsList.append('<p>No hay productos disponibles en esta categoría.</p>');
        }
    }

    function getCategoryIcon(category) {
        const defaultIcon = 'fa fa-star'; // Ícono por defecto
        const product = productsData.find(product => product.Categoria === category);
        if (product && product.Visible) {
            const visibleData = JSON.parse(product.Visible);
            return visibleData.icono || defaultIcon;
        }
        return defaultIcon;
    }

    function getCategoryColor(category) {
        const defaultColor = '#000000'; // Color por defecto
        const product = productsData.find(product => product.Categoria === category);
        if (product && product.Visible) {
            const visibleData = JSON.parse(product.Visible);
            return visibleData.color || defaultColor;
        }
        return defaultColor;
    }

    function getProductImage(product) {
        const defaultImage = 'path/to/default.jpg'; // Imagen por defecto
        if (product.Visible) {
            const visibleData = JSON.parse(product.Visible); 
            return visibleData.imagen || defaultImage;
        }
        return defaultImage;
    }

    function addToCart(id, name, price) {
        const cart = JSON.parse(localStorage.getItem('cart')) || [];
        cart.push({ id, name, price });
        localStorage.setItem('cart', JSON.stringify(cart));
        updateCartCounter(); // Actualizar contador de productos en el carrito
        updateOrderPreviewUI(); // Actualizar la vista previa del pedido en la interfaz
        alert(`${name} agregado al carrito`);
    }

    function updateOrderPreviewUI() {
        const orderPreview = $('#orderPreview');
        orderPreview.empty();

        const cart = JSON.parse(localStorage.getItem('cart')) || [];
        if (cart.length === 0) {
            orderPreview.append('<p>El carrito está vacío.</p>');
        } else {
            cart.forEach((item, index) => {
                const previewItem = `
                    <div class="product-card d-flex justify-content-between">
                        <div class="product-info">
                            <h5>${item.name}</h5>
                            <p class="product-price">$${parseFloat(item.price).toFixed(2)}</p>
                        </div>
                        <button class="btn btn-danger btn-sm" onclick="removeFromCartPreview(${index})">Eliminar</button>
                    </div>`;
                orderPreview.append(previewItem);
            });

            const { totalItems, totalPrice } = calculateCartTotal();
            orderPreview.append(`
                <hr>
                <div class="d-flex justify-content-between">
                    <h5>Total de ítems: ${totalItems}</h5>
                    <h5>Precio total: $${totalPrice.toFixed(2)}</h5>
                </div>
            `);
        }
    }

    function removeFromCartPreview(index) {
        let cart = JSON.parse(localStorage.getItem('cart')) || [];
        cart = cart.filter((item, i) => i !== index);
        localStorage.setItem('cart', JSON.stringify(cart));
        updateOrderPreviewUI(); // Actualiza la vista previa del pedido después de eliminar un producto
        updateCartCounter(); // Actualiza el contador de productos en el carrito
    }

    function openOrderModal() {
        $('#orderModal').modal('show');
    }

    function submitOrder() {
		
        const clientBannerText = $('#clientBanner').text();
        const pickupDelivery = $('input[name="pickup_delivery"]:checked').val();
        const observations = $('#observations').val();
        const cart = JSON.parse(localStorage.getItem('cart')) || [];
        let orderSummary = `
            <div>
                <strong>${clientBannerText}</strong>
                <p><strong>Tipo de entrega:</strong> ${pickupDelivery === 'pickup' ? 'Recoger en tienda' : 'Para llevar'}</p>
                <p><strong>Observaciones:</strong> ${observations}</p>
            </div>
            <div>
                <h4>Productos:</h4>
        `;
        cart.forEach(product => {
            orderSummary += `
                <div class="card mb-2">
                    <div class="card-body">
                        <h5 class="card-title">${product.name}</h5>
                        <p class="card-text">Precio: $${parseFloat(product.price).toFixed(2)}</p>
                    </div>
                </div>
            `;
        });
        orderSummary += `</div><div class="text-right"><h4>Total: $${calculateCartTotal().totalPrice.toFixed(2)}</h4></div>`;
        $('#orderPreviewContent').html(orderSummary);
        $('#previewModal').modal('show');
    }

    function confirmOrder() {
    const clientBannerText = $('#clientBanner').text().replace(/\s+/g, ' ').trim(); // Elimina saltos de línea y espacios extra
    const pickupDelivery = $('input[name="pickup_delivery"]:checked').val();
    const observations = $('#observations').val();
    const cart = JSON.parse(localStorage.getItem('cart')) || [];
    const orderDetails = {
        client: clientBannerText,
        deliveryType: pickupDelivery,
        observations: observations,
        products: cart
    };
    console.log('Order Details:', orderDetails);
    // Aquí puedes enviar orderDetails a tu backend para procesar el pedido
    clearCart();
    $('#orderModal').modal('hide');
    $('#previewModal').modal('hide');
    hacerpedido(orderDetails, observations);
}

		
		
	 function hacerpedido(Mensaje,obs) {
		const tipo = "Delivery";
		 var M=JSON.stringify(Mensaje);
		 console.log(Mensaje);
		console.log("-> " + idc + " " + obs + " " + M+ " " +tipo);

		// Crear un objeto con los datos a enviar
		const data = {
			mensaje: M,
			observacion: obs,
			id_cliente: idc,
			tipo: tipo, 
			metodo: "pedido"
		};

		// Enviar la solicitud AJAX
    $.ajax({
        type: 'POST',
        url: 'app/ajax.php', // Reemplaza con la URL de tu servidor
        data: data,
        success: function(response) {
			console.log(response);
			 
			 
        },
        error: function(error) {
            // Manejar errores
            alert('Error al registrar el cliente. Por favor, inténtelo de nuevo.');
        }
    }); 
		 
		 
		 
		 
  }	
</script>

	
</body>
</html>
