<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Sistema de Comandas</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body { margin:0; padding:0; font-size:1.05rem; }
    .container-fluid { display:flex; flex-wrap:wrap; gap:10px; height:100vh; }
    .section {
      flex:1 1 300px;
      display:flex; flex-direction:column;
      border-radius:8px; overflow:hidden;
      box-shadow:0 2px 6px rgba(0,0,0,0.1);
      background:#fff;
    }
    .section h4 { margin:0; padding:10px; background:#0d6efd; color:#fff; text-align:center; font-size:1.2rem; }
    .scroll-area { flex:1; overflow-y:auto; max-height:45vh; }

  /* --- Clientes --- */
  #clientesLista { 
    list-style:none; 
    margin:0; 
    padding:0; 
    max-height: 180px;   /* ≈ altura para 3 elementos */
    overflow-y: auto; 
  }
  #clientesLista li {
    padding:10px; 
    border-bottom:1px solid #eee; 
    cursor:pointer;
  }
  #clientesLista li:hover { background:#f0f0f0; }
  #clientesLista li.active { background:#0d6efd; color:#fff; }

    /* --- Productos --- */
    .producto-card {
      display:flex; align-items:center; justify-content:space-between;
      padding:10px; border-bottom:1px solid #eee;
    }
    .producto-info { display:flex; align-items:center; gap:10px; }
    .producto-info img { width:50px; height:50px; border-radius:6px; object-fit:cover; }
    .producto-info strong { display:block; font-size:1rem; }
    #total { font-weight:bold; font-size:1.3rem; color:#198754; }
  </style>
</head>
<body> 

<div class="container-fluid">

  <!-- Clientes --> 
  <div class="section">
    <h4>Clientes</h4>
    <div class="p-3">
      <input type="text" id="buscadorClientes" class="form-control mb-2" placeholder="Buscar cliente...">
      <ul id="clientesLista"></ul>
    </div>
  </div>

  <!-- Menú -->
  <div class="section">
    <h4>Menú</h4>
    <div class="p-3">
      <input type="text" id="buscador" class="form-control mb-2" placeholder="Buscar producto...">
      <div class="scroll-area" id="productosLista">
        <?php foreach($productos as $p): 
          $visible = json_decode($p['Visible'], true); ?>
          <div class="producto-card" data-nombre="<?= strtolower($p['Nombre']) ?>">
            <div class="producto-info">
              <img src="<?= $visible['imagen'] ?>" alt="<?= $p['Nombre'] ?>">
              <div>
                <strong><?= $p['Nombre'] ?></strong>
                <small><?= $p['Modelo'] ?></small><br>
                <span class="text-success">$<?= number_format($p['Precio_2'], 2) ?></span>
              </div>
            </div>
            <button class="btn btn-sm btn-primary"
              onclick="addToCart(<?= $p['id'] ?>, '<?= $p['Nombre'] ?>', <?= $p['Precio_2'] ?>, '<?= $p['Descripcion'] ?>')">+</button>
          </div>
        <?php endforeach; ?>
      </div>
    </div>
  </div>

  <!-- Comanda -->
  <div class="section">
    <h4>Comanda</h4>
    <div class="scroll-area">
      <ul id="orden" class="list-group w-100 mb-2"></ul>
    </div>
    <div class="d-flex justify-content-between px-3 py-2 bg-light">
      <span>Total:</span><span id="total">$0.00</span>
    </div>
    <div class="p-3">
      <div class="d-flex gap-2 mb-2">
        <button class="btn btn-outline-primary flex-fill" onclick="setEntrega('Domicilio')">Domicilio</button>
        <button class="btn btn-outline-primary flex-fill" onclick="setEntrega('Recoger')">Recoger</button>
        <button class="btn btn-outline-primary flex-fill" onclick="setEntrega('Mesa')">Mesa</button>
      </div>
      <textarea id="observaciones" class="form-control mb-2" placeholder="Observaciones generales del pedido"></textarea>
      <button class="btn btn-success w-100" onclick="checkout()">Enviar Pedido</button>
    </div>
  </div>

</div>

<script>
  const ordenLista = document.getElementById("orden");
  const totalEl = document.getElementById("total");
  let cart = [];
  let metodoEntregaSeleccionado = "";
  let usuario = {};

  function addToCart(id, nombre, precio, descripcion) {
    const existente = cart.find(p => p.id === id);
    if (existente) {
      existente.cantidad++;
    } else {
      cart.push({ id, nombre, precio, descripcion, cantidad: 1, instrucciones: "" });
    }
    renderCart();
  }

  function renderCart() {
    ordenLista.innerHTML = "";
    let total = 0;
    cart.forEach((item, i) => {
      total += item.cantidad * item.precio;
      ordenLista.innerHTML += `
        <li class="list-group-item">
          <div class="d-flex justify-content-between">
            <strong>${item.nombre}</strong>
            <span class="text-success">$${item.precio}</span>
          </div>
          <div class="d-flex align-items-center">
            <button class="btn btn-sm btn-danger me-2" onclick="changeQty(${i}, -1)">-</button>
            <span>${item.cantidad}</span>
            <button class="btn btn-sm btn-success ms-2" onclick="changeQty(${i}, 1)">+</button>
            <button class="btn btn-sm btn-outline-danger ms-auto" onclick="removeItem(${i})">🗑</button>
          </div>
          <input type="text" class="form-control form-control-sm mt-1"
            placeholder="Instrucciones..." value="${item.instrucciones}" onchange="updateInstr(${i}, this.value)">
        </li>`;
    });
    totalEl.textContent = `$${total.toFixed(2)}`;
  }

  function changeQty(i, d) {
    cart[i].cantidad += d;
    if (cart[i].cantidad <= 0) cart.splice(i, 1);
    renderCart();
  }
  function removeItem(i) { cart.splice(i, 1); renderCart(); }
  function updateInstr(i, v) { cart[i].instrucciones = v; }

  function setEntrega(tipo) { metodoEntregaSeleccionado = tipo; }

  function enviarPedido() {
    const pedido = {
      cliente: usuario,
      productos: cart,
      entrega: metodoEntregaSeleccionado,
      observaciones: document.getElementById("observaciones").value
    };
    console.log("Pedido generado:", pedido);
    alert("Pedido enviado (mira la consola)");
  }
	
	
	
	 function checkout() {
  if (cart.length === 0) {
    alert("Tu carrito está vacío. Agrega productos antes de comprar.");
    return;
  }

  const observacionesGenerales = document.getElementById('observaciones').value;

  const pedido = {
    cliente: {
      idc: usuario?.idc || "",
      nombre: usuario?.nombre || "",
      telefono: usuario?.telefono || "",
      direccion: usuario?.direccion || ""
    },
    productos: cart.map(item => ({
      id: item.id,
      nombre: item.nombre,
      descripcion: item.descripcion,
      cantidad: item.cantidad,
      precio: item.precio,
      instrucciones: item.instrucciones || ""
    })),
    tipo_entrega: metodoEntregaSeleccionado,
    observaciones: observacionesGenerales
  };

  console.log("✅ Pedido generado:");
  console.log(JSON.stringify(pedido, null, 2));

  guardarPedido(JSON.stringify(pedido));

  alert("¡Gracias por tu compra!");
  cart.length = 0;
  renderCart();
  document.getElementById('observaciones').value = '';
}

 function guardarPedido(datos) {
  console.log("Guardando...");
  fetch('app/ajax.php', {
    method: 'POST',
    headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
    body: `metodo=Pedido&datos=${encodeURIComponent(datos)}`
  })
  .then(res => res.json())
  .then(res => {
    if(res.status === 'success') {
      console.log('✅ Pedido guardado correctamente.');
    } else {
      console.warn('⚠️ Error al guardar el pedido:', res.message || res);
    }
  })
  .catch(err => {
    console.error('❌ Error AJAX al guardar el pedido:', err);
    alert('Ocurrió un error al guardar el pedido. Intenta nuevamente.');
  });
}


  // --- PASAR LOS CLIENTES DE PHP A JS ---
  const clientesData = <?php echo json_encode($clientes, JSON_HEX_TAG | JSON_HEX_APOS | JSON_HEX_QUOT | JSON_UNESCAPED_UNICODE); ?>;

  const clientesLista = document.getElementById('clientesLista');

  function renderClientes(list) {
    clientesLista.innerHTML = "";
    list.forEach(c => {
      const li = document.createElement("li");
      li.textContent = `${c.Nombre ?? ''} (${c.Telefono ?? ''})`;
      li.dataset.id = c.id ?? '';
      li.dataset.telefono = c.Telefono ?? '';
      li.dataset.direccion = c.Direccion ?? '';
      li.addEventListener("click", () => {
        // quitar activo a otros
        clientesLista.querySelectorAll("li").forEach(el => el.classList.remove("active"));
        li.classList.add("active");
        usuario = {
          idc: li.dataset.id,
          nombre: c.Nombre ?? '',
          telefono: c.Telefono ?? '',
          direccion: c.Direccion ?? ''
        };
        console.log("Cliente seleccionado:", usuario);
      });
      clientesLista.appendChild(li);
    });
  }

  // render inicial
  renderClientes(clientesData);

  // filtro clientes
  document.getElementById("buscadorClientes").addEventListener("input", function() {
    const f = this.value.toLowerCase().trim();
    const filtrados = clientesData.filter(c => {
      const idStr = String(c.id ?? '').toLowerCase();
      const nombre = String(c.Nombre ?? '').toLowerCase();
      const tel = String(c.Telefono ?? '').toLowerCase();
      const dir = String(c.Direccion ?? '').toLowerCase();
      return idStr.includes(f) || nombre.includes(f) || tel.includes(f) || dir.includes(f);
    });
    renderClientes(filtrados);
  });

  // Buscador productos
  document.getElementById("buscador").addEventListener("input", e => {
    const f = e.target.value.toLowerCase();
    document.querySelectorAll("#productosLista .producto-card").forEach(div => {
      div.style.display = div.dataset.nombre.includes(f) ? "flex" : "none";
    });
  });
</script>
</body>
</html>
