<?php
	
switch($pre){
	case "fb":
		$pr=4;
	break;
	case "pz":
		$pr=2;
	break;	
	case "pu":
		$pr=3;
	break;	
	
	default:
		$pr=3;
	break;
}

$consultaP = "SELECT IDCa, Categoria, Descripcion_Corta, Descripcion, Precio_$pr as Precio, Visible FROM MicroSi_Datos.`$IDs-Catalogo`, MicroSi_Datos.`$IDs-Catalogo_Precio` WHERE IDCa=ID_Catalogo AND Estado='Disponible';";
$datosP = $db->tablasDB2($consultaP);

function obtenerCategorias($array) {
    $categorias = array();
    foreach ($array as $item) {
        if (!empty($item['Categoria']) && !in_array($item['Categoria'], $categorias)) {
            $categorias[] = $item['Categoria'];
        }
    }
    return $categorias;
}

$categorias = obtenerCategorias($datosP);

// Definir la categoría por defecto como "Accesorios" y si está vacía, seleccionar "Todas"
$CategoriaDefault = !empty($CategoriaDefault) ? $CategoriaDefault : 'todas';
$CategoriaDefault = $CategoriaD; // Establece la categoría predeterminada aquí

?>

<!DOCTYPE html>
<html lang="es">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Catálogo</title>
<!-- Enlaces a archivos CSS -->
<link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">

<!-- Estilos personalizados -->
<style>
/* Estilo para fijar el footer al final de la página */
footer {
    position: fixed;
    bottom: 0;
    width: 100%;
    background-color: #f8f9fa;
}
img.lazy {
    opacity: 0;
    transition: opacity 0.3s;
}
img.lazy.loaded {
    opacity: 1;
}
</style>
</head>
<body> 
<!-- Encabezado -->
<header>
  <nav class="navbar navbar-expand-lg navbar-light bg-light"> <a class="navbar-brand" href="#"><?php echo $primerElemento['Nombre_Empresa'];?></a>
    <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation"> <span class="navbar-toggler-icon"></span> </button>
    <div class="collapse navbar-collapse" id="navbarNav">
      <ul class="navbar-nav">
        <li class="nav-item active"> <a class="nav-link" href="#">Inicio <span class="sr-only">(current)</span></a> </li>
        <!-- Agrega más elementos del menú si los necesitas -->
      </ul>
    </div>
  </nav>
</header>

<!-- Selector de categorías y campo de búsqueda -->
<div class="container my-4">
  <div class="input-group">
    <div class="input-group-prepend">
      <label class="input-group-text" for="categoriaSelect"><i class="fa fa-tags"></i></label>
    </div>
    <select class="custom-select" id="categoriaSelect">
      <option value="todas" <?php echo ($CategoriaDefault == 'todas') ? 'selected' : ''; ?>>Todas las categorías</option>
      <?php
      foreach ($categorias as $opcion) {
          echo "<option value='" . htmlspecialchars($opcion) . "'" . (($CategoriaDefault == $opcion) ? ' selected' : '') . ">$opcion</option>";
      }
      ?>
    </select>
    <div class="input-group-append">
      <label class="input-group-text" for="buscarInput"><i class="fa fa-search"></i></label>
    </div>
    <input type="text" class="form-control" id="buscarInput" placeholder="Buscar en productos...">
  </div>
</div>

<!-- Contenedor de productos -->
<div class="container" id="productosContainer">
  <div class="row">
    <?php
    foreach ($datosP as $producto) {
        $info = json_decode($producto['Visible'], true);
        $imagen_url = $info['imagen'];
        $color_contorno = $info['color'];
        ?>
    <div class="col-md-4 mb-4 <?php echo htmlspecialchars($producto['Categoria']); ?> tarj">
      <div class="card" style="border-color: <?php echo htmlspecialchars($color_contorno); ?>"> 
        <img data-src="<?php echo htmlspecialchars($imagen_url); ?>" class="card-img-top lazy" alt="...">
        <div class="card-body">
          <h5 class="card-title"><?php echo htmlspecialchars($producto['Descripcion_Corta']); ?></h5>
          <p class="card-text"><?php echo htmlspecialchars($producto['Descripcion']); ?></p>
          <p class="card-text">Precio: $<?php echo htmlspecialchars($producto['Precio']); ?></p>
        </div>
      </div>
    </div>
    <?php
    }
    ?>
  </div>
</div>
<!-- Espacio en blanco -->
<div style="height: 150px;"></div>

<!-- Footer -->
<footer class="footer py-3">
  <div class="container">
    <div class="d-flex justify-content-end">
      <div class="col-md-3 text-center"> <a href="#" class="text-dark" data-toggle="modal" data-target="#infoModal"><i class="fa fa-info-circle fa-3x"></i></a> </div>
      <div class="col-md-3 text-center"> <a href="https://api.whatsapp.com/send?phone=52<?php echo $primerElemento['Telefono2'];?>" class="text-success" target="_blank"><i class="fa fa-whatsapp fa-3x"></i></a> </div>
      <div class="col-md-3 text-center"> <a href="https://m.me/techsicomcorp" class="text-primary" target="_blank"><i class="fa fa-comments-o fa-3x"></i></a> </div>
      <div class="col-md-3 text-center"> <a href="tel:<?php echo $primerElemento['Telefono2'];?>" class="text-dark"><i class="fa fa-phone fa-3x"></i></a> </div>
    </div>
  </div>
</footer>

<!-- Modals --> 
<!-- Modal de Información -->
<div class="modal fade" id="infoModal" tabindex="-1" role="dialog" aria-labelledby="infoModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="infoModalLabel">Información de contacto</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Cerrar"> <span aria-hidden="true">&times;</span> </button>
      </div>
      <div class="modal-body">
        <div class="row">
    <div class="col-md-6">
        <h5>Nombre del Negocio</h5>
        <p><i class="fa fa-dot-circle-o"></i> <?php echo $primerElemento['Nombre_Empresa'];?></p>
        <h5>Dirección</h5>
        <p><i class="fa fa-map-marker"></i> <?php echo $primerElemento['Direccion'];?></p>
        <h5>Teléfono</h5>
        <p><i class="fa fa-phone"></i> <?php echo $primerElemento['Telefono'];?></p>
        <p><i class="fa fa-phone"></i> <?php echo $primerElemento['Telefono2'];?></p>
    </div>
    <div class="col-md-6">
        <h5>Ubicación</h5>
        <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3764.706944123032!2d-99.65388591534473!3d19.29325118945535!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x85d1fdb755fda45d%3A0xef48dcee9d9bce21!2sUbicaci%C3%B3n%20de%20ejemplo!5e0!3m2!1sen!2smx!4v1641411239153" width="100%" height="300" style="border:0;" allowfullscreen="" loading="lazy"></iframe>
        <a href="https://maps.app.goo.gl/mByKnPa7Vw7do59JA" target="_blank" class="btn btn-outline-primary btn-block"> <i class="fa fa-map-marker"></i> Ver ubicación en Google Maps </a>
    </div>
</div>
</div>
</div>
</div>

<!-- Enlaces a archivos JS -->
<script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.4/dist/umd/popper.min.js"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
<!-- Script para cargar imágenes de manera perezosa -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.lazy/1.7.10/jquery.lazy.min.js"></script>

<!-- Script para filtrar productos por categoría y búsqueda --> 
<script>
$(document).ready(function() {
    console.log("Documento listo.");

    $('#categoriaSelect').change(function() {
        console.log("Cambio detectado en el selector de categorías.");
        filtrarProductos();
    });

    $('#buscarInput').on('input', function() {
        console.log("Cambio detectado en el campo de búsqueda.");
        filtrarProductos();
    });

    // Ejecutar la función de filtrado inicialmente
    filtrarProductos();

    function filtrarProductos() {
        var categoria = $('#categoriaSelect').val();
        var busqueda = $('#buscarInput').val().toLowerCase();

        $('#productosContainer').find('.tarj').each(function() {
            var tarjeta = $(this);
            var titulo = tarjeta.find('.card-title').text().toLowerCase();
            var descripcion = tarjeta.find('.card-text').text().toLowerCase();
            var coincideCategoria = (categoria == 'todas' || tarjeta.hasClass(categoria));
            var coincideBusqueda = (titulo.indexOf(busqueda) > -1 || descripcion.indexOf(busqueda) > -1);

            if (coincideCategoria && coincideBusqueda) {
                tarjeta.show();
            } else {
                tarjeta.hide();
            }
        });
    }
});
</script>

<!-- Script para lazy loading de imágenes -->
<script>
document.addEventListener("DOMContentLoaded", function() {
    let lazyImages = [].slice.call(document.querySelectorAll("img.lazy"));

    if ("IntersectionObserver" in window) {
        let lazyImageObserver = new IntersectionObserver(function(entries, observer) {
            entries.forEach(function(entry) {
                if (entry.isIntersecting) {
                    let lazyImage = entry.target;
                    lazyImage.src = lazyImage.dataset.src;
                    lazyImage.classList.remove("lazy");
                    lazyImage.classList.add("loaded");
                    lazyImageObserver.unobserve(lazyImage);
                }
            });
        });

        lazyImages.forEach(function(lazyImage) {
            lazyImageObserver.observe(lazyImage);
        });
    } else {
        // Fallback para navegadores que no soportan IntersectionObserver
        let active = false;

        const lazyLoad = function() {
            if (active === false) {
                active = true;


                setTimeout(function() {
                    lazyImages.forEach(function(lazyImage) {
                        if ((lazyImage.getBoundingClientRect().top <= window.innerHeight && lazyImage.getBoundingClientRect().bottom >= 0) && getComputedStyle(lazyImage).display !== "none") {
                            lazyImage.src = lazyImage.dataset.src;
                            lazyImage.classList
.remove("lazy");
                            lazyImage.classList.add("loaded");

                            lazyImages = lazyImages.filter(function(image) {
                                return image !== lazyImage;
                            });

                            if (lazyImages.length === 0) {
                                document.removeEventListener("scroll", lazyLoad);
                                window.removeEventListener("resize", lazyLoad);
                                window.removeEventListener("orientationchange", lazyLoad);
                            }
                        }
                    });

                    active = false;
                }, 200);
            }
        };

        document.addEventListener("scroll", lazyLoad);
        window.addEventListener("resize", lazyLoad);
        window.addEventListener("orientationchange", lazyLoad);
    }
});
</script>

</body>
</html>
