<div class="container mt-5">
  <h1>Formulario de Servicios</h1>
  
  <?php
  if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Procesar el formulario y validar en el servidor
    $errors = [];

    // Definir los campos esperados (incluyendo el nuevo tipo checkbox)
    $json_data = '[
      {"name": "Nombre del Servicio", "type": "text", "label": "Nombre del Servicio", "required": true},
      {"name": "Descripción", "type": "textarea", "label": "Descripción del Servicio", "required": false},
      {"name": "Precio", "type": "number", "label": "Precio", "required": true},
      {"name": "Fecha de inicio", "type": "date", "label": "Fecha de Inicio", "required": true},
      {"name": "Activo", "type": "checkbox", "label": "¿El servicio está activo?", "required": false}
    ]';

    // Decodificar la cadena JSON
    $form_fields = json_decode($json_data, true);

    // Validación del servidor
    foreach ($form_fields as $field) {
      $name = $field['name'];
      $required = $field['required'];

      if ($field['type'] == 'checkbox') {
        // Para los checkboxes, considerar "unchecked" como no enviado 
        if ($required && !isset($_POST[$name])) {
          $errors[] = "El campo '{$field['label']}' es obligatorio.";
        }
      } else {
        if ($required && empty($_POST[$name])) {
          $errors[] = "El campo '{$field['label']}' es obligatorio.";
        }
      }
    }

    // Mostrar errores o procesar datos
    if (!empty($errors)) {
      echo "<div class='alert alert-danger'><ul>";
      foreach ($errors as $error) {
        echo "<li>$error</li>";
      }
      echo "</ul></div>";
    } else {
      echo "<div class='alert alert-success'>Formulario enviado con éxito.</div>";
      // Procesar los datos, guardarlos, etc.
      echo "<pre>";
      print_r($_POST);
      echo "</pre>";
    }
  }
  ?>

  <form action="" method="POST" id="serviceForm" novalidate>
    <?php
    // Simulación de la cadena JSON
    $json_data = '[
      {"name": "Nombre del Servicio", "type": "text", "label": "Nombre del Servicio", "required": true},
      {"name": "Descripción", "type": "textarea", "label": "Descripción del Servicio", "required": false},
      {"name": "Precio", "type": "number", "label": "Precio", "required": true},
      {"name": "Fecha de inicio", "type": "date", "label": "Fecha de Inicio", "required": true},
      {"name": "Activo", "type": "checkbox", "label": "¿El servicio está activo?", "required": false}
    ]';

    // Decodificar la cadena JSON
    $form_fields = json_decode($json_data, true);

    // Generar campos del formulario
    foreach ($form_fields as $field) {
      $required = $field['required'] ? 'required' : '';
      $label = $field['label'];
      $name = $field['name'];
      $type = $field['type'];

      echo '<div class="mb-3">';
      echo "<label for='$name' class='form-label'>$label</label>";

      if ($type == 'textarea') {
        echo "<textarea class='form-control' name='$name' id='$name' $required></textarea>";
      } elseif ($type == 'checkbox') {
        echo "<input type='$type' class='form-check-input' name='$name' id='$name'>";
      } else {
        echo "<input type='$type' class='form-control' name='$name' id='$name' $required>";
      }

      echo '</div>';
    }
    ?>
    <button type="submit" class="btn btn-primary">Enviar</button>
  </form>
</div>

<script>
  // Validación del lado del cliente usando JavaScript
  document.getElementById('serviceForm').addEventListener('submit', function(event) {
    let formIsValid = true;
    let formFields = <?php echo $json_data; ?>; // Obtener los campos del JSON

    formFields.forEach(function(field) {
      let input = document.getElementsByName(field.name)[0];

      if (field.type === 'checkbox') {
        // Validación para checkbox
        if (field.required && !input.checked) {
          formIsValid = false;
          input.classList.add('is-invalid');
        } else {
          input.classList.remove('is-invalid');
          input.classList.add('is-valid');
        }
      } else {
        if (field.required && input.value.trim() === '') {
          formIsValid = false;
          input.classList.add('is-invalid');
        } else {
          input.classList.remove('is-invalid');
          input.classList.add('is-valid');
        }
      }
    });

    if (!formIsValid) {
      event.preventDefault(); // Prevenir el envío del formulario si no es válido
      alert('Por favor, complete los campos obligatorios.');
    }
  });
</script>
