<?php
set_time_limit(0);

$host = "167.172.224.160";
$port = 5000; // Puedes usar 5000, 7000 o cualquier puerto no usado
// Crear socket TCP
$sock = socket_create(AF_INET, SOCK_STREAM, SOL_TCP);
socket_bind($sock, $host, $port);
socket_listen($sock);

echo "Servidor GPS escuchando en $host:$port...\n";

while (true) {
    // Espera una conexión entrante
    $client = socket_accept($sock);
    
    // Lee 2048 bytes del tracker
    $data = socket_read($client, 2048);
    $data = trim($data);

    if ($data) {
        echo "Recibido: $data\n";

        // Guardar en archivo de log
        file_put_contents(
            "gps_eventos.log",
            date("Y-m-d H:i:s") . " => " . $data . "\n",
            FILE_APPEND
        );

        // Muchos trackers necesitan respuesta
        socket_write($client, "OK\n");
    }

    socket_close($client);
}

socket_close($sock);
?>
