<?php
// Conexion.php
header("Access-Control-Allow-Origin: *");

class Conexion {
    private $conn;
    
    // Configuración Base (Usuario "Root" o superusuario)
    private $host = "167.172.224.160";
    private $user = "root";
    private $pass = "33comRxXMysql"; 

    public function __construct($db_name = "") {
        try {
            // Si no envían base de datos, conectamos sin seleccionar una (útil para crear DBs)
            $dsn = "mysql:host=" . $this->host . ";charset=utf8mb4";
            if ($db_name != "") {
                $dsn .= ";dbname=" . $db_name;
            }

            $this->conn = new PDO($dsn, $this->user, $this->pass);
            $this->conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            // Esto permite que el fetch devuelva arrays asociativos limpios
            $this->conn->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_ASSOC);

        } catch(PDOException $e) {
            echo json_encode(["status" => "error", "message" => "Error Conexion: " . $e->getMessage()]);
            exit;
        }
    }

    // Función para SELECT (Devuelve datos + estructura de columnas)
    public function obtenerDatos($sql) {
        try {
            $stmt = $this->conn->prepare($sql);
            $stmt->execute();
            
            $datos = $stmt->fetchAll();
            
            // Obtenemos los nombres de las columnas (metadatos)
            $columnas = [];
            if ($stmt->columnCount() > 0) {
                for ($i = 0; $i < $stmt->columnCount(); $i++) {
                    $meta = $stmt->getColumnMeta($i);
                    $columnas[] = $meta['name'];
                }
            }

            return ["status" => "success", "data" => $datos, "columns" => $columnas];

        } catch(PDOException $e) {
            return ["status" => "error", "message" => $e->getMessage(), "sql" => $sql];
        }
    }

    // Función para INSERT, UPDATE, DELETE, CREATE, DROP
    public function ejecutarConsulta($sql) {
        try {
            $stmt = $this->conn->prepare($sql);
            $resultado = $stmt->execute();
            
            // Intentamos obtener el ID si fue un insert
            $lastId = $this->conn->lastInsertId();

            return [
                "status" => "success", 
                "message" => "Ejecución correcta", 
                "rows_affected" => $stmt->rowCount(),
                "last_id" => $lastId
            ];

        } catch(PDOException $e) {
            return ["status" => "error", "message" => $e->getMessage(), "sql" => $sql];
        }
    }
}
?>