<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Monitor GPS Server</title>

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <style>
        body {
            background: linear-gradient(135deg, #1e3c72, #2a5298);
            min-height: 100vh;
        }
        .card {
            border-radius: 15px;
        }
        #console {
            background-color: #111;
            color: #00ff9d;
            font-family: monospace;
            height: 350px;
            overflow-y: auto;
            padding: 10px;
            border-radius: 8px;
            box-shadow: inset 0 0 10px #000;
        }
        .status-dot {
            width: 14px;
            height: 14px;
            border-radius: 50%;
            display: inline-block;
        }
        .running {
            background-color: #28a745;
            box-shadow: 0 0 10px #28a745;
        }
        .stopped {
            background-color: #dc3545;
        }
    </style>
</head>

<body class="p-4">

<div class="container">
    <div class="card shadow-lg">
        <div class="card-header d-flex justify-content-between align-items-center bg-dark text-white">
            <h4 class="m-0">🛰️ Monitor del Servidor GPS</h4>
            <div>
                Estado: <strong id="statusText">Desconocido</strong>
                <span id="statusDot" class="status-dot stopped ms-2"></span>
            </div>
        </div>

        <div class="card-body">

            <div class="text-center mb-4">
                <button id="btnStart" class="btn btn-success btn-lg px-4">INICIAR</button>
                <button id="btnStop" class="btn btn-danger btn-lg px-4" disabled>DETENER</button>
            </div>

            <div class="alert alert-info text-center">
                <h5 class="m-0">⏱️ Tiempo activo: <span id="timer">00:00:00</span></h5>
            </div>

            <label class="fw-bold">📟 Logs del servidor:</label>
            <pre id="console">Cargando...</pre>

        </div>
    </div>
</div>

<script>
    let serverUptime = 0;

    function formatTime(sec) {
        const h = String(Math.floor(sec / 3600)).padStart(2,'0');
        const m = String(Math.floor((sec % 3600)/60)).padStart(2,'0');
        const s = String(sec % 60).padStart(2,'0');
        return `${h}:${m}:${s}`;
    }

    function updateStatus() {
        $.post('../gps_server/gps_server_status.php', { action:'status' }, function(data){

            // Logs
            if(data.logs){
                $('#console').text(data.logs);
                let c = document.getElementById("console");
                c.scrollTop = c.scrollHeight;
            }

            // Estado general
            if(data.running){
                $('#statusText').text('Corriendo');
                $('#statusDot').removeClass('stopped').addClass('running');
                $('#btnStart').prop('disabled', true);
                $('#btnStop').prop('disabled', false);

                serverUptime = data.uptime;
            } else {
                $('#statusText').text('Detenido');
                $('#statusDot').removeClass('running').addClass('stopped');
                $('#btnStart').prop('disabled', false);
                $('#btnStop').prop('disabled', true);

                serverUptime = 0;
                $('#timer').text("00:00:00");
            }

        },'json');
    }

    setInterval(updateStatus, 2000);
    setInterval(() => {
        if($('#btnStop').is(':enabled')){
            serverUptime++;
            $('#timer').text(formatTime(serverUptime));
        }
    }, 1000);

    $('#btnStart').click(() => {
        $.post('../gps_server/gps_server_status.php', { action:'start' }, updateStatus, 'json');
    });

    $('#btnStop').click(() => {
        if(confirm("¿Seguro que deseas detener el servidor GPS?"))
            $.post('../gps_server/gps_server_status.php', { action:'stop' }, updateStatus, 'json');
    });

    updateStatus();
</script>

</body>
</html>
