<?php
// ========================================================
// CONFIGURACIÓN DE BASE DE DATOS
// ========================================================
$host = "localhost";
$user = "root";
$pass = "33comRxXMysql";
$bd   = "MS_Usuario";

$conn = new mysqli($host, $user, $pass, $bd);
$conn->set_charset("utf8mb4");

$acceso = false;
$mensaje = "";
$error = "";

// ========================================================
// FORMULARIO 1: PEDIR CONTRASEÑA DE ACCESO
// ========================================================
if (isset($_POST["entrar"])) {
    if ($_POST["claveAcceso"] === "33comRxX") {
        $acceso = true;
    } else {
        $error = "Contraseña de acceso incorrecta.";
    }
}

// ========================================================
// FORMULARIO 2: CAMBIAR CONTRASEÑA + IDU MANUAL
// ========================================================
if (isset($_POST["cambiarPass"])) {

    $idUsuario  = intval($_POST["idu"]);
    $passNueva  = $_POST["passNueva"];
    $passConfirm = $_POST["passConfirm"];

    if ($idUsuario <= 0) {
        $error = "Debe ingresar un IDU válido.";
        $acceso = true;
    } elseif ($passNueva !== $passConfirm) {
        $error = "La nueva contraseña y la confirmación no coinciden.";
        $acceso = true;
    } else {

        // Generar hash
        $nuevoHash = password_hash($passNueva, PASSWORD_DEFAULT);

        // Actualizar contraseña en BD
        $sql = "UPDATE Usuarios_Datos SET Password = ? WHERE IDU = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("si", $nuevoHash, $idUsuario);

        if ($stmt->execute()) {
            if ($stmt->affected_rows > 0) {
                $mensaje = "Contraseña actualizada correctamente para el usuario con IDU $idUsuario.";
            } else {
                $error = "No se encontró un usuario con ese IDU.";
            }
        } else {
            $error = "Error al actualizar: " . $conn->error;
        }

        $stmt->close();
        $acceso = true;
    }
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Cambiar Contraseña</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>

<body class="bg-light d-flex align-items-center justify-content-center vh-100">

<div style="width: 380px;">

    <?php if (!$acceso): ?>
    <!-- ========================================================
         FORM 1: ACCESO
    ========================================================= -->
    <div class="card shadow p-4">
        <h4 class="text-center mb-3">Acceso</h4>

        <?php if (!empty($error)): ?>
            <div class="alert alert-danger text-center py-1"><?= $error ?></div>
        <?php endif; ?>

        <form method="POST">
            <div class="mb-3">
                <label class="form-label">Contraseña de acceso</label>
                <input type="password" name="claveAcceso" class="form-control" required autofocus>
            </div>

            <button name="entrar" class="btn btn-primary w-100">Entrar</button>
        </form>
    </div>

    <?php else: ?>
    <!-- ========================================================
         FORM 2: CAMBIAR CONTRASEÑA CON IDU
    ========================================================= -->
    <div class="card shadow p-4">
        <h4 class="text-center mb-3">Cambiar Contraseña</h4>

        <?php if (!empty($mensaje)): ?>
            <div class="alert alert-success text-center py-1"><?= $mensaje ?></div>
        <?php endif; ?>

        <?php if (!empty($error)): ?>
            <div class="alert alert-danger text-center py-1"><?= $error ?></div>
        <?php endif; ?>

        <form method="POST">

            <div class="mb-3">
                <label class="form-label">IDU del usuario</label>
                <input type="number" name="idu" class="form-control" required min="1">
            </div>

            <div class="mb-3">
                <label class="form-label">Nueva contraseña</label>
                <input type="password" name="passNueva" class="form-control" required>
            </div>

            <div class="mb-3">
                <label class="form-label">Confirmar nueva contraseña</label>
                <input type="password" name="passConfirm" class="form-control" required>
            </div>

            <button name="cambiarPass" class="btn btn-success w-100">Actualizar</button>
        </form>
    </div>

    <?php endif; ?>

</div>

</body>
</html>
