<?php
header('Content-Type: application/json; charset=utf-8');
session_start();
require_once '../Conexion.php';

// Depuración activa para ver errores en la consola del navegador
ini_set('display_errors', 1);
error_reporting(E_ALL);

$NOMBRE_BD = "MS_Usuario"; 
$db = new Conexion($NOMBRE_BD);

$input = json_decode(file_get_contents('php://input'), true);
$action = $input['action'] ?? '';
$data   = $input['data'] ?? [];

switch ($action) {
    case 'login':
        $usuario = addslashes(trim($data['usuario']));
        $password = trim($data['password']);

        // Buscamos en Usuarios_Datos según tu esquema
        $sql = "SELECT IDU, User, Password, Estado FROM Usuarios_Datos WHERE User = '$usuario'";
        $resultado = $db->obtenerDatos($sql);

        if ($resultado['status'] == 'success' && count($resultado['data']) > 0) {
            $row = $resultado['data'][0];
            if (password_verify($password, $row['Password'])) {
                if ($row['Estado'] == "Activo") {
                    $_SESSION['IDU'] = $row['IDU'];
                    $_SESSION['Usuario'] = $row['User'];
                    $_SESSION['Acceso'] = 'AccesoSiqueSi';
                    echo json_encode(['status' => 'success', 'message' => 'Bienvenido ' . $row['User']]);
                } else {
                    echo json_encode(['status' => 'error', 'message' => 'Usuario inactivo.']);
                }
            } else {
                echo json_encode(['status' => 'error', 'message' => 'Contraseña incorrecta.']);
            }
        } else {
            echo json_encode(['status' => 'error', 'message' => 'Usuario no encontrado.']);
        }
        break;

    case 'register':
        $userReg = addslashes(trim($data['usuario_reg']));
        $mailReg = addslashes(trim($data['correo_reg']));
        $passReg = trim($data['pass_reg']);

        // 1. Verificar duplicados en Usuarios_Datos (User) y Usuarios (EMail)
        $checkUser = $db->obtenerDatos("SELECT IDU FROM Usuarios_Datos WHERE User = '$userReg'");
        $checkMail = $db->obtenerDatos("SELECT EMail FROM Usuarios WHERE EMail = '$mailReg'");

        if (count($checkUser['data']) > 0 || count($checkMail['data']) > 0) {
            echo json_encode(['status' => 'error', 'message' => 'El usuario o el correo ya existen.']);
            break;
        }

        $passHash = password_hash($passReg, PASSWORD_DEFAULT);
        $token = strtoupper(bin2hex(random_bytes(5))); // Genera el Token de 10 caracteres (hex)
        
        // IMPORTANTE: Agregué IDUg = 1 (Ajusta este valor según tus grupos)
        $sql1 = "INSERT INTO Usuarios_Datos (IDUg, Rol, User, Password, Estado, Token, Visible, Datos) 
                 VALUES (1, 'Admin', '$userReg', '$passHash', 'Activo', '$token', '{}', '{}')";
        
        $res1 = $db->ejecutarConsulta($sql1);
	

        if ($res1['status'] == 'success') {
            $nuevoID = $res1['last_id']; 
			
			$sqlUpdate = "UPDATE Usuarios_Datos SET IDUg = $nuevoID WHERE IDU =  $nuevoID";
            $db->ejecutarConsulta($sqlUpdate);

            // 2. Insertar en Usuarios (Usando el IDU recién creado)
            $sql2 = "INSERT INTO Usuarios (IDU, Nombre, EMail) VALUES ($nuevoID, '$userReg', '$mailReg')";
            $db->ejecutarConsulta($sql2);

            // 3. Insertar en Configuracion (Nota: la columna es IDCo)
            $sql3 = "INSERT INTO Configuracion (IDCo, Nombre) VALUES ($nuevoID, '$userReg')";
            $db->ejecutarConsulta($sql3);

            // 4. Insertar en Impresora (Si existe la tabla)
            $db->ejecutarConsulta("INSERT INTO Impresora_Configuracion (IDI) VALUES ($nuevoID)");

            echo json_encode(['status' => 'success', 'message' => 'Cuenta creada correctamente.']);
        } else {
            echo json_encode([
                'status' => 'error', 
                'message' => 'Error en la base de datos al crear Usuarios_Datos.',
                'debug' => $res1['error'] ?? 'Sin detalles'
            ]);
        }
        break;

    case 'forgot':
        $mailForgot = addslashes(trim($data['correo_forgot']));
        // Buscamos el IDU a través del correo en la tabla Usuarios
        $sqlForgot = "SELECT u.IDU, ud.User, u.EMail 
                      FROM Usuarios u 
                      INNER JOIN Usuarios_Datos ud ON u.IDU = ud.IDU 
                      WHERE u.EMail = '$mailForgot'";
        
        $resForgot = $db->obtenerDatos($sqlForgot);

        if ($resForgot['status'] == 'success' && count($resForgot['data']) > 0) {
            $user = $resForgot['data'][0];
            $enviado = enviarCorreo($user['EMail'], $user['User']);
            if ($enviado) {
                echo json_encode(['status' => 'success', 'message' => 'Correo de recuperación enviado.']);
            } else {
                echo json_encode(['status' => 'error', 'message' => 'Error al enviar el email.']);
            }
        } else {
            echo json_encode(['status' => 'error', 'message' => 'Correo no registrado.']);
        }
        break;
}

function enviarCorreo($destinatario, $usuario) {
    $asunto = "Recuperar Contraseña - MicroSi";
    $headers = "MIME-Version: 1.0\r\nContent-type:text/html;charset=UTF-8\r\nFrom: Soporte <soporte@techsicom.com>";
    $mensaje = "Hola $usuario, haz clic aquí para resetear tu clave: <a href='https://tusitio.com/reset?u=$usuario'>Recuperar</a>";
    return mail($destinatario, $asunto, $mensaje, $headers);
}