<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>MicroSi - Techsicom</title>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <style>
        @import url("https://fonts.googleapis.com/css2?family=Quicksand:wght@300&display=swap");
        * { margin: 0; padding: 0; box-sizing: border-box; font-family: "Quicksand", sans-serif; }
        body { display: flex; justify-content: center; align-items: center; min-height: 100vh; background: #111; overflow: hidden; }
        .ring { position: relative; width: 450px; height: 450px; display: flex; justify-content: center; align-items: center; transition: 0.5s ease; }
        .ring.big { transform: scale(1.1); }
        .ring i { position: absolute; inset: 0; border: 2px solid #fff; transition: 0.5s; }
        .ring i:nth-child(1) { border-radius: 38% 62% 63% 37% / 41% 44% 56% 59%; animation: animate 6s linear infinite; }
        .ring i:nth-child(2) { border-radius: 41% 44% 56% 59%/38% 62% 63% 37%; animation: animate 4s linear infinite; }
        .ring i:nth-child(3) { border-radius: 41% 44% 56% 59%/38% 62% 63% 37%; animation: animate2 10s linear infinite; }
        .ring:hover i { border: 6px solid var(--clr); filter: drop-shadow(0 0 20px var(--clr)); }
        @keyframes animate { 0% { transform: rotate(0deg); } 100% { transform: rotate(360deg); } }
        @keyframes animate2 { 0% { transform: rotate(360deg); } 100% { transform: rotate(0deg); } }
        .form-box { width: 250px; position: absolute; display: none; flex-direction: column; gap: 18px; text-align: center; }
        .form-box.active { display: flex; }
        .form-box h2 { color: #fff; margin-bottom: 10px; }
        .inputBx input { width: 100%; padding: 12px 20px; background: transparent; border: 1px solid #fff; border-radius: 40px; font-size: 1em; color: #fff; outline: none; }
        .inputBx input[type="submit"] { background: linear-gradient(45deg, #ff357a, #fff172); border: none; cursor: pointer; color: #000; font-weight: bold; }
        .links { display: flex; justify-content: space-between; padding: 0 10px; }
        .links a { color: #fff; cursor: pointer; text-decoration: none; font-size: 0.85em; }
        .swal2-popup { background: #1e1e1e !important; color: #fff !important; border: 1px solid #ff357a; }
    </style>
</head>
<body>

<div class="ring">
    <i style="--clr:#00ff0a;"></i><i style="--clr:#ff0057;"></i><i style="--clr:#fffd44;"></i>

    <div id="loginForm" class="form-box active">
        <h2>MicroSi</h2>
        <div class="inputBx"><input type="text" name="usuario" placeholder="Usuario"></div>
        <div class="inputBx"><input type="password" name="password" placeholder="Contraseña"></div>
        <div class="inputBx"><input type="submit" value="Iniciar sesión"></div>
        <div class="links">
            <a onclick="showForm('forgotForm')">¿Olvidaste la clave?</a>
            <a onclick="showForm('registerForm')">Registrar</a>
        </div>
    </div>

    <div id="registerForm" class="form-box">
        <h2>Nuevo Usuario</h2>
        <div class="inputBx"><input type="text" name="usuario_reg" placeholder="Usuario"></div>
        <div class="inputBx"><input type="email" name="correo_reg" placeholder="Correo"></div>
        <div class="inputBx"><input type="password" name="pass_reg" placeholder="Contraseña"></div>
        <div class="inputBx"><input type="submit" value="Crear cuenta"></div>
        <div class="links"><a onclick="showForm('loginForm')">Volver al inicio</a></div>
    </div>

    <div id="forgotForm" class="form-box">
        <h2>Recuperar</h2>
        <div class="inputBx"><input type="email" name="correo_forgot" placeholder="Tu correo registrado"></div>
        <div class="inputBx"><input type="submit" value="Enviar enlace"></div>
        <div class="links"><a onclick="showForm('loginForm')">Volver al inicio</a></div>
    </div>
</div>

<script>
const ACTION_MAP = { loginForm: 'login', registerForm: 'register', forgotForm: 'forgot' };

function showForm(id) {
    document.querySelectorAll('.form-box').forEach(f => f.classList.remove('active'));
    document.getElementById(id).classList.add('active');
    const ring = document.querySelector(".ring");
    (id === "registerForm") ? ring.classList.add("big") : ring.classList.remove("big");
}

document.querySelectorAll(".form-box input[type='submit']").forEach(btn => {
    btn.addEventListener("click", function(e) {
        e.preventDefault();
        const formBox = this.closest(".form-box");
        const action = ACTION_MAP[formBox.id];
        const inputs = formBox.querySelectorAll("input:not([type='submit'])");
        let data = {};
        
        for (let input of inputs) {
            if (!input.value.trim()) {
                Swal.fire({ icon: 'warning', title: 'Campo requerido', text: `Completa el campo: ${input.placeholder}`, confirmButtonColor: '#ff357a' });
                return;
            }
            data[input.name] = input.value;
        }

        fetch('../librerias/AJAX/Login.php', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({ action, data })
        })
        .then(res => res.json())
        .then(res => {
            if (res.status === 'success') {
                if (action === 'login') {
                    // REDIRECCIÓN DIRECTA SIN ALERTA
                    window.location.href = '../Index';
                } else {
                    // Alertas para registro y recuperación
                    Swal.fire({ icon: 'success', title: 'Completado', text: res.message, confirmButtonColor: '#00ff0a' })
                    .then(() => showForm('loginForm'));
                }
            } else {
                Swal.fire({ icon: 'error', title: 'Error', text: res.message, confirmButtonColor: '#ff357a' });
            }
        })
        .catch(() => Swal.fire({ icon: 'error', title: 'Error', text: 'Error de conexión con el servidor.' }));
    });
});
</script>
</body>
</html>