<?php
// ====================================================================
// 1. REUTILIZAR TU CLASE CONEXION.PHP
// ====================================================================

// Ajusta esta ruta según donde esté tu archivo real (ej: 'librerias/Conexion.php')
require_once '../librerias/Conexion.php'; 

// Instanciamos tu clase conectando a la BD de usuarios
// Asumo que tu constructor permite pasar el nombre de la BD: new Conexion("MS_Usuario")
$db = new Conexion("MS_Usuario"); 

$arbolMenu = [];

// ====================================================================
// 2. OBTENER DATOS USANDO TU MÉTODO 'obtenerDatos'
// ====================================================================
try {
    $sql = "SELECT Menu_Catalogo.IDM AS IDM, Grupo, NombreGrupo, NombreMenu, Descripcion, Link, Icono 
            FROM Menu_Catalogo, Aplicaciones
			where Menu_Catalogo.IDM=Aplicaciones.IDM AND IDU=$IDU
            ORDER BY Grupo ASC, Aplicaciones.IDM ASC"; 
	//echo $sql;

    // Llamamos a tu función existente
    $respuesta = $db->obtenerDatos($sql);
	
	//print_r($respuesta);

    // Tu clase devuelve un array con estructura ["status"=>"...", "data"=>[...]]
    // Así que extraemos 'data' que es donde están las filas
    $menuItems = (isset($respuesta['data'])) ? $respuesta['data'] : [];

    // ====================================================================
    // 3. ESTRUCTURAR EL ÁRBOL (Agrupar por NombreGrupo)
    // ====================================================================
    foreach ($menuItems as $row) {
        $nomGrupo = $row['NombreGrupo']; // Ej: "Ventas"
        
        if (!isset($arbolMenu[$nomGrupo])) {
            $arbolMenu[$nomGrupo] = [];
        }
        
        $arbolMenu[$nomGrupo][] = $row;
    }

} catch (Exception $e) {
    // Si falla, el menú simplemente no carga, pero no rompe el sitio
}

// Función helper para seguridad visual
function h($s) { return htmlspecialchars($s, ENT_QUOTES, 'UTF-8'); }
?>

<nav class="pcoded-navbar">
    <div class="nav-list">
        <div class="pcoded-inner-navbar main-menu">

            <div class="pcoded-navigation-label">Navegación</div>

            <ul class="pcoded-item pcoded-left-item">
                
                <?php foreach ($arbolMenu as $nombreGrupo => $items): ?>
                    
                    <?php 
                        // Lógica para mantener desplegado el grupo si estamos en una de sus páginas
                        $isActiveGroup = false;
                        $iconGrupo = $items[0]['Icono']; // Icono del padre
                        
                        foreach($items as $check) {
                            // Comparamos nombre del archivo actual con el Link de la BD
                            if(basename($_SERVER['PHP_SELF']) == $check['Link']) { 
                                $isActiveGroup = true; 
                            }
                        }
                        $classOpen = $isActiveGroup ? 'active pcoded-trigger' : '';
                    ?>

                    <li class="pcoded-hasmenu <?= $classOpen ?>">
                        <a href="javascript:void(0)" class="waves-effect waves-dark">
                            <span class="pcoded-micon"><i class="<?= ($iconGrupo) ?>"></i></span>
                            <span class="pcoded-mtext"><?= h($nombreGrupo) ?></span>
                        </a>

                        <ul class="pcoded-submenu">
                            <?php foreach ($items as $item): ?>
                                <?php 
                                    $activeLink = (basename($_SERVER['PHP_SELF']) == $item['Link']) ? 'active' : ''; 
                                ?>
                                <li class="<?= $activeLink ?>">
                                    <a href="javascript:void(0);" 
   onclick="navegarConPost('<?= h($item['Link']) ?>', '<?= h($item['Icono']) ?>', '<?= h($item['Descripcion']) ?>')" 
   title="<?= h($item['Descripcion']) ?>">
                                        <span class="pcoded-mtext"><?= h($item['NombreMenu']) ?></span>
                                    </a>
                                </li>
                            <?php endforeach; ?>
                        </ul>
                    </li>

                <?php endforeach; ?>

            </ul>
        </div>
    </div>
</nav>

<form id="formNavegacion" method="POST" action="" style="display:none;">
    <input type="hidden" name="icono_post" id="inputIcono">
    <input type="hidden" name="descripcion_post" id="inputDescripcion">
</form>

<script>
function navegarConPost(url, icono, descripcion) {
    // 1. Asigna la URL destino al formulario
    document.getElementById('formNavegacion').action = url;
    
    // 2. Llena los datos ocultos
    document.getElementById('inputIcono').value = icono;
    document.getElementById('inputDescripcion').value = descripcion;
    
    // 3. Envía el formulario
    document.getElementById('formNavegacion').submit();
}
</script>